/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import git4idea.GitLocalBranch;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitVcsSettings;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\u001a2\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\t0\bH\u0001\u00a8\u0006\n"}, d2={"collectRecentCheckoutBranches", "", "Lgit4idea/GitLocalBranch;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "haveLocalBranch", "Lkotlin/Function1;", "", "intellij.vcs.git"})
@JvmName(name="GitRecentCheckoutBranches")
@SourceDebugExtension(value={"SMAP\nGitRecentCheckoutBranches.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRecentCheckoutBranches.kt\ngit4idea/repo/GitRecentCheckoutBranches\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class GitRecentCheckoutBranches {
    @RequiresBackgroundThread
    @NotNull
    public static final List<GitLocalBranch> collectRecentCheckoutBranches(@NotNull Project project, @NotNull VirtualFile root, @NotNull Function1<? super GitLocalBranch, Boolean> haveLocalBranch) {
        GitLocalBranch gitLocalBranch;
        String[] p0;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(haveLocalBranch, (String)"haveLocalBranch");
        String[] stringArray = (String[])GitVcsSettings.getInstance((Project)project).getRecentBranchesByRepository().get(root.getPath());
        if (stringArray != null) {
            p0 = stringArray;
            boolean bl = false;
            gitLocalBranch = new GitLocalBranch((String)p0);
        } else {
            gitLocalBranch = null;
        }
        GitLocalBranch recentBranchFromSettings = gitLocalBranch;
        int reflogEntriesCount = Registry.Companion.intValue("git.recent.checkout.branches.reflog.entries.count");
        if (reflogEntriesCount <= 0) {
            return CollectionsKt.emptyList();
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.REF_LOG);
        handler.setSilent(true);
        p0 = new String[]{"--max-count", String.valueOf(reflogEntriesCount), "--grep-reflog", "checkout:"};
        handler.addParameters(p0);
        handler.endOptions();
        handler.setEnableInteractiveCallbacks(false);
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
        GitCommandResult result2 = gitCommandResult;
        if (!result2.success()) {
            return CollectionsKt.emptyList();
        }
        LinkedHashSet<GitLocalBranch> branches = new LinkedHashSet<GitLocalBranch>();
        boolean recentBranchFromSettingsAdded = false;
        String toClause = " to ";
        for (String line : result2.getOutput()) {
            String branchName;
            Intrinsics.checkNotNull((Object)line);
            int toIndex = StringsKt.lastIndexOf$default((CharSequence)line, (String)toClause, (int)0, (boolean)false, (int)6, null);
            if (toIndex <= 0) continue;
            Intrinsics.checkNotNullExpressionValue((Object)line.substring(toIndex + toClause.length(), line.length()), (String)"substring(...)");
            GitLocalBranch localBranch = new GitLocalBranch(branchName);
            if (!((Boolean)haveLocalBranch.invoke((Object)localBranch)).booleanValue()) continue;
            GitLocalBranch gitLocalBranch2 = recentBranchFromSettings;
            if (Intrinsics.areEqual((Object)(gitLocalBranch2 != null ? gitLocalBranch2.getName() : null), (Object)branchName)) {
                recentBranchFromSettingsAdded = true;
            }
            branches.add(localBranch);
        }
        if (recentBranchFromSettings != null && !recentBranchFromSettingsAdded && ((Boolean)haveLocalBranch.invoke((Object)recentBranchFromSettings)).booleanValue()) {
            branches.add(recentBranchFromSettings);
        }
        return CollectionsKt.toList((Iterable)branches);
    }
}

