/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.base;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.DataSourceRunConfiguration;
import com.intellij.database.dialects.base.DataSourceRunConfigurationOptions;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.SqlNavigationUtils;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.JBIterable;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00030\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\b\u0012\u0004\u0012\u0002H\u00010\u0005B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J+\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014\u00a2\u0006\u0002\u0010\u0010J+\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00028\u0001H$\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0014H$J$\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH$J\u0014\u0010\u001d\u001a\u0004\u0018\u00010\u00142\b\u0010\u001e\u001a\u0004\u0018\u00010\u000fH\u0002J\u001d\u0010\u001f\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010 J\u001c\u0010!\u001a\u00020\t2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010#H\u0016J\u0018\u0010%\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0016\u00a8\u0006&"}, d2={"Lcom/intellij/database/dialects/base/DataSourceConfigurationProducer;", "T", "Lcom/intellij/database/dialects/base/DataSourceRunConfiguration;", "O", "Lcom/intellij/database/dialects/base/DataSourceRunConfigurationOptions;", "Lcom/intellij/execution/actions/LazyRunConfigurationProducer;", "<init>", "()V", "setupConfigurationFromContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/database/dialects/base/DataSourceRunConfiguration;Lcom/intellij/execution/actions/ConfigurationContext;Lcom/intellij/openapi/util/Ref;)Z", "setUpFromSelection", "elements", "Lcom/intellij/util/containers/JBIterable;", "Lcom/intellij/database/psi/DbElement;", "options", "(Lcom/intellij/execution/actions/ConfigurationContext;Lcom/intellij/util/containers/JBIterable;Lcom/intellij/database/dialects/base/DataSourceRunConfigurationOptions;)Z", "isTestElement", "element", "getContextElements", "isSuitableDbms", "dbms", "Lcom/intellij/database/Dbms;", "getDbElement", "e", "isConfigurationFromContext", "(Lcom/intellij/database/dialects/base/DataSourceRunConfiguration;Lcom/intellij/execution/actions/ConfigurationContext;)Z", "isPreferredConfiguration", "self", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "other", "shouldReplace", "intellij.database.dialects.base.ex"})
public abstract class DataSourceConfigurationProducer<T extends DataSourceRunConfiguration<O>, O extends DataSourceRunConfigurationOptions>
extends LazyRunConfigurationProducer<T> {
    protected boolean setupConfigurationFromContext(@NotNull T configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        JBIterable sel = this.getContextElements(context, sourceElement).filter(arg_0 -> DataSourceConfigurationProducer.setupConfigurationFromContext$lambda$1(arg_0 -> DataSourceConfigurationProducer.setupConfigurationFromContext$lambda$0(this, arg_0), arg_0)).collect();
        boolean bl = false;
        DbElement dbElement = (DbElement)sel.first();
        DbDataSource ds = dbElement != null ? dbElement.getDataSource() : null;
        JBIterable jBIterable = sel.filter(arg_0 -> DataSourceConfigurationProducer.setupConfigurationFromContext$lambda$2$1(arg_0 -> DataSourceConfigurationProducer.setupConfigurationFromContext$lambda$2$0(ds, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"let(...)");
        JBIterable elements = jBIterable;
        DbElement dbElement2 = (DbElement)elements.first();
        if (dbElement2 == null) {
            return false;
        }
        DbElement any = dbElement2;
        Object object = ReflectionUtil.newInstance(((DataSourceRunConfiguration)((Object)configuration)).getState().getClass());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newInstance(...)");
        DataSourceRunConfigurationOptions options = (DataSourceRunConfigurationOptions)((Object)object);
        options.setDataSourceId(any.getDataSource().getUniqueId());
        if (!this.setUpFromSelection(context, (JBIterable<DbElement>)elements, options)) {
            return false;
        }
        configuration.loadState((Object)options);
        configuration.setGeneratedName();
        return true;
    }

    protected abstract boolean setUpFromSelection(@NotNull ConfigurationContext var1, @NotNull JBIterable<DbElement> var2, @NotNull O var3);

    protected abstract boolean isTestElement(@NotNull DbElement var1);

    private final JBIterable<DbElement> getContextElements(ConfigurationContext context, Ref<PsiElement> sourceElement) {
        JBIterable jBIterable;
        if (context.containsMultipleSelection()) {
            DataContext dataContext = context.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            jBIterable = DatabaseContextFun.getSelectedDbElementsWithParentsForGroups((DataContext)dataContext);
        } else {
            JBIterable jBIterable2 = JBIterable.of((Object)this.getDbElement((PsiElement)sourceElement.get()));
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"of(...)");
        }
        return jBIterable;
    }

    protected abstract boolean isSuitableDbms(@NotNull Dbms var1);

    private final DbElement getDbElement(PsiElement e) {
        Dbms dbms = SqlPsiUtilKt.getSqlDialect((PsiElement)e).getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        if (!this.isSuitableDbms(dbms)) {
            return null;
        }
        if (e instanceof DbElement) {
            return (DbElement)e;
        }
        SqlDefinition definition = (SqlDefinition)PsiTreeUtil.getParentOfType((PsiElement)e, SqlDefinition.class);
        if (definition == null) {
            return null;
        }
        return (DbElement)SqlNavigationUtils.findRelatedDbElements((PsiElement)((PsiElement)definition), (boolean)true).first();
    }

    public boolean isConfigurationFromContext(@NotNull T configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return false;
    }

    public boolean isPreferredConfiguration(@Nullable ConfigurationFromContext self, @Nullable ConfigurationFromContext other) {
        return true;
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return true;
    }

    private static final boolean setupConfigurationFromContext$lambda$0(DataSourceConfigurationProducer this$0, DbElement it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.isTestElement(it);
    }

    private static final boolean setupConfigurationFromContext$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean setupConfigurationFromContext$lambda$2$0(DbDataSource $ds, DbElement it) {
        return Intrinsics.areEqual((Object)it.getDataSource(), (Object)$ds);
    }

    private static final boolean setupConfigurationFromContext$lambda$2$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

