/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.converters;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.integration.model.xml.core.CorrelatingMessageHandlerType;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.converters.SpringBeanMethodConverter;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import java.util.Collection;

public class ReleaseStrategyMethodConverter
extends SpringBeanMethodConverter {
    protected final boolean checkParameterList(PsiMethod method) {
        return true;
    }

    protected final boolean checkReturnType(ConvertContext context, PsiMethod method, boolean forCompletion) {
        PsiType returnType = method.getReturnType();
        return returnType != null && (PsiTypes.booleanType().equals((Object)returnType) || "java.lang.Boolean".equals(returnType.getCanonicalText()));
    }

    protected PsiClass getPsiClass(ConvertContext context) {
        Collection types;
        CorrelatingMessageHandlerType correlatingMessageHandlerType = (CorrelatingMessageHandlerType)DomUtil.getParentOfType((DomElement)context.getInvocationElement(), CorrelatingMessageHandlerType.class, (boolean)false);
        if (correlatingMessageHandlerType == null) {
            return null;
        }
        SpringBeanPointer springBeanPointer = (SpringBeanPointer)correlatingMessageHandlerType.getReleaseStrategy().getValue();
        if (springBeanPointer != null && !(types = springBeanPointer.getEffectiveBeanTypes()).isEmpty()) {
            return PsiTypesUtil.getPsiClass((PsiType)((PsiType)types.iterator().next()));
        }
        return null;
    }
}

