/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.platform.free;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public abstract class JakartaFreeImplicitUsageProvider
implements ImplicitUsageProvider {
    private static boolean isFreeMode() {
        return PluginManagerCore.isDisabled((PluginId)PluginManagerCore.ULTIMATE_PLUGIN_ID);
    }

    public boolean isImplicitUsage(@NotNull PsiElement element) {
        PsiModifierListOwner psiModifierListOwner;
        PsiClass psiClass;
        if (element == null) {
            JakartaFreeImplicitUsageProvider.$$$reportNull$$$0(0);
        }
        if (!JakartaFreeImplicitUsageProvider.isFreeMode()) {
            return false;
        }
        if (!this.hasLibrary(element)) {
            return false;
        }
        if (element instanceof PsiClass && AnnotationUtil.isAnnotated((PsiModifierListOwner)(psiClass = (PsiClass)element), this.getImplicitUsageClassAnnotations(), (int)0)) {
            return true;
        }
        if (element instanceof PsiModifierListOwner && AnnotationUtil.isAnnotated((PsiModifierListOwner)(psiModifierListOwner = (PsiModifierListOwner)element), this.getImplicitUsageMemberAnnotations(), (int)0)) {
            return true;
        }
        return this.isImplicitRead(element) || this.isImplicitWrite(element);
    }

    @NotNull
    protected @Unmodifiable Collection<String> getImplicitUsageMemberAnnotations() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            JakartaFreeImplicitUsageProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    protected boolean hasLibrary(@NotNull PsiElement element) {
        if (element == null) {
            JakartaFreeImplicitUsageProvider.$$$reportNull$$$0(2);
        }
        return true;
    }

    protected abstract Collection<String> getImplicitUsageClassAnnotations();

    protected abstract Collection<String> getReadAnnotations();

    protected abstract Collection<String> getWriteAnnotations();

    public boolean isImplicitRead(@NotNull PsiElement element) {
        if (element == null) {
            JakartaFreeImplicitUsageProvider.$$$reportNull$$$0(3);
        }
        if (!JakartaFreeImplicitUsageProvider.isFreeMode()) {
            return false;
        }
        if (!(element instanceof PsiModifierListOwner)) {
            return false;
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), this.getReadAnnotations(), (int)0);
    }

    public boolean isImplicitWrite(@NotNull PsiElement element) {
        if (element == null) {
            JakartaFreeImplicitUsageProvider.$$$reportNull$$$0(4);
        }
        if (!JakartaFreeImplicitUsageProvider.isFreeMode()) {
            return false;
        }
        return element instanceof PsiModifierListOwner && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)element), this.getWriteAnnotations(), (int)0);
    }

    @NotNull
    protected static List<String> mapJavaeeClasses(Collection<JavaeeClass> javaeeClasses) {
        ArrayList<String> annotations = new ArrayList<String>();
        for (JavaeeClass javaeeClass : javaeeClasses) {
            annotations.add(javaeeClass.javax());
            annotations.add(javaeeClass.jakarta());
        }
        List<String> list = List.copyOf(annotations);
        if (list == null) {
            JakartaFreeImplicitUsageProvider.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/platform/free/JakartaFreeImplicitUsageProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/platform/free/JakartaFreeImplicitUsageProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitUsageMemberAnnotations";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "mapJavaeeClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitUsage";
                break;
            }
            case 1: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hasLibrary";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitRead";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isImplicitWrite";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5 -> new IllegalStateException(string);
        };
    }
}

