/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom.annotation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.PlotContext;
import org.jetbrains.letsPlot.core.plot.base.geom.annotation.Annotation;
import org.jetbrains.letsPlot.core.plot.base.geom.annotation.AnnotationUtil;
import org.jetbrains.letsPlot.core.plot.base.tooltip.LineSpec;
import org.jetbrains.letsPlot.datamodel.svg.style.TextStyle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u001a\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/annotation/Annotation;", "", "lines", "", "Lorg/jetbrains/letsPlot/core/plot/base/tooltip/LineSpec;", "textStyle", "Lorg/jetbrains/letsPlot/datamodel/svg/style/TextStyle;", "useCustomColor", "", "useLayerColor", "(Ljava/util/List;Lorg/jetbrains/letsPlot/datamodel/svg/style/TextStyle;ZZ)V", "getTextStyle", "()Lorg/jetbrains/letsPlot/datamodel/svg/style/TextStyle;", "getAnnotationText", "", "index", "", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/PlotContext;", "getTextColor", "Lorg/jetbrains/letsPlot/commons/values/Color;", "layerColor", "layerFill", "plot-base"})
@SourceDebugExtension(value={"SMAP\nAnnotation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Annotation.kt\norg/jetbrains/letsPlot/core/plot/base/geom/annotation/Annotation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,34:1\n1603#2,9:35\n1855#2:44\n1856#2:46\n1612#2:47\n1#3:45\n*S KotlinDebug\n*F\n+ 1 Annotation.kt\norg/jetbrains/letsPlot/core/plot/base/geom/annotation/Annotation\n*L\n22#1:35,9\n22#1:44\n22#1:46\n22#1:47\n22#1:45\n*E\n"})
public final class Annotation {
    @NotNull
    private final List<LineSpec> lines;
    @NotNull
    private final TextStyle textStyle;
    private final boolean useCustomColor;
    private final boolean useLayerColor;

    public Annotation(@NotNull List<? extends LineSpec> lines, @NotNull TextStyle textStyle, boolean useCustomColor, boolean useLayerColor) {
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        Intrinsics.checkNotNullParameter((Object)textStyle, (String)"textStyle");
        this.lines = lines;
        this.textStyle = textStyle;
        this.useCustomColor = useCustomColor;
        this.useLayerColor = useLayerColor;
    }

    @NotNull
    public final TextStyle getTextStyle() {
        return this.textStyle;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getAnnotationText(int index, @NotNull PlotContext ctx2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        Iterable $this$mapNotNull$iv = this.lines;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            LineSpec.DataPoint it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            LineSpec line2 = (LineSpec)element$iv$iv;
            boolean bl2 = false;
            if (line2.getDataPoint(index, ctx2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)getAnnotationText.2.INSTANCE), (int)30, null);
    }

    @NotNull
    public final Color getTextColor(@Nullable Color layerColor, @Nullable Color layerFill) {
        Color color;
        if (this.useLayerColor) {
            color = layerColor;
            if (color == null) {
                color = this.textStyle.getColor();
            }
        } else {
            color = this.useCustomColor ? this.textStyle.getColor() : (layerFill == null ? this.textStyle.getColor() : AnnotationUtil.INSTANCE.chooseColor(layerFill));
        }
        return color;
    }
}

