/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.clikt.output;

import com.github.ajalt.clikt.core.CliktError;
import com.github.ajalt.clikt.output.Editor;
import com.github.ajalt.clikt.output.EditorKt;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B3\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000b\u001a\u00020\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J#\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00112\u0006\u0010\u000e\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011H\u0002\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0003H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/github/ajalt/clikt/output/Editor;", "", "editorPath", "", "env", "", "requireSave", "", "extension", "(Ljava/lang/String;Ljava/util/Map;ZLjava/lang/String;)V", "edit", "text", "editFile", "", "filename", "editFileWithEditor", "editorCmd", "", "([Ljava/lang/String;Ljava/lang/String;)V", "getEditorCommand", "()[Ljava/lang/String;", "getEditorPath", "clikt"})
public final class Editor {
    private final String editorPath;
    private final Map<String, String> env;
    private final boolean requireSave;
    private final String extension;

    private final String getEditorPath() {
        String string = this.editorPath;
        if (string == null) {
            string = EditorKt.inferEditorPath((Function1<? super String, Boolean>)((Function1)getEditorPath.1.INSTANCE));
        }
        return string;
    }

    private final String[] getEditorCommand() {
        String string = this.getEditorPath();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)((Object)StringsKt.trim((CharSequence)string2)).toString(), (String[])new String[]{" "}, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return stringArray;
    }

    private final void editFileWithEditor(String[] editorCmd, String filename) {
        try {
            SpreadBuilder spreadBuilder = new SpreadBuilder(2);
            spreadBuilder.addSpread((Object)editorCmd);
            spreadBuilder.add((Object)filename);
            ProcessBuilder processBuilder = new ProcessBuilder((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
            boolean bl = false;
            boolean bl2 = false;
            ProcessBuilder $this$apply = processBuilder;
            boolean bl3 = false;
            Map<String, String> map = $this$apply.environment();
            Map<String, String> map2 = this.env;
            boolean bl4 = false;
            map.putAll(map2);
            $this$apply.inheritIO();
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                throw (Throwable)new CliktError(editorCmd[0] + ": Editing failed!", null, 2, null);
            }
        }
        catch (Exception err) {
            Exception exception = err;
            if (exception instanceof CliktError) {
                throw (Throwable)err;
            }
            throw (Throwable)new CliktError("Error staring editor", err);
        }
    }

    public final void editFile(@NotNull String filename) {
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        this.editFileWithEditor(this.getEditorCommand(), filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String edit(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        String[] editorCmd = this.getEditorCommand();
        String textToEdit = EditorKt.normalizeEditorText(editorCmd[0], text);
        File file = FilesKt.createTempFile$default(null, (String)this.extension, null, (int)5, null);
        try {
            FilesKt.writeText$default((File)file, (String)textToEdit, null, (int)2, null);
            long ts = file.lastModified();
            String string = file.getCanonicalPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.canonicalPath");
            this.editFileWithEditor(editorCmd, string);
            if (this.requireSave && file.lastModified() == ts) {
                String string2 = null;
                return string2;
            }
            String string3 = StringsKt.replace$default((String)FilesKt.readText$default((File)file, null, (int)1, null), (String)"\r\n", (String)"\n", (boolean)false, (int)4, null);
            return string3;
        }
        catch (Exception err) {
            throw (Throwable)new CliktError("Error staring editor", err);
        }
        finally {
            file.delete();
        }
    }

    public Editor(@Nullable String editorPath, @NotNull Map<String, String> env, boolean requireSave, @NotNull String extension) {
        Intrinsics.checkParameterIsNotNull(env, (String)"env");
        Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
        this.editorPath = editorPath;
        this.env = env;
        this.requireSave = requireSave;
        this.extension = extension;
    }
}

