/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.config.webXml;

import com.intellij.javaee.model.xml.ParamValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.DomPatterns;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.impl.source.resolve.reference.impl.manipulators.XmlTagManipulator;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.model.utils.resources.SpringResourcesBuilder;
import com.intellij.spring.model.utils.resources.SpringResourcesUtil;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.text.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringWebConfigLocationReferenceContributor
extends PsiReferenceContributor {
    @NonNls
    private static final String CONTEXT_PARAM = "context-param";
    @NonNls
    private static final String INIT_PARAM = "init-param";

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            SpringWebConfigLocationReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider((ElementPattern)((XmlTagPattern.Capture)XmlPatterns.xmlTag().withLocalName("param-value")).withParent(StandardPatterns.or((ElementPattern[])new ElementPattern[]{DomPatterns.tagWithDom((String)CONTEXT_PARAM, ParamValue.class), DomPatterns.tagWithDom((String)INIT_PARAM, ParamValue.class)})), (PsiReferenceProvider)new SpringWebConfigLocationReferenceProvider());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/spring/mvc/config/webXml/SpringWebConfigLocationReferenceContributor", "registerReferenceProviders"));
    }

    private static class SpringWebConfigLocationReferenceProvider
    extends PsiReferenceProvider {
        private SpringWebConfigLocationReferenceProvider() {
        }

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            TextRange[] ranges;
            XmlTag tag;
            XmlTag parent;
            if (element == null) {
                SpringWebConfigLocationReferenceProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                SpringWebConfigLocationReferenceProvider.$$$reportNull$$$0(1);
            }
            if ((parent = (tag = (XmlTag)element).getParentTag()) == null || !parent.getName().equals(SpringWebConfigLocationReferenceContributor.CONTEXT_PARAM) && !parent.getName().equals(SpringWebConfigLocationReferenceContributor.INIT_PARAM)) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    SpringWebConfigLocationReferenceProvider.$$$reportNull$$$0(2);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            XmlTag nameTag = parent.findFirstSubTag("param-name");
            if (nameTag == null) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    SpringWebConfigLocationReferenceProvider.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            String name = ElementManipulators.getValueText((PsiElement)nameTag);
            if (!name.equals("contextConfigLocation")) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    SpringWebConfigLocationReferenceProvider.$$$reportNull$$$0(4);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            if (SpringWebConfigLocationReferenceProvider.isAnnotationConfig(parent)) {
                if (PsiReference.EMPTY_ARRAY == null) {
                    SpringWebConfigLocationReferenceProvider.$$$reportNull$$$0(5);
                }
                return PsiReference.EMPTY_ARRAY;
            }
            Object[] result = PsiReference.EMPTY_ARRAY;
            for (TextRange range : ranges = XmlTagManipulator.getValueRanges((XmlTag)tag)) {
                String text = range.substring(element.getText());
                StringTokenizer tokenizer = new StringTokenizer(text, ",; \n\t");
                while (tokenizer.hasMoreTokens()) {
                    String s = tokenizer.nextToken();
                    int end = tokenizer.getCurrentPosition();
                    int offset = end - s.length() + range.getStartOffset();
                    SpringResourcesBuilder builder = SpringResourcesBuilder.create((PsiElement)element, (String)s).fromRoot(true).offset(offset).soft(false);
                    Object[] references = SpringResourcesUtil.getInstance().getReferences(builder);
                    result = (PsiReference[])ArrayUtil.mergeArrays((Object[])result, (Object[])references, (ArrayFactory)PsiReference.ARRAY_FACTORY);
                }
            }
            if (result == null) {
                SpringWebConfigLocationReferenceProvider.$$$reportNull$$$0(6);
            }
            return result;
        }

        private static boolean isAnnotationConfig(@NotNull XmlTag contextParamTag) {
            XmlTag parentTag;
            if (contextParamTag == null) {
                SpringWebConfigLocationReferenceProvider.$$$reportNull$$$0(7);
            }
            if ((parentTag = contextParamTag.getParentTag()) != null) {
                if ("web-app".equals(parentTag.getName())) {
                    return SpringWebConfigLocationReferenceProvider.hasAnnotationConfigDefined(parentTag.findSubTags(SpringWebConfigLocationReferenceContributor.CONTEXT_PARAM));
                }
                if ("servlet".equals(parentTag.getName())) {
                    return SpringWebConfigLocationReferenceProvider.hasAnnotationConfigDefined(parentTag.findSubTags(SpringWebConfigLocationReferenceContributor.INIT_PARAM));
                }
            }
            return false;
        }

        private static boolean hasAnnotationConfigDefined(XmlTag[] contextParams) {
            for (XmlTag contextParam : contextParams) {
                XmlTag valueTag;
                String name;
                XmlTag nameTag = contextParam.findFirstSubTag("param-name");
                if (nameTag == null || !(name = ElementManipulators.getValueText((PsiElement)nameTag)).equals("contextClass") || (valueTag = contextParam.findFirstSubTag("param-value")) == null) continue;
                return "org.springframework.web.context.support.AnnotationConfigWebApplicationContext".equals(ElementManipulators.getValueText((PsiElement)valueTag));
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/mvc/config/webXml/SpringWebConfigLocationReferenceContributor$SpringWebConfigLocationReferenceProvider";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contextParamTag";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/mvc/config/webXml/SpringWebConfigLocationReferenceContributor$SpringWebConfigLocationReferenceProvider";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isAnnotationConfig";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

