/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.diagnostics;

import com.intellij.ml.diagnostics.DiagnosticEventBusKt;
import com.intellij.ml.diagnostics.FeatureDiagnosticEvent;
import com.intellij.ml.diagnostics.FeatureDiagnosticLogger;
import com.intellij.ml.diagnostics.TextMessage;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u001a\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0016J\u0016\u0010\u0012\u001a\u00020\r2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0016\u00c0\u0006\u0001"}, d2={"Lcom/intellij/ml/diagnostics/TextDiagnosticsLogger;", "Lcom/intellij/ml/diagnostics/FeatureDiagnosticLogger;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "withFeature", "", "errorIfNotMessage", "", "throwable", "", "error", "", "message", "debug", "info", "warn", "trace", "producer", "Lkotlin/Function0;", "sendTextMessage", "intellij.ml.diagnostics"})
public interface TextDiagnosticsLogger
extends FeatureDiagnosticLogger {
    @NotNull
    public Logger getLog();

    private String withFeature(String $this$withFeature) {
        return "[" + this.getFeature().getDisplayName() + "] " + $this$withFeature;
    }

    default public boolean errorIfNotMessage(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        boolean errorLogged = Promises.errorIfNotMessage((Logger)this.getLog(), (Throwable)throwable);
        if (errorLogged) {
            this.sendTextMessage(throwable.toString());
        }
        return errorLogged;
    }

    default public void error(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        this.getLog().error(this.withFeature(""), throwable);
        this.sendTextMessage(throwable.toString());
    }

    @Override
    default public void error(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getLog().error(this.withFeature(message), throwable);
        this.sendTextMessage(message);
    }

    @Override
    default public void debug(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug(this.withFeature(message));
        }
        this.sendTextMessage(message);
    }

    @Override
    default public void info(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getLog().info(this.withFeature(message));
        this.sendTextMessage(message);
    }

    @Override
    default public void warn(@NotNull String message, @Nullable Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getLog().warn(this.withFeature(message), throwable);
        this.sendTextMessage(message);
    }

    @Override
    default public void trace(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.getLog().trace(this.withFeature(message));
        this.sendTextMessage(message);
    }

    default public void trace(@NotNull Function0<String> producer) {
        Intrinsics.checkNotNullParameter(producer, (String)"producer");
        if (this.getLog().isTraceEnabled()) {
            this.trace((String)producer.invoke());
        }
    }

    private void sendTextMessage(String message) {
        DiagnosticEventBusKt.fireDiagnosticEvent((Function0<? extends FeatureDiagnosticEvent>)((Function0)() -> TextDiagnosticsLogger.sendTextMessage$lambda$0(message, this)));
    }

    private static FeatureDiagnosticEvent sendTextMessage$lambda$0(String $message, TextDiagnosticsLogger this$0) {
        return new TextMessage($message, this$0.getFeature().getFeatureId(), 0L, 4, null);
    }
}

