/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.database.console.RemoteConsoleProcessSupport;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.execution.rmi.RemoteProcessSupport;
import com.intellij.jpa.engine.JpaConnectionManager;
import com.intellij.jpa.engine.JpaRemoteConsoleProcessSupport;
import com.intellij.jpa.remote.JpaFacade;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.ModificationTrackerListener;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.util.EventDispatcher;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JpaConnectionManagerImpl
extends JpaConnectionManager
implements Disposable {
    private final EventDispatcher<ModificationTrackerListener> myDispatcher = EventDispatcher.create(ModificationTrackerListener.class);
    private final RemoteConsoleProcessSupport<PersistencePackagePointer, JpaFacade> mySupport;

    public JpaConnectionManagerImpl(Project project) {
        Runnable fireModificationCountChanged = () -> {
            this.incModificationCount();
            ApplicationManager.getApplication().invokeLater(() -> ((ModificationTrackerListener)this.myDispatcher.getMulticaster()).modificationCountChanged((Object)this));
        };
        this.mySupport = new JpaRemoteConsoleProcessSupport(project, fireModificationCountChanged);
        Disposer.register((Disposable)this, this.mySupport);
    }

    public void dispose() {
    }

    @Override
    public List<ConsoleRunConfiguration> getActiveConfigurations(@NotNull PersistencePackagePointer unitFile) {
        if (unitFile == null) {
            JpaConnectionManagerImpl.$$$reportNull$$$0(0);
        }
        return this.mySupport.getActiveConfigurations((Object)unitFile);
    }

    @Override
    public JpaFacade getConnection(@NotNull PersistencePackagePointer unitFile, @NotNull ConsoleRunConfiguration configuration) throws Exception {
        if (unitFile == null) {
            JpaConnectionManagerImpl.$$$reportNull$$$0(1);
        }
        if (configuration == null) {
            JpaConnectionManagerImpl.$$$reportNull$$$0(2);
        }
        return (JpaFacade)this.mySupport.acquire((Object)unitFile, (Object)configuration);
    }

    @Override
    public void releaseConnection(@NotNull PersistencePackagePointer unitFile, @Nullable ConsoleRunConfiguration configuration) {
        if (unitFile == null) {
            JpaConnectionManagerImpl.$$$reportNull$$$0(3);
        }
        try {
            this.mySupport.release((Object)unitFile, (Object)configuration).get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            RemoteProcessSupport.LOG.warn((Throwable)e);
        }
    }

    @Override
    public ModificationTracker getModificationTracker() {
        return this;
    }

    @Override
    public void addModificationTrackerListener(ModificationTrackerListener<JpaConnectionManager> listener, Disposable disposable) {
        this.myDispatcher.addListener(listener, disposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/engine/JpaConnectionManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getActiveConfigurations";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getConnection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "releaseConnection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

