/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.datum;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.locationtech.proj4j.datum.Grid;
import org.locationtech.proj4j.util.FloatPolarCoordinate;
import org.locationtech.proj4j.util.IntPolarCoordinate;
import org.locationtech.proj4j.util.PolarCoordinate;

public final class NTV2 {
    private static final byte[] MAGIC = "NUM_OREC".getBytes(StandardCharsets.US_ASCII);
    private static final double SEC_RAD = 4.84813681109536E-6;
    private static final int HEADER_SIZE = 176;
    private static final int SUB_HEADER_SIZE = 176;
    private static final int VALUES_PER_CELL = 4;
    private static final int NUM_OREC = 8;
    private static final int S_LAT = 72;
    private static final int N_LAT = 88;
    private static final int E_LONG = 104;
    private static final int W_LONG = 120;
    private static final int LAT_INC = 136;
    private static final int LONG_INC = 152;

    public static boolean testHeader(byte[] header) {
        byte[] start2 = Arrays.copyOfRange(header, 0, MAGIC.length);
        return Arrays.equals(start2, MAGIC);
    }

    public static Grid.ConversionTable init(DataInputStream instream) throws IOException {
        byte[] buf = new byte[176];
        instream.readFully(buf);
        if (!NTV2.testHeader(buf)) {
            throw new Error("Not a NTv2 file");
        }
        ByteOrder endian = NTV2.guessByteOrder(buf);
        buf = new byte[176];
        instream.readFully(buf);
        Grid.ConversionTable table = new Grid.ConversionTable();
        table.id = "NTv2 Grid Shift File";
        table.ll = new PolarCoordinate(-NTV2.doubleFromBytes(buf, 120, endian) * 4.84813681109536E-6, NTV2.doubleFromBytes(buf, 72, endian) * 4.84813681109536E-6);
        PolarCoordinate ur = new PolarCoordinate(-NTV2.doubleFromBytes(buf, 104, endian) * 4.84813681109536E-6, NTV2.doubleFromBytes(buf, 88, endian) * 4.84813681109536E-6);
        table.del = new PolarCoordinate(NTV2.doubleFromBytes(buf, 152, endian) * 4.84813681109536E-6, NTV2.doubleFromBytes(buf, 136, endian) * 4.84813681109536E-6);
        table.lim = new IntPolarCoordinate((int)(Math.abs(ur.lam - table.ll.lam) / table.del.lam + 0.5) + 1, (int)(Math.abs(ur.phi - table.ll.phi) / table.del.phi + 0.5) + 1);
        return table;
    }

    public static void load(DataInputStream instream, Grid grid) throws IOException {
        int cols = grid.table.lim.lam;
        int rows = grid.table.lim.phi;
        byte[] buf = new byte[176];
        instream.readFully(buf);
        ByteOrder endian = NTV2.guessByteOrder(buf);
        instream.skipBytes(176);
        FloatPolarCoordinate[] tmp_cvs = new FloatPolarCoordinate[cols * rows];
        float[] row_buff = new float[cols * 4];
        byte[] byteBuff = new byte[row_buff.length * 4];
        for (int row = 0; row < rows; ++row) {
            instream.readFully(byteBuff);
            ByteBuffer.wrap(byteBuff).order(endian).asFloatBuffer().get(row_buff);
            for (int col = 0; col < cols; ++col) {
                tmp_cvs[row * cols + (cols - col - 1)] = new FloatPolarCoordinate((float)((double)row_buff[4 * col + 1] * 4.84813681109536E-6), (float)((double)row_buff[4 * col] * 4.84813681109536E-6));
            }
        }
        grid.table.cvs = tmp_cvs;
    }

    private static ByteOrder guessByteOrder(byte[] header) {
        ByteBuffer buffer = ByteBuffer.wrap(header, 8, 4);
        if (buffer.order(ByteOrder.BIG_ENDIAN).getInt() == 11) {
            return ByteOrder.BIG_ENDIAN;
        }
        buffer = ByteBuffer.wrap(header, 8, 4);
        if (buffer.order(ByteOrder.LITTLE_ENDIAN).getInt() == 11) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        throw new Error("Could not determine endianness");
    }

    private static double doubleFromBytes(byte[] b, int offset, ByteOrder order) {
        return ByteBuffer.wrap(b, offset, 8).order(order).getDouble();
    }
}

