/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.config;

import com.intellij.javaee.oss.jboss.config.JBossConfigProcessor;
import com.intellij.javaee.oss.jboss.server.JBossServerModel;
import com.intellij.javaee.oss.jboss.version.JBossVersion7Handler;
import com.intellij.javaee.oss.util.CachedConfig;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;

public class Jboss7DomainHostConfig
extends CachedConfig<JBossServerModel> {
    private static final Map<CachedConfig.Key, Jboss7DomainHostConfig> ourCache = new HashMap<CachedConfig.Key, Jboss7DomainHostConfig>();
    private static final CachedConfig.Factory<JBossServerModel, Jboss7DomainHostConfig> ourFactory = new CachedConfig.Factory<JBossServerModel, Jboss7DomainHostConfig>(){

        @NotNull
        public CachedConfig.Key createKey(JBossServerModel data) {
            return new CachedConfig.Key(new String[]{data.getHome()});
        }

        @NotNull
        public Jboss7DomainHostConfig createConfig(JBossServerModel data) {
            return new Jboss7DomainHostConfig();
        }
    };
    private String myDomainHost;

    private static File getConfigFile(JBossServerModel data) {
        return JBossVersion7Handler.getDomainHostFile(data);
    }

    public static String getDomainHost(JBossServerModel model) {
        Jboss7DomainHostConfig instance = (Jboss7DomainHostConfig)Jboss7DomainHostConfig.get(ourCache, ourFactory, (Object)((Object)model));
        return instance == null ? "" : instance.myDomainHost;
    }

    protected long getStamp(JBossServerModel data) {
        return Jboss7DomainHostConfig.getStamp((File)Jboss7DomainHostConfig.getConfigFile(data));
    }

    protected void update(JBossServerModel data) {
        this.myDomainHost = (String)new JBossConfigProcessor<String>(this, "ns:host/@name", ""){

            @Override
            protected String process(XPath xpath, Document doc) throws JDOMException, IOException {
                return ((Attribute)xpath.selectSingleNode((Object)doc)).getValue();
            }
        }.get(Jboss7DomainHostConfig.getConfigFile(data));
    }
}

