/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.AfterSemicolonEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.BasicElementTypes;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBasicSemicolonFixer
implements Fixer {
    @Override
    public void apply(Editor editor, AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode astNode) throws IncorrectOperationException {
        PsiElement psiElement;
        if (astNode == null) {
            AbstractBasicSemicolonFixer.$$$reportNull$$$0(0);
        }
        if (this.fixReturn(editor, psiElement = BasicJavaAstTreeUtil.toPsi(astNode))) {
            return;
        }
        if (this.fixForUpdate(editor, astNode)) {
            return;
        }
        this.fixAfterLastValidElement(editor, astNode);
    }

    protected abstract boolean fixReturn(@NotNull Editor var1, @Nullable PsiElement var2);

    protected abstract boolean getSpaceAfterSemicolon(@NotNull PsiElement var1);

    private boolean fixForUpdate(@NotNull Editor editor, @Nullable ASTNode astNode) {
        if (editor == null) {
            AbstractBasicSemicolonFixer.$$$reportNull$$$0(1);
        }
        if (!BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_FOR_STATEMENT)) {
            return false;
        }
        ASTNode condition = BasicJavaAstTreeUtil.getForCondition(astNode);
        if (BasicJavaAstTreeUtil.getForUpdate(astNode) != null || condition == null) {
            return false;
        }
        TextRange range = condition.getTextRange();
        Document document = editor.getDocument();
        CharSequence text = document.getCharsSequence();
        int max = astNode.getTextRange().getEndOffset();
        for (int i = range.getEndOffset() - 1; i < max; ++i) {
            if (text.charAt(i) != ';') continue;
            return false;
        }
        Object toInsert = ";";
        PsiElement psiElement = BasicJavaAstTreeUtil.toPsi(astNode);
        if (psiElement != null && this.getSpaceAfterSemicolon(psiElement)) {
            toInsert = (String)toInsert + " ";
        }
        document.insertString(range.getEndOffset(), (CharSequence)toInsert);
        return true;
    }

    private void fixAfterLastValidElement(@NotNull Editor editor, @Nullable ASTNode astNode) {
        if (editor == null) {
            AbstractBasicSemicolonFixer.$$$reportNull$$$0(2);
        }
        PsiElement psiElement = BasicJavaAstTreeUtil.toPsi(astNode);
        if (astNode == null || psiElement == null) {
            return;
        }
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_EXPRESSION_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_DECLARATION_STATEMENT) || this.isImportStatementBase(psiElement) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_DO_WHILE_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_RETURN_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_THROW_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_BREAK_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_CONTINUE_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_YIELD_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_ASSERT_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_PACKAGE_STATEMENT) || AbstractBasicSemicolonFixer.isStandaloneField(psiElement) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_METHOD) && BasicJavaAstTreeUtil.getCodeBlock(astNode) == null && !AbstractBasicSemicolonFixer.isMethodShouldHaveBody(psiElement) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_REQUIRES_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_OPENS_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_EXPORTS_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_USES_STATEMENT) || BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_PROVIDES_STATEMENT)) {
            ASTNode error;
            String text = astNode.getText();
            int tailLength = 0;
            ASTNode leaf = TreeUtil.findLastLeaf((ASTNode)astNode);
            while (leaf != null && BasicElementTypes.BASIC_JAVA_COMMENT_OR_WHITESPACE_BIT_SET.contains(leaf.getElementType())) {
                tailLength += leaf.getTextLength();
                leaf = TreeUtil.prevLeaf((ASTNode)leaf);
            }
            if (leaf == null) {
                return;
            }
            if (tailLength > 0) {
                text = text.substring(0, text.length() - tailLength);
            }
            int insertionOffset = leaf.getTextRange().getEndOffset();
            Document doc = editor.getDocument();
            if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_FIELD) && BasicJavaAstTreeUtil.hasModifierProperty(astNode, JavaTokenType.ABSTRACT_KEYWORD)) {
                doc.insertString(insertionOffset, (CharSequence)"()");
                insertionOffset += "()".length();
            }
            if (BasicJavaAstTreeUtil.is(error = astNode.getLastChildNode(), TokenType.ERROR_ELEMENT) && BasicJavaAstTreeUtil.is(error.getTreePrev(), BasicJavaElementType.BASIC_INSTANCE_OF_EXPRESSION) && BasicJavaAstTreeUtil.is(error.getTreePrev().getLastChildNode(), BasicJavaElementType.BASIC_TYPE_TEST_PATTERN)) {
                PsiWhiteSpace ws;
                PsiElement psiElement2;
                ASTNode identifier;
                ASTNode variable = BasicJavaAstTreeUtil.getPatternVariable(error.getTreePrev().getLastChildNode());
                PsiElement skipWhitespacesForward = PsiTreeUtil.skipWhitespacesForward((PsiElement)psiElement);
                ASTNode assignmentExpr = BasicJavaAstTreeUtil.getExpression(BasicJavaAstTreeUtil.toNode(skipWhitespacesForward));
                if (variable != null && BasicJavaAstTreeUtil.is(BasicJavaAstTreeUtil.toNode(skipWhitespacesForward), BasicJavaElementType.BASIC_EXPRESSION_STATEMENT) && BasicJavaAstTreeUtil.is(assignmentExpr, BasicJavaElementType.BASIC_ASSIGNMENT_EXPRESSION) && JavaTokenType.EQ.equals(BasicJavaAstTreeUtil.getAssignmentOperationTokenType(assignmentExpr)) && (identifier = BasicJavaAstTreeUtil.getNameIdentifier(variable)) != null && (psiElement2 = BasicJavaAstTreeUtil.toPsi(identifier.getTreePrev())) instanceof PsiWhiteSpace && (ws = (PsiWhiteSpace)psiElement2).getText().contains("\n") && editor.getCaretModel().getOffset() < identifier.getTextRange().getStartOffset()) {
                    insertionOffset = ws.getTextRange().getStartOffset();
                }
            }
            if (!StringUtil.endsWithChar((CharSequence)text, (char)';')) {
                ASTNode parent = astNode.getTreeParent();
                Object toInsert = ";";
                if (BasicJavaAstTreeUtil.is(parent, BasicJavaElementType.BASIC_FOR_STATEMENT)) {
                    if (BasicJavaAstTreeUtil.getForUpdate(parent) == astNode) {
                        return;
                    }
                    if (this.getSpaceAfterSemicolon(psiElement)) {
                        toInsert = (String)toInsert + " ";
                    }
                }
                doc.insertString(insertionOffset, (CharSequence)toInsert);
            }
        }
    }

    private static boolean isMethodShouldHaveBody(@Nullable PsiElement psiElement) {
        return AfterSemicolonEnterProcessor.shouldHaveBody(BasicJavaAstTreeUtil.toNode(psiElement));
    }

    protected abstract boolean isImportStatementBase(@Nullable PsiElement var1);

    private static boolean isStandaloneField(@Nullable PsiElement psiElement) {
        if (psiElement == null || !BasicJavaAstTreeUtil.is(BasicJavaAstTreeUtil.toNode(psiElement), BasicJavaElementType.BASIC_FIELD)) {
            return false;
        }
        PsiElement node = PsiTreeUtil.nextLeaf((PsiElement)psiElement, (boolean)true);
        if (node == null) {
            return false;
        }
        return !",".equals(node.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/AbstractBasicSemicolonFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fixForUpdate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "fixAfterLastValidElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

