/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.java;

import com.intellij.formatting.Wrap;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.tree.IElementType;
import java.util.Set;

public abstract class WrappingStrategy {
    private static final Set<IElementType> COMMA_TOKENS = Set.of(JavaTokenType.COMMA, JavaTokenType.SEMICOLON);
    private static final Set<IElementType> COMMENT_TOKENS = Set.of(JavaTokenType.END_OF_LINE_COMMENT, JavaTokenType.C_STYLE_COMMENT);
    public static final WrappingStrategy DO_NOT_WRAP = new WrappingStrategy(null){

        @Override
        protected boolean shouldWrap(IElementType type) {
            return false;
        }
    };
    private final Wrap myWrap;

    public static WrappingStrategy createDoNotWrapCommaStrategy(Wrap wrap) {
        return new WrappingStrategy(wrap){

            @Override
            protected boolean shouldWrap(IElementType type) {
                return !COMMA_TOKENS.contains(type);
            }
        };
    }

    public static WrappingStrategy createDoNotWrapCommaAndCommentStrategy(Wrap wrap) {
        return new WrappingStrategy(wrap){

            @Override
            protected boolean shouldWrap(IElementType type) {
                return !COMMA_TOKENS.contains(type) && !COMMENT_TOKENS.contains(type);
            }
        };
    }

    public WrappingStrategy(Wrap wrap) {
        this.myWrap = wrap;
    }

    public Wrap getWrap(IElementType type) {
        if (this.shouldWrap(type)) {
            return this.myWrap;
        }
        return null;
    }

    protected abstract boolean shouldWrap(IElementType var1);
}

