/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.util;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jpa.jpb.model.backend.ds.DataSourceLoader;
import com.intellij.jpa.jpb.model.config.JpaBuddyIdeaProjectConfig;
import com.intellij.jpa.jpb.model.core.model.AbstractRdbmsStore;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.util.ActionUtils;
import com.intellij.jpa.jpb.model.util.FileTypeUtil;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.jpa.jpb.model.util.PsiUtilsKt;
import com.intellij.liquibase.common.orm.LiquibaseProjectRoot;
import com.intellij.liquibase.common.util.SqlFileHelper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u0012\u0010\r\u001a\u00020\u00052\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/liquibase/common/util/SqlActionUtils;", "", "<init>", "()V", "isVisibleUltimateSqlAction", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getInitDbType", "Lcom/intellij/jpa/jpb/model/core/model/dbtype/DbType;", "project", "Lcom/intellij/openapi/project/Project;", "isCurrentEditorDbConsole", "isLiquibaseStructureNode", "structureNode", "Lcom/intellij/ide/util/treeView/NodeDescriptor;", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nSqlActionUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlActionUtils.kt\ncom/intellij/liquibase/common/util/SqlActionUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,70:1\n1#2:71\n808#3,11:72\n1563#3:83\n1634#3,3:84\n*S KotlinDebug\n*F\n+ 1 SqlActionUtils.kt\ncom/intellij/liquibase/common/util/SqlActionUtils\n*L\n50#1:72,11\n51#1:83\n51#1:84,3\n*E\n"})
public final class SqlActionUtils {
    @NotNull
    public static final SqlActionUtils INSTANCE = new SqlActionUtils();

    private SqlActionUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isVisibleUltimateSqlAction(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!JpaUtils.isUltimate()) {
            return true;
        }
        Project project = e.getProject();
        if (project == null) return false;
        if (project.isDisposed()) return false;
        if (DumbService.Companion.isDumb(project)) {
            return false;
        }
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return false;
        }
        Editor editor2 = editor;
        PsiFile psiFile = PsiUtilBase.getPsiFileInEditor((Editor)editor2, (Project)project);
        if (psiFile == null) {
            return false;
        }
        PsiFile psiFile2 = psiFile;
        if (!FileTypeUtil.isSqlFile((PsiFile)psiFile2)) return false;
        if (!psiFile2.isWritable()) return false;
        if (!psiFile2.isValid()) return false;
        if (!JpaUtils.isJpaProject((Project)project, (Module)PsiUtilsKt.module((PsiFile)psiFile2))) return false;
        SqlFileHelper sqlFileHelper = SqlFileHelper.Companion.getInstance(project);
        if (sqlFileHelper == null) return false;
        DbType dbType = sqlFileHelper.getDbType(psiFile2);
        if (dbType == null) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final DbType getInitDbType(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Object v0;
        Object object2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String ddlActionDbTypeId = JpaBuddyIdeaProjectConfig.Companion.getInstance(project).getDdlActionDbTypeId();
            Iterable iterable = DbType.Companion.getUniqueMainTypes();
            for (Object object2 : iterable) {
                DbType it = (DbType)object2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)ddlActionDbTypeId)) continue;
                v0 = object2;
                break block4;
            }
            v0 = null;
        }
        DbType lastSelectedDbType = v0;
        if (lastSelectedDbType != null) {
            return lastSelectedDbType;
        }
        Iterable $this$filterIsInstance$iv = DataSourceLoader.Companion.getInstance(project).getCustomDataStores();
        boolean $i$f$filterIsInstance = false;
        object2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AbstractRdbmsStore)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AbstractRdbmsStore abstractRdbmsStore = (AbstractRdbmsStore)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            DbType dbType = it.getDbProperties().getType();
            Intrinsics.checkNotNullExpressionValue((Object)dbType, (String)"getType(...)");
            collection.add(DbType.Companion.getMainType(dbType));
        }
        List availableDbTypes = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        return availableDbTypes.isEmpty() ? null : (DbType)CollectionsKt.first((List)availableDbTypes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isCurrentEditorDbConsole(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor == null) {
            return false;
        }
        Editor currentEditor = editor;
        VirtualFile virtualFile = currentEditor.getVirtualFile();
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile == null) return false;
        VirtualFile virtualFile3 = virtualFile2.getParent();
        virtualFile2 = virtualFile3;
        if (virtualFile3 == null) return false;
        if ((virtualFile2 = virtualFile2.getParent()) == null) {
            return false;
        }
        VirtualFile directory = virtualFile2;
        if (!Intrinsics.areEqual((Object)"db", (Object)directory.getName())) return false;
        VirtualFile virtualFile4 = directory.getParent();
        if (!Intrinsics.areEqual((Object)"consoles", (Object)(virtualFile4 != null ? virtualFile4.getName() : null))) return false;
        return true;
    }

    public final boolean isLiquibaseStructureNode(@NotNull NodeDescriptor<?> structureNode) {
        Intrinsics.checkNotNullParameter(structureNode, (String)"structureNode");
        return ActionUtils.findStructureNodeLogicalModelByType$default((ActionUtils)ActionUtils.INSTANCE, structureNode, LiquibaseProjectRoot.class, (int)0, (int)4, null) != null;
    }
}

