/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.database;

import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.model.dbtype.MysqlType;
import com.intellij.jpa.jpb.model.liquibase.ns.PhysicalNamingStrategy;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.liquibase.common.IntellijDatabaseManager;
import com.intellij.liquibase.common.LiquibaseGenerationContext;
import com.intellij.liquibase.common.LiquibaseModelObjectFactory;
import com.intellij.liquibase.common.LiquibaseModelObjectFactoryBean;
import com.intellij.liquibase.common.StubLiquibaseModelObjectFactory;
import com.intellij.liquibase.common.ddl.LiquibaseGenerator;
import com.intellij.liquibase.common.orm.OrmDiffModelProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.database.OfflineConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.ext.intellij.database.connection.IntellijConnection;
import liquibase.ext.intellij.database.connection.IntellijDriver;
import liquibase.structure.core.Schema;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntellijDatabase
extends AbstractJdbcDatabase {
    public static final String PERSISTENCE_UNIT_PROP = "persistenceUnit";
    public static final String SHORT_NAME = "intellijPsiClass";
    public static final String DEFAULT_SCHEMA = "JPA_BUDDY";
    public static final String URL_PREFIX = "jpab";
    private boolean indexesForForeignKeys = false;
    private Project offlineProject;
    private DbType offlineDbType;

    public IntellijDatabase() {
        this.setDefaultCatalogName(DEFAULT_SCHEMA);
        this.setDefaultSchemaName(DEFAULT_SCHEMA);
        this.setOutputDefaultSchema(false);
        this.setOutputDefaultCatalog(false);
    }

    public boolean requiresPassword() {
        return false;
    }

    public boolean requiresUsername() {
        return false;
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith(URL_PREFIX)) {
            return IntellijDriver.class.getName();
        }
        return null;
    }

    public int getPriority() {
        return 1;
    }

    public void setConnection(DatabaseConnection conn) {
        super.setConnection(conn);
        if (conn instanceof JdbcConnection) {
            DbType dbType;
            IntellijConnection intellijConnection = this.getIntellijConnection();
            if (intellijConnection != null && ((dbType = intellijConnection.getDbType()) instanceof MysqlType || dbType == DbType.MARIA)) {
                this.indexesForForeignKeys = true;
            }
        } else if (conn instanceof OfflineConnection) {
            this.tryParseOfflineConnection((OfflineConnection)conn);
        }
    }

    public LiquibaseGenerationContext getGenerationContext() {
        IntellijConnection intellijConnection = this.getIntellijConnection();
        return intellijConnection != null ? intellijConnection.getGenerationContext() : null;
    }

    public OrmFramework getOrmFramework() {
        LiquibaseGenerationContext context = this.getGenerationContext();
        if (context != null) {
            return context.getOrmFramework();
        }
        return JpaOrmFramework.INSTANCE;
    }

    private void tryParseOfflineConnection(OfflineConnection offlineConnection) {
        String[] keyValues;
        this.offlineProject = null;
        this.offlineDbType = null;
        String url = offlineConnection.getURL();
        if (StringUtil.isEmpty((String)url)) {
            return;
        }
        Matcher matcher = Pattern.compile("offline:(\\w+)\\??(.*)").matcher(url);
        if (!matcher.matches()) {
            return;
        }
        String databaseShortName = matcher.group(1).toLowerCase();
        if (StringUtil.isEmpty((String)databaseShortName)) {
            return;
        }
        DbType foundDbType = StreamEx.of((Collection)DbType.getUniqueMainTypes()).findFirst(dbType -> dbType.getLiquibaseDbms().equals(databaseShortName)).orElse(null);
        if (foundDbType == null) {
            return;
        }
        String params = StringUtils.trimToNull((String)matcher.group(2));
        if (params == null) {
            return;
        }
        for (String param : keyValues = params.split("&")) {
            Project defaultProject;
            String[] split = param.split("=");
            String key = URLDecoder.decode(split[0], StandardCharsets.UTF_8);
            String value = URLDecoder.decode(split[1], StandardCharsets.UTF_8);
            if (!"snapshot".equals(key) || (defaultProject = (Project)StreamEx.of((Object[])ProjectManager.getInstance().getOpenProjects()).findFirst(prj -> {
                VirtualFile projectVf = ProjectUtil.guessProjectDir((Project)prj);
                if (projectVf == null) {
                    return false;
                }
                VirtualFile snapshotVf = VfsUtil.findFileByIoFile((File)new File(value), (boolean)false);
                return snapshotVf != null && VfsUtilCore.isAncestor((VirtualFile)projectVf, (VirtualFile)snapshotVf, (boolean)true);
            }).orElse(null)) == null) continue;
            this.offlineProject = defaultProject;
            this.offlineDbType = foundDbType;
        }
    }

    @Nullable
    public IntellijConnection getIntellijConnection() {
        DatabaseConnection connection = this.getConnection();
        return connection instanceof JdbcConnection ? (IntellijConnection)((JdbcConnection)connection).getUnderlyingConnection() : null;
    }

    public boolean createsIndexesForForeignKeys() {
        return this.indexesForForeignKeys;
    }

    public Integer getDefaultPort() {
        return 0;
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    public boolean supportsTablespaces() {
        return false;
    }

    protected String getConnectionCatalogName() throws DatabaseException {
        return this.getDefaultCatalogName();
    }

    protected String getConnectionSchemaName() {
        return this.getDefaultSchemaName();
    }

    public String getDefaultSchemaName() {
        return DEFAULT_SCHEMA;
    }

    public String getDefaultCatalogName() {
        return DEFAULT_SCHEMA;
    }

    public boolean isSafeToRunUpdate() throws DatabaseException {
        return true;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    protected String getDefaultDatabaseProductName() {
        return "Intellij Psi Class Metadata";
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return conn.getURL().startsWith("jpab?");
    }

    public String getShortName() {
        return SHORT_NAME;
    }

    public Project getProject() {
        IntellijConnection intellijConnection = this.getIntellijConnection();
        return intellijConnection != null ? intellijConnection.getProject() : this.offlineProject;
    }

    public LiquibaseGenerator getLiquibaseGenerator() {
        IntellijConnection intellijConnection = this.getIntellijConnection();
        if (intellijConnection != null) {
            return intellijConnection.getLiquibaseGenerator();
        }
        if (this.offlineDbType != null && this.offlineProject != null) {
            return intellijConnection.getGenerationContext().getGenerator(this.offlineDbType);
        }
        return null;
    }

    public DbType getDbType() {
        IntellijConnection intellijConnection = this.getIntellijConnection();
        if (intellijConnection != null) {
            return intellijConnection.getDbType();
        }
        return this.offlineDbType;
    }

    @Nullable
    public IntellijDatabaseManager getManager() {
        Project project = this.getProject();
        return project == null ? null : IntellijDatabaseManager.getInstance(project);
    }

    @NotNull
    public LiquibaseModelObjectFactory getDbObjectFactory() {
        Project project = this.getProject();
        if (project == null || this.getOrmFramework() != JpaOrmFramework.INSTANCE) {
            StubLiquibaseModelObjectFactory stubLiquibaseModelObjectFactory = StubLiquibaseModelObjectFactory.INSTANCE;
            if (stubLiquibaseModelObjectFactory == null) {
                IntellijDatabase.$$$reportNull$$$0(0);
            }
            return stubLiquibaseModelObjectFactory;
        }
        LiquibaseModelObjectFactoryBean liquibaseModelObjectFactoryBean = LiquibaseModelObjectFactoryBean.getInstance(project);
        if (liquibaseModelObjectFactoryBean == null) {
            IntellijDatabase.$$$reportNull$$$0(1);
        }
        return liquibaseModelObjectFactoryBean;
    }

    @Nullable
    public OrmEntity findOrmEntityByTableName(@NotNull String tableName) {
        if (tableName == null) {
            IntellijDatabase.$$$reportNull$$$0(2);
        }
        IntellijConnection intellijConnection = this.getIntellijConnection();
        IntellijDatabaseManager manager = this.getManager();
        return intellijConnection != null && manager != null ? manager.findEntityByTableName(intellijConnection, tableName) : null;
    }

    public List<OrmEntity> getOrmEntitiesToProcess() {
        IntellijConnection intellijConnection = this.getIntellijConnection();
        IntellijDatabaseManager manager = this.getManager();
        return intellijConnection != null && manager != null ? manager.collectEntitiesToProcess(intellijConnection) : Collections.emptyList();
    }

    public List<OrmEntity> getAllOrmEntities() {
        IntellijConnection intellijConnection = this.getIntellijConnection();
        IntellijDatabaseManager manager = this.getManager();
        return intellijConnection != null && manager != null ? manager.collectAllEntities(intellijConnection) : Collections.emptyList();
    }

    public Collection<String> getAllSchemaNames() {
        Project project = this.getProject();
        if (project == null) {
            return Collections.emptyList();
        }
        OrmDiffModelProvider ormDiffModelProvider = OrmDiffModelProvider.Companion.getForFramework(this.getOrmFramework());
        return this.getOrmEntitiesToProcess().stream().map(arg_0 -> ((OrmDiffModelProvider)ormDiffModelProvider).getSchemaName(arg_0)).filter(StringUtil::isNotEmpty).map(s -> PhysicalNamingStrategy.getInstance((Project)project).toSchemaName(s)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public List<OrmEntity> getOrmEntitiesToProcess(@NotNull Schema schema) {
        if (schema == null) {
            IntellijDatabase.$$$reportNull$$$0(3);
        }
        String schemaName = schema.getName();
        OrmDiffModelProvider ormDiffModelProvider = OrmDiffModelProvider.Companion.getForFramework(this.getOrmFramework());
        PhysicalNamingStrategy physicalNamingStrategy = PhysicalNamingStrategy.getInstance((Project)this.getProject());
        return ((StreamEx)StreamEx.of(this.getOrmEntitiesToProcess()).filter(entity -> {
            String entitySchema = ormDiffModelProvider.getSchemaName((OrmEntity)entity);
            return StringUtil.isEmpty((String)entitySchema) ? DEFAULT_SCHEMA.equals(schemaName) || StringUtil.isEmpty((String)schemaName) : physicalNamingStrategy.compareSchema(entitySchema, schemaName);
        })).toList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "liquibase/ext/intellij/database/IntellijDatabase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbObjectFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "liquibase/ext/intellij/database/IntellijDatabase";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findOrmEntityByTableName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrmEntitiesToProcess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

