/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.view;

import com.intellij.openapi.graph.impl.view.JBGraph2DView;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import x.P.Aa;
import x.P.X;
import x.P.xy;
import x.P.ys;

public class JBBackgroundRenderer
extends Aa {
    public static final int COARSE_GRID_STEP = 4;
    public static final JBColor DEFAULT_BACKGROUND_COLOR = new JBColor(0xFFFFFF, 1974050);

    public JBBackgroundRenderer(X view) {
        super(view);
    }

    public void drawGridLine(boolean isCoarsed, Graphics2D g2, int x12, int y12, int x22, int y22) {
        if (isCoarsed) {
            g2.setColor(((JBGraph2DView)this.E).getCoarseGridColor());
        }
        g2.drawLine(x12, y12, x22, y22);
        if (isCoarsed) {
            g2.setColor(this.E.x());
        }
    }

    @Override
    public void paint(Graphics2D gfx, int xs2, int ys2, int w2, int h2) {
        GraphicsUtil.disableAAPainting((Graphics)gfx);
        gfx.setBackground((Color)DEFAULT_BACKGROUND_COLOR);
        gfx.clearRect(xs2, ys2, w2, h2);
        Object object = gfx.getRenderingHint(xy.x);
        ys ys3 = (ys)object;
        X x10 = ys3.x();
        AffineTransform affineTransform = gfx.getTransform();
        AffineTransform affineTransform2 = ys3.x();
        gfx.setTransform(affineTransform2);
        boolean bl = true;
        double d10 = 20.0;
        double d11 = 20.0;
        double d12 = 80.0;
        double d13 = 80.0;
        Point2D point2D = x10.l();
        double d14 = x10.x();
        if (!x10.l() || d14 < x10.k()) {
            return;
        }
        Rectangle rectangle = gfx.getClipBounds();
        double d15 = (Math.floor(point2D.getX() / 20.0) * 20.0 - point2D.getX()) * d14;
        double d16 = (Math.floor(point2D.getY() / 20.0) * 20.0 - point2D.getY()) * d14;
        double d17 = (Math.floor(point2D.getX() / 80.0) * 80.0 - point2D.getX()) * d14;
        double d18 = (Math.floor(point2D.getY() / 80.0) * 80.0 - point2D.getY()) * d14;
        double d19 = 20.0 * d14;
        double d20 = 20.0 * d14;
        double d21 = d19 * 4.0;
        double d22 = d20 * 4.0;
        double d23 = Math.floor(-1.0 + rectangle.getX() / d19) * d19 + d15;
        double d24 = Math.floor(-1.0 + rectangle.getY() / d20) * d20 + d16;
        int n2 = rectangle.x + rectangle.width + 1;
        int n3 = rectangle.y + rectangle.height + 1;
        double d25 = Math.floor(-1.0 + rectangle.getX() / d21) * d21 + d17;
        double d26 = Math.floor(-1.0 + rectangle.getY() / d22) * d22 + d18;
        long l10 = Math.round(Math.abs(d23 - d25) / d19);
        long l11 = Math.round(Math.abs(d24 - d26) / d20);
        switch (1) {
            case 1: {
                int n4;
                double d27;
                gfx.setColor(x10.x());
                for (d27 = d23; d27 < (double)n2; d27 += d19) {
                    n4 = (int)d27;
                    gfx.drawLine(n4, rectangle.y, n4, rectangle.y + rectangle.height);
                }
                for (d27 = d24; d27 < (double)n3; d27 += d20) {
                    n4 = (int)d27;
                    gfx.drawLine(rectangle.x, n4, rectangle.x + rectangle.width, n4);
                }
                gfx.setColor(((JBGraph2DView)x10).getCoarseGridColor());
                for (d27 = d25; d27 < (double)n2; d27 += d21) {
                    n4 = (int)d27;
                    gfx.drawLine(n4, rectangle.y, n4, rectangle.y + rectangle.height);
                }
                for (d27 = d26; d27 < (double)n3; d27 += d22) {
                    n4 = (int)d27;
                    gfx.drawLine(rectangle.x, n4, rectangle.x + rectangle.width, n4);
                }
                break;
            }
            case 3: {
                double d28 = d23;
                double d29 = l10;
                while (d28 < (double)n2) {
                    double d30 = d24;
                    double d31 = l11;
                    while (d30 < (double)n3) {
                        int n5 = (int)d28;
                        int n6 = (int)d30;
                        this.drawGridLine(d29 % 4.0 == 0.0, gfx, n5, n6 - 3, n5, n6 + 3);
                        this.drawGridLine(d31 % 4.0 == 0.0, gfx, n5 - 3, n6, n5 + 3, n6);
                        d30 += d20;
                        d31 += 1.0;
                    }
                    d28 += d19;
                    d29 += 1.0;
                }
                break;
            }
            case 2: {
                double d32 = d23;
                double d33 = l10;
                while (d32 < (double)n2) {
                    double d34 = d24;
                    double d35 = l11;
                    while (d34 < (double)n3) {
                        int n7 = (int)d32;
                        int n8 = (int)d34;
                        this.drawGridLine(d33 % 4.0 == 0.0, gfx, n7, n8 - 1, n7, n8 + 1);
                        this.drawGridLine(d35 % 4.0 == 0.0, gfx, n7 - 1, n8, n7 + 1, n8);
                        d34 += d20;
                        d35 += 1.0;
                    }
                    d32 += d19;
                    d33 += 1.0;
                }
                break;
            }
        }
        gfx.setTransform(affineTransform);
    }
}

