/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.completion;

import com.intellij.codeInsight.completion.BaseCompletionService;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.customization.LspCompletionSupport;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.impl.completion.LspCompletionContributorKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.ServerCapabilities;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/platform/lsp/impl/completion/LspCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "Lcom/intellij/openapi/project/DumbAware;", "LspCompletionContributor", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspCompletionContributor.kt\ncom/intellij/platform/lsp/impl/completion/LspCompletionContributor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1#2:114\n*E\n"})
public final class LspCompletionContributor
extends CompletionContributor
implements DumbAware {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        VirtualFile virtualFile;
        Project project;
        PsiFile psiFile;
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
                Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                PsiFile psiFile2 = parameters.getOriginalFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getOriginalFile(...)");
                psiFile = psiFile2;
                Project project2 = psiFile.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                project = project2;
                if (project.isDefault()) {
                    return;
                }
                virtualFile = psiFile.getOriginalFile().getVirtualFile();
                if (virtualFile == null) break block8;
                VirtualFile object = virtualFile;
                boolean bl = false;
                VirtualFileWindow virtualFileWindow = object instanceof VirtualFileWindow ? (VirtualFileWindow)object : null;
                if (virtualFileWindow == null || (virtualFileWindow = virtualFileWindow.getDelegate()) == null) {
                    virtualFileWindow = object;
                }
                virtualFile = virtualFileWindow;
                if (virtualFileWindow != null) break block9;
            }
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document == null) {
            return;
        }
        Document document2 = document;
        int n2 = InjectedLanguageManager.getInstance((Project)project).injectedToHost((PsiElement)psiFile, parameters.getOffset());
        for (LspServerImpl lspServerImpl : LspServerManagerImpl.Companion.getInstanceImpl(project).getServersWithThisFileOpen$intellij_platform_lsp_impl(virtualFile2)) {
            CompletionList completionList;
            LspCompletionSupport lspCompletionSupport;
            ProgressManager.checkCanceled();
            ServerCapabilities serverCapabilities = lspServerImpl.getServerCapabilities$intellij_platform_lsp_impl();
            if (serverCapabilities == null || (serverCapabilities = serverCapabilities.getCompletionProvider()) == null) continue;
            Object object = lspServerImpl.getDescriptor().getLspCustomization().getCompletionCustomizer();
            LspCompletionSupport lspCompletionSupport2 = object instanceof LspCompletionSupport ? (LspCompletionSupport)object : null;
            if (lspCompletionSupport2 == null || !(lspCompletionSupport = lspCompletionSupport2).shouldRunCodeCompletion(parameters)) continue;
            CompletionProcess completionProcess = parameters.getProcess();
            Intrinsics.checkNotNull((Object)completionProcess, (String)"null cannot be cast to non-null type com.intellij.codeInsight.completion.CompletionProcessEx");
            ((CompletionProcessEx)completionProcess).putUserData(BaseCompletionService.FORBID_WORD_COMPLETION, (Object)true);
            if (lspServerImpl.getRequestExecutor().getCompletionList(virtualFile2, n2, parameters.isAutoPopup()) == null) continue;
            if (completionList.isIncomplete()) {
                result.restartCompletionOnAnyPrefixChange();
            }
            if (completionList.getItems().isEmpty()) continue;
            String string = result.getPrefixMatcher().getPrefix();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPrefix(...)");
            object = string;
            String string2 = lspCompletionSupport.getCompletionPrefix(parameters, (String)object);
            CompletionResultSet completionResultSet = !Intrinsics.areEqual((Object)string2, (Object)object) ? result.withPrefixMatcher(string2) : result;
            Intrinsics.checkNotNull((Object)completionResultSet);
            CompletionResultSet completionResultSet2 = completionResultSet;
            List list = completionList.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
            LspCompletionContributorKt.processCompletionItemsImpl(lspServerImpl, document2, n2, completionResultSet2, list, arg_0 -> LspCompletionContributor.x(lspCompletionSupport, parameters, arg_0));
        }
    }

    private static final LookupElement x(LspCompletionSupport lspCompletionSupport, CompletionParameters completionParameters, CompletionItem completionItem) {
        Intrinsics.checkNotNull((Object)completionItem);
        return lspCompletionSupport.createLookupElement(completionParameters, completionItem);
    }
}

