/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.connector;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.platform.lsp.api.Lsp4jClient;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.LspServerListener;
import com.intellij.platform.lsp.api.LspServerState;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.impl.connector.Lsp4jServerConnectorKt;
import com.intellij.platform.lsp.impl.connector.Lsp4jServerWrapperCreator;
import com.intellij.platform.lsp.impl.connector.LspInitializationException;
import com.intellij.platform.lsp.impl.logging.LanguageServiceLogger;
import com.intellij.platform.lsp.impl.logging.LanguageServiceLoggerService;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.jsonrpc.Endpoint;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.jsonrpc.RemoteEndpoint;
import org.eclipse.lsp4j.jsonrpc.json.MessageJsonHandler;
import org.eclipse.lsp4j.jsonrpc.json.MethodProvider;
import org.eclipse.lsp4j.jsonrpc.json.StreamMessageConsumer;
import org.eclipse.lsp4j.jsonrpc.json.StreamMessageProducer;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.jsonrpc.services.ServiceEndpoints;
import org.eclipse.lsp4j.services.LanguageServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001b\u001a\u00020\u001cH$J\b\u0010\u001d\u001a\u00020\u001eH$J\b\u0010\u001f\u001a\u00020\u001cH$J!\u0010 \u001a\u00020\u001c2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u001c0\"H\u0001\u00a2\u0006\u0002\b$J\u001c\u0010%\u001a\u00020\u001c2\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u001c0\"H\u0003J\r\u0010&\u001a\u00020\u001cH\u0001\u00a2\u0006\u0002\b'J\b\u0010(\u001a\u00020)H\u0002J\u0017\u0010*\u001a\u0004\u0018\u00010\u001c2\u0006\u0010+\u001a\u00020,H\u0004\u00a2\u0006\u0002\u0010-R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0012X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0016X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/platform/lsp/impl/connector/Lsp4jServerConnector;", "", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "Lsp4jServerConnector", "(Lcom/intellij/platform/lsp/impl/LspServerImpl;)V", "descriptor", "Lcom/intellij/platform/lsp/api/LspServerDescriptor;", "lsp4jClient", "Lcom/intellij/platform/lsp/api/Lsp4jClient;", "lsp4jServer", "Lorg/eclipse/lsp4j/services/LanguageServer;", "Lcom/intellij/platform/lsp/api/Lsp4jServer;", "getLsp4jServer", "()Lorg/eclipse/lsp4j/services/LanguageServer;", "setLsp4jServer", "(Lorg/eclipse/lsp4j/services/LanguageServer;)V", "ideToServerStream", "Ljava/io/OutputStream;", "getIdeToServerStream", "()Ljava/io/OutputStream;", "serverToIdeStream", "Ljava/io/InputStream;", "getServerToIdeStream", "()Ljava/io/InputStream;", "lsCommunicationLogger", "Lcom/intellij/platform/lsp/impl/logging/LanguageServiceLogger;", "prepareConnect", "", "isConnectionAlive", "", "disconnect", "connect", "onSuccess", "Lkotlin/Function1;", "Lorg/eclipse/lsp4j/InitializeResult;", "connect$intellij_platform_lsp_impl", "x", "shutdownExitDisconnect", "shutdownExitDisconnect$intellij_platform_lsp_impl", "x", "Lorg/eclipse/lsp4j/jsonrpc/json/MessageJsonHandler;", "logStdErr", "message", "", "(Ljava/lang/CharSequence;)Lkotlin/Unit;", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLsp4jServerConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lsp4jServerConnector.kt\ncom/intellij/platform/lsp/impl/connector/Lsp4jServerConnector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1#2:184\n*E\n"})
public abstract class Lsp4jServerConnector {
    @NotNull
    private final LspServerImpl lspServer;
    @NotNull
    private final LspServerDescriptor descriptor;
    @NotNull
    private final Lsp4jClient lsp4jClient;
    public LanguageServer lsp4jServer;
    @Nullable
    private LanguageServiceLogger lsCommunicationLogger;

    protected Lsp4jServerConnector(@NotNull LspServerImpl lspServer) {
        Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
        this.lspServer = lspServer;
        this.descriptor = this.lspServer.getDescriptor();
        this.lsp4jClient = this.descriptor.createLsp4jClient(this.lspServer.getServerNotificationsHandler$intellij_platform_lsp_impl());
    }

    @NotNull
    public final LanguageServer getLsp4jServer() {
        LanguageServer languageServer = this.lsp4jServer;
        if (languageServer != null) {
            return languageServer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"lsp4jServer");
        return null;
    }

    public final void setLsp4jServer(@NotNull LanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"<set-?>");
        this.lsp4jServer = languageServer;
    }

    @NotNull
    protected abstract OutputStream getIdeToServerStream();

    @NotNull
    protected abstract InputStream getServerToIdeStream();

    protected abstract void prepareConnect();

    protected abstract boolean isConnectionAlive();

    protected abstract void disconnect();

    @RequiresBackgroundThread
    @RequiresReadLockAbsence
    public final void connect$intellij_platform_lsp_impl(@NotNull Function1<? super InitializeResult, Unit> onSuccess) {
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        this.prepareConnect();
        MessageJsonHandler messageJsonHandler = this.x();
        RemoteEndpoint remoteEndpoint = new RemoteEndpoint((MessageConsumer)new StreamMessageConsumer(this.getIdeToServerStream(), messageJsonHandler), ServiceEndpoints.toEndpoint((Object)this.lsp4jClient));
        messageJsonHandler.setMethodProvider((MethodProvider)remoteEndpoint);
        Object object = ServiceEndpoints.toServiceObject((Endpoint)((Endpoint)remoteEndpoint), this.descriptor.getLsp4jServerClass());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toServiceObject(...)");
        this.setLsp4jServer((LanguageServer)object);
        this.setLsp4jServer(this.descriptor instanceof Lsp4jServerWrapperCreator ? ((Lsp4jServerWrapperCreator)((Object)this.descriptor)).wrapLsp4jServer(this.getLsp4jServer()) : this.getLsp4jServer());
        ApplicationManager.getApplication().executeOnPooledThread(() -> Lsp4jServerConnector.x(this, messageJsonHandler, remoteEndpoint));
        this.x(onSuccess);
    }

    @RequiresBackgroundThread
    @RequiresReadLockAbsence
    private final void x(Function1<? super InitializeResult, Unit> function1) {
        Lsp4jServerConnectorKt.access$getLogger$p().debug(this.descriptor + ": initializing LSP server");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        this.getLsp4jServer().initialize(this.descriptor.createInitializeParams()).whenComplete((arg_0, arg_1) -> Lsp4jServerConnector.x((arg_0, arg_1) -> Lsp4jServerConnector.x(this, function1, objectRef, countDownLatch, arg_0, arg_1), arg_0, arg_1));
        long l10 = 100L;
        boolean bl = countDownLatch.await(l10, TimeUnit.SECONDS);
        if (!bl) {
            throw new RuntimeException("'initialized' response not received from the server in " + l10 + " seconds");
        }
        Throwable throwable = (Throwable)objectRef.element;
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl2 = false;
            throw new LspInitializationException("LSP server failed to initialize", throwable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @RequiresBackgroundThread
    @RequiresReadLockAbsence
    public final void shutdownExitDisconnect$intellij_platform_lsp_impl() {
        block44: {
            LspServerListener lspServerListener;
            block41: {
                block40: {
                    if (this.lsp4jServer == null || !this.isConnectionAlive()) break block40;
                    CompletableFuture completableFuture = this.getLsp4jServer().shutdown();
                    completableFuture.get(10L, TimeUnit.SECONDS);
                }
                try {
                    if (this.lsp4jServer == null || !this.isConnectionAlive()) break block41;
                    this.getLsp4jServer().exit();
                }
                catch (Throwable throwable) {
                    LspServerListener lspServerListener2;
                    try {
                        LanguageServiceLogger languageServiceLogger = this.lsCommunicationLogger;
                        if (languageServiceLogger != null) {
                            LanguageServiceLogger languageServiceLogger2 = languageServiceLogger;
                            boolean bl = false;
                            LanguageServiceLoggerService.Companion.getInstance().disconnect(languageServiceLogger2);
                        }
                        this.lsCommunicationLogger = null;
                        this.disconnect();
                        lspServerListener2 = this.descriptor.getLspServerListener();
                    }
                    catch (Throwable throwable2) {
                        LspServerListener lspServerListener3 = this.descriptor.getLspServerListener();
                        if (lspServerListener3 != null) {
                            lspServerListener3.serverStopped(this.lspServer.getState() == LspServerState.ShutdownNormally);
                        }
                        throw throwable2;
                    }
                    if (lspServerListener2 != null) {
                        lspServerListener2.serverStopped(this.lspServer.getState() == LspServerState.ShutdownNormally);
                    }
                    throw throwable;
                }
            }
            try {
                LanguageServiceLogger languageServiceLogger = this.lsCommunicationLogger;
                if (languageServiceLogger != null) {
                    LanguageServiceLogger languageServiceLogger3 = languageServiceLogger;
                    boolean bl = false;
                    LanguageServiceLoggerService.Companion.getInstance().disconnect(languageServiceLogger3);
                }
                this.lsCommunicationLogger = null;
                this.disconnect();
                lspServerListener = this.descriptor.getLspServerListener();
            }
            catch (Throwable throwable) {
                LspServerListener lspServerListener4 = this.descriptor.getLspServerListener();
                if (lspServerListener4 != null) {
                    lspServerListener4.serverStopped(this.lspServer.getState() == LspServerState.ShutdownNormally);
                }
                throw throwable;
            }
            if (lspServerListener != null) {
                lspServerListener.serverStopped(this.lspServer.getState() == LspServerState.ShutdownNormally);
            }
            break block44;
            catch (Exception exception) {
                LspServerListener lspServerListener5;
                block42: {
                    try {
                        Lsp4jServerConnectorKt.access$getLogger$p().warn(this.descriptor + ": `shutdown` request failed: " + exception);
                    }
                    catch (Throwable throwable) {
                        LspServerListener lspServerListener6;
                        block43: {
                            try {
                                if (this.lsp4jServer == null || !this.isConnectionAlive()) break block43;
                                this.getLsp4jServer().exit();
                            }
                            catch (Throwable throwable3) {
                                LspServerListener lspServerListener7;
                                try {
                                    LanguageServiceLogger languageServiceLogger = this.lsCommunicationLogger;
                                    if (languageServiceLogger != null) {
                                        LanguageServiceLogger languageServiceLogger4 = languageServiceLogger;
                                        boolean bl = false;
                                        LanguageServiceLoggerService.Companion.getInstance().disconnect(languageServiceLogger4);
                                    }
                                    this.lsCommunicationLogger = null;
                                    this.disconnect();
                                    lspServerListener7 = this.descriptor.getLspServerListener();
                                }
                                catch (Throwable throwable4) {
                                    LspServerListener lspServerListener8 = this.descriptor.getLspServerListener();
                                    if (lspServerListener8 != null) {
                                        lspServerListener8.serverStopped(this.lspServer.getState() == LspServerState.ShutdownNormally);
                                    }
                                    throw throwable4;
                                }
                                if (lspServerListener7 != null) {
                                    lspServerListener7.serverStopped(this.lspServer.getState() == LspServerState.ShutdownNormally);
                                }
                                throw throwable3;
                            }
                        }
                        try {
                            LanguageServiceLogger languageServiceLogger = this.lsCommunicationLogger;
                            if (languageServiceLogger != null) {
                                LanguageServiceLogger languageServiceLogger5 = languageServiceLogger;
                                boolean bl = false;
                                LanguageServiceLoggerService.Companion.getInstance().disconnect(languageServiceLogger5);
                            }
                            this.lsCommunicationLogger = null;
                            this.disconnect();
                            lspServerListener6 = this.descriptor.getLspServerListener();
                        }
                        catch (Throwable throwable5) {
                            LspServerListener lspServerListener9 = this.descriptor.getLspServerListener();
                            if (lspServerListener9 != null) {
                                lspServerListener9.serverStopped(this.lspServer.getState() == LspServerState.ShutdownNormally);
                            }
                            throw throwable5;
                        }
                        if (lspServerListener6 != null) {
                            lspServerListener6.serverStopped(this.lspServer.getState() == LspServerState.ShutdownNormally);
                        }
                        throw throwable;
                    }
                    try {
                        if (this.lsp4jServer == null || !this.isConnectionAlive()) break block42;
                        this.getLsp4jServer().exit();
                    }
                    catch (Throwable throwable) {
                        LspServerListener lspServerListener10;
                        try {
                            LanguageServiceLogger languageServiceLogger = this.lsCommunicationLogger;
                            if (languageServiceLogger != null) {
                                LanguageServiceLogger languageServiceLogger6 = languageServiceLogger;
                                boolean bl = false;
                                LanguageServiceLoggerService.Companion.getInstance().disconnect(languageServiceLogger6);
                            }
                            this.lsCommunicationLogger = null;
                            this.disconnect();
                            lspServerListener10 = this.descriptor.getLspServerListener();
                        }
                        catch (Throwable throwable6) {
                            LspServerListener lspServerListener11 = this.descriptor.getLspServerListener();
                            if (lspServerListener11 != null) {
                                lspServerListener11.serverStopped(this.lspServer.getState() == LspServerState.ShutdownNormally);
                            }
                            throw throwable6;
                        }
                        if (lspServerListener10 != null) {
                            lspServerListener10.serverStopped(this.lspServer.getState() == LspServerState.ShutdownNormally);
                        }
                        throw throwable;
                    }
                }
                try {
                    LanguageServiceLogger languageServiceLogger = this.lsCommunicationLogger;
                    if (languageServiceLogger != null) {
                        LanguageServiceLogger languageServiceLogger7 = languageServiceLogger;
                        boolean bl = false;
                        LanguageServiceLoggerService.Companion.getInstance().disconnect(languageServiceLogger7);
                    }
                    this.lsCommunicationLogger = null;
                    this.disconnect();
                    lspServerListener5 = this.descriptor.getLspServerListener();
                }
                catch (Throwable throwable) {
                    LspServerListener lspServerListener12 = this.descriptor.getLspServerListener();
                    if (lspServerListener12 != null) {
                        lspServerListener12.serverStopped(this.lspServer.getState() == LspServerState.ShutdownNormally);
                    }
                    throw throwable;
                }
                if (lspServerListener5 != null) {
                    lspServerListener5.serverStopped(this.lspServer.getState() == LspServerState.ShutdownNormally);
                }
            }
        }
    }

    private final MessageJsonHandler x() {
        Class<? extends LanguageServer> clazz = this.descriptor.getLsp4jServerClass();
        Map map = new LinkedHashMap(ServiceEndpoints.getSupportedMethods(clazz));
        Map map2 = ServiceEndpoints.getSupportedMethods(this.lsp4jClient.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getSupportedMethods(...)");
        map.putAll(map2);
        Consumer<GsonBuilder> consumer = Lsp4jServerConnector::x;
        return new MessageJsonHandler(map, this, consumer){
            private final Regex messageToFixRegex;
            final /* synthetic */ Lsp4jServerConnector this$0;
            {
                this.this$0 = $receiver;
                super($supportedMethods, $super_call_param$1);
                this.messageToFixRegex = new Regex("\\{\"jsonrpc\":\"2.0\",(\"method\":\"exit\"|\"id\":\"[^\"]+\",\"method\":\"shutdown\")(,\"params\":null)}");
            }

            public String serialize(Message message) {
                String string;
                block0: {
                    Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                    String string2 = super.serialize(message);
                    Intrinsics.checkNotNull((Object)string2);
                    string = this.x(string2);
                    LanguageServiceLogger languageServiceLogger = Lsp4jServerConnector.access$getLsCommunicationLogger$p(this.this$0);
                    if (languageServiceLogger == null) break block0;
                    languageServiceLogger.logOutbound(string);
                }
                return string;
            }

            private final String x(String string) {
                MatchResult matchResult = this.messageToFixRegex.matchEntire((CharSequence)string);
                if (matchResult == null) {
                    return string;
                }
                MatchResult matchResult2 = matchResult;
                MatchGroup matchGroup = matchResult2.getGroups().get(2);
                Intrinsics.checkNotNull((Object)matchGroup);
                IntRange intRange = matchGroup.getRange();
                return ((Object)StringsKt.removeRange((CharSequence)string, (IntRange)intRange)).toString();
            }

            public Message parseMessage(CharSequence input) throws JsonParseException {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                LanguageServiceLogger languageServiceLogger = Lsp4jServerConnector.access$getLsCommunicationLogger$p(this.this$0);
                if (languageServiceLogger != null) {
                    languageServiceLogger.logInbound(input);
                }
                Message message = super.parseMessage(input);
                Intrinsics.checkNotNullExpressionValue((Object)message, (String)"parseMessage(...)");
                return message;
            }
        };
    }

    @Nullable
    protected final Unit logStdErr(@NotNull CharSequence message) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        LanguageServiceLogger languageServiceLogger = this.lsCommunicationLogger;
        if (languageServiceLogger != null) {
            languageServiceLogger.logError(message);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final void x(Lsp4jServerConnector lsp4jServerConnector, MessageJsonHandler messageJsonHandler, RemoteEndpoint remoteEndpoint) {
        ConcurrencyUtil.runUnderThreadName((String)("LSP Listener: " + lsp4jServerConnector.descriptor), () -> Lsp4jServerConnector.l(lsp4jServerConnector, messageJsonHandler, remoteEndpoint));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void l(Lsp4jServerConnector lsp4jServerConnector, MessageJsonHandler messageJsonHandler, RemoteEndpoint remoteEndpoint) {
        Object object;
        Object object2;
        Lsp4jServerConnectorKt.access$getLogger$p().debug(lsp4jServerConnector.descriptor + ": LSP server listener thread started");
        if (LanguageServiceLoggerService.Companion.isDebugLogEnabled()) {
            lsp4jServerConnector.lsCommunicationLogger = LanguageServiceLoggerService.Companion.getInstance().connect(lsp4jServerConnector.descriptor.getPresentableName(), true);
        }
        try {
            object2 = (Closeable)new StreamMessageProducer(lsp4jServerConnector.getServerToIdeStream(), messageJsonHandler);
            object = null;
            try {
                StreamMessageProducer streamMessageProducer = (StreamMessageProducer)object2;
                boolean bl = false;
                streamMessageProducer.listen((MessageConsumer)remoteEndpoint);
                streamMessageProducer = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
        }
        catch (Throwable throwable) {
            lsp4jServerConnector.lspServer.appendServerErrorOutput$intellij_platform_lsp_impl(ExceptionsKt.stackTraceToString((Throwable)throwable));
            Lsp4jServerConnectorKt.access$getLogger$p().error(lsp4jServerConnector.descriptor.toString(), throwable);
        }
        finally {
            Lsp4jServerConnectorKt.access$getLogger$p().debug(lsp4jServerConnector.descriptor + ": LSP server listener thread finished");
            object2 = (LspServerManagerImpl)ReadAction.compute(() -> Lsp4jServerConnector.x(lsp4jServerConnector));
            object = lsp4jServerConnector.descriptor.getLspCommunicationChannel().getClass().getSimpleName() + " connection closed";
            Object object3 = object2;
            if (object3 != null) {
                ((LspServerManagerImpl)object3).handleMaybeUnexpectedServerStop$intellij_platform_lsp_impl(lsp4jServerConnector.lspServer, (String)object);
            }
        }
    }

    private static final LspServerManagerImpl x(Lsp4jServerConnector lsp4jServerConnector) {
        return !lsp4jServerConnector.lspServer.getProject().isDisposed() ? LspServerManagerImpl.Companion.getInstanceImpl(lsp4jServerConnector.lspServer.getProject()) : null;
    }

    private static final Unit x(Lsp4jServerConnector lsp4jServerConnector, Function1 function1, Ref.ObjectRef objectRef, CountDownLatch countDownLatch, InitializeResult initializeResult, Throwable throwable) {
        if (initializeResult != null) {
            lsp4jServerConnector.getLsp4jServer().initialized(new InitializedParams());
            function1.invoke((Object)initializeResult);
        } else {
            Throwable throwable2 = throwable;
            if (throwable2 == null) {
                throwable2 = new RuntimeException("No InitializeResult");
            }
            objectRef.element = throwable2;
        }
        countDownLatch.countDown();
        return Unit.INSTANCE;
    }

    private static final void x(Function2 function2, Object object, Object object2) {
        function2.invoke(object, object2);
    }

    private static final void x(GsonBuilder gsonBuilder) {
        gsonBuilder.disableHtmlEscaping();
    }

    public static final /* synthetic */ LanguageServiceLogger access$getLsCommunicationLogger$p(Lsp4jServerConnector $this) {
        return $this.lsCommunicationLogger;
    }
}

