/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javaee.build.jspValidation;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.jps.dependency.GraphConfiguration;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.java.JVMClassNode;
import org.jetbrains.jps.dependency.java.JvmClassNodeBuilder;
import org.jetbrains.jps.javaee.build.jspValidation.JspFileDependenciesAnalyzer;
import org.jetbrains.jps.javaee.build.jspValidation.JspFileDependenciesData;
import org.jetbrains.jps.util.Iterators;
import org.jetbrains.org.objectweb.asm.ClassReader;

public final class DepGraphBasedDependenciesAnalyzer
implements JspFileDependenciesAnalyzer {
    private final GraphConfiguration myGraphConfig;

    public DepGraphBasedDependenciesAnalyzer(GraphConfiguration graphConfig) {
        this.myGraphConfig = graphConfig;
    }

    @Override
    public JspFileDependenciesData analyzeDependencies(File jspFile, String classFilePath, String[] pathsToIncludedFiles) throws IOException {
        List<File> includedFiles = Arrays.stream(pathsToIncludedFiles).map(File::new).filter(File::isFile).collect(Collectors.toList());
        ArrayList<File> dependencies = new ArrayList<File>(includedFiles);
        File classFile = new File(classFilePath);
        try (FileInputStream inputStream = new FileInputStream(classFile);){
            JVMClassNode node = JvmClassNodeBuilder.create((String)classFile.getAbsolutePath(), (ClassReader)new ClassReader((InputStream)new BufferedInputStream(inputStream)), (boolean)false).getResult();
            Iterable depSources = Iterators.unique((Iterable)Iterators.flat((Iterable)Iterators.map((Iterable)Iterators.unique((Iterable)Iterators.filter((Iterable)Iterators.map((Iterable)node.getUsages(), u -> u.getElementOwner()), id -> !id.equals((Object)node.getReferenceID()))), id -> this.myGraphConfig.getGraph().getSources(id))));
            for (NodeSource dependency : depSources) {
                dependencies.add(this.myGraphConfig.getPathMapper().toPath(dependency).toFile());
            }
        }
        return new JspFileDependenciesData(jspFile, dependencies, includedFiles);
    }

    @Override
    public void close() {
    }
}

