/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.css.scheme;

import com.intellij.css.scheme.CssValueParsingUtil;
import com.intellij.css.scheme.CssValueSchemeGenerator;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

public class CssMicrosoftSchemeGenerator {
    private final Set<String> propertiesToIgnore = ContainerUtil.newHashSet((Object[])new String[]{"z-index", "display", "position", "animation-name", "touch-action", "-ms-scroll-snap-x"});
    private final Set<String> existingPropertyNames = new HashSet<String>();
    private final Tag mySeeTag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("url argument is missing");
            return;
        }
        String url = args[0];
        String pathToDescriptorFiles = args.length > 1 ? args[1] : null;
        InputStream inputStream = null;
        PrintStream outputStream = null;
        try {
            outputStream = System.out;
            PrintStream outputStreamForPartialMatchedProperties = System.err;
            inputStream = URLUtil.openStream((URL)new URL(url));
            new CssMicrosoftSchemeGenerator(pathToDescriptorFiles).generateScheme(inputStream, outputStream, outputStreamForPartialMatchedProperties);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    private CssMicrosoftSchemeGenerator(@Nullable String pathToDescriptorFiles) {
        File directory;
        File[] files;
        if (pathToDescriptorFiles != null && (files = (directory = new File(pathToDescriptorFiles)).listFiles()) != null) {
            for (File xmlFile : files) {
                if (!xmlFile.exists() || !xmlFile.getName().endsWith(".xml")) continue;
                try {
                    Element load = JDOMUtil.load((File)xmlFile);
                    for (Element property : load.getChildren("property", load.getNamespace())) {
                        this.existingPropertyNames.add(property.getAttributeValue("id"));
                    }
                }
                catch (IOException | JDOMException e) {
                    System.err.println("Cannot read " + xmlFile.getPath());
                }
            }
        }
        this.mySeeTag = Tag.valueOf((String)"see");
        try {
            Method setSelfClosing = this.mySeeTag.getClass().getDeclaredMethod("setSelfClosing", new Class[0]);
            setSelfClosing.setAccessible(true);
            setSelfClosing.invoke((Object)this.mySeeTag, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private void generateScheme(InputStream inputStream, PrintStream out, PrintStream outForPartialMatchedProperties) throws IOException {
        Document document = Jsoup.parse((InputStream)inputStream, (String)"UTF-8", (String)"");
        out.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        out.println("<definitions xmlns=\"urn:schemas-jetbrains-com:css-xml\">");
        this.generateProperties(document, out, outForPartialMatchedProperties);
        out.println("</definitions>");
    }

    private void generateProperties(@NotNull Document document, @NotNull PrintStream out, @NotNull PrintStream outForPartialMatchedProperties) {
        if (document == null) {
            CssMicrosoftSchemeGenerator.$$$reportNull$$$0(0);
        }
        if (out == null) {
            CssMicrosoftSchemeGenerator.$$$reportNull$$$0(1);
        }
        if (outForPartialMatchedProperties == null) {
            CssMicrosoftSchemeGenerator.$$$reportNull$$$0(2);
        }
        org.jsoup.nodes.Element propertiesTitle = document.getElementById("properties").parent();
        assert ("h2".equals(propertiesTitle.tagName()));
        org.jsoup.nodes.Element table = propertiesTitle.nextElementSibling();
        assert (table != null && "table".equals(table.tagName()));
        Iterator iterator = table.select("tr a").iterator();
        while (iterator.hasNext()) {
            org.jsoup.nodes.Element link;
            this.generateProperty(link, this.existingPropertyNames.contains((link = (org.jsoup.nodes.Element)iterator.next()).text().trim()) ? outForPartialMatchedProperties : out);
        }
    }

    private void generateProperty(org.jsoup.nodes.Element link, PrintStream out) {
        String propertyName = link.text().trim();
        if (this.propertiesToIgnore.contains(propertyName)) {
            return;
        }
        String url = link.attr("href");
        try {
            Document propertyDocument = Jsoup.parse((InputStream)URLUtil.openStream((URL)new URL(url)), (String)"UTF-8", (String)"");
            org.jsoup.nodes.Element mainSection = propertyDocument.getElementById("mainSection");
            assert (mainSection != null);
            org.jsoup.nodes.Element syntaxTitle = mainSection.getElementsMatchingOwnText("Syntax").first();
            org.jsoup.nodes.Element syntaxBlock = CssMicrosoftSchemeGenerator.nextSibling(syntaxTitle, "p");
            String valueText = StringUtil.trimStart((String)StringUtil.trimStart((String)syntaxBlock.text(), (String)(propertyName + ":")), (String)(StringUtil.trimStart((String)propertyName, (String)"-ms") + ":")).trim();
            Map<String, String> valueTooltips = CssMicrosoftSchemeGenerator.retrieveValueTooltips(mainSection);
            String value = CssMicrosoftSchemeGenerator.generateValue(valueText, valueTooltips);
            if (this.existingPropertyNames.contains(propertyName)) {
                if (!value.contains("-ms-")) {
                    return;
                }
                System.err.println("==== PLEASE CHECK EXISTING VALUES FOR '" + propertyName + "'");
            }
            HashMap<String, String> attributesMap = new HashMap<String, String>();
            org.jsoup.nodes.Element cssInformationTitle = mainSection.getElementsMatchingOwnText("CSS information").first();
            org.jsoup.nodes.Element cssInformationBlock = CssMicrosoftSchemeGenerator.nextSibling(cssInformationTitle, "table");
            if (cssInformationBlock != null) {
                for (org.jsoup.nodes.Element tr : cssInformationBlock.select("tr")) {
                    attributesMap.put(tr.getElementsByTag("th").text(), tr.getElementsByTag("td").text());
                }
            }
            out.print("<property id=\"" + propertyName + "\"");
            out.print(" declared-in=\"0\"");
            out.print(" url=\"" + url + "\"");
            out.print(" applies=\"" + StringUtil.notNullize((String)((String)attributesMap.get("Applies To"))) + "\"");
            out.print(" initial=\"" + StringUtil.notNullize((String)((String)attributesMap.get("Initial Value"))) + "\"");
            out.print(" inherited=\"" + StringUtil.notNullize((String)((String)attributesMap.get("Inherited")), (String)"no").replace("true", "yes").replace("false", "no") + "\"");
            out.print(" percentage=\"" + StringUtil.notNullize((String)((String)attributesMap.get("Percentage")), (String)"N/A") + "\"");
            String media = (String)attributesMap.get("Media");
            if (StringUtil.isNotEmpty((String)media)) {
                out.print(" media=\"" + media + "\"");
            }
            out.println(">");
            org.jsoup.nodes.Element descriptionTag = mainSection.getElementsByTag("p").first();
            if (descriptionTag != null) {
                String description = this.extractAndSanitizeDescription(propertyName, descriptionTag);
                out.println("<description><![CDATA[" + description + "]]></description>");
            }
            out.print(value);
            out.println("</property>\n");
        }
        catch (IOException e) {
            System.err.println("Cannot download page for '" + propertyName + "' property (" + url + ")");
            throw new RuntimeException(e);
        }
    }

    private static String generateValue(String valueText, Map<String, String> valueTooltips) {
        return new CssValueSchemeGenerator(true, null).generate(CssValueParsingUtil.parseFile(valueText), valueTooltips);
    }

    @NotNull
    private static Map<String, String> retrieveValueTooltips(org.jsoup.nodes.Element mainSection) {
        HashMap<String, String> valueTooltips = new HashMap<String, String>();
        org.jsoup.nodes.Element propertyValuesTitle = mainSection.getElementsMatchingOwnText("Property values").first();
        Elements valuesBlocks = CssMicrosoftSchemeGenerator.allNextSiblings(propertyValuesTitle, "dl");
        for (org.jsoup.nodes.Element valuesBlock : valuesBlocks) {
            Iterator iterator = valuesBlock.select("dt").iterator();
            while (iterator.hasNext()) {
                org.jsoup.nodes.Element dt;
                HashSet<String> keys = new HashSet<String>();
                for (dt = (org.jsoup.nodes.Element)iterator.next(); dt != null && dt.tagName().equalsIgnoreCase("dt"); dt = dt.nextElementSibling()) {
                    keys.add(dt.text());
                }
                if (dt == null || !dt.tagName().equalsIgnoreCase("dd")) continue;
                for (String key : keys) {
                    valueTooltips.put(key, XmlStringUtil.escapeString((String)XmlStringUtil.stripHtml((String)dt.text())).replaceAll("&nbsp;", " "));
                }
            }
        }
        HashMap<String, String> hashMap = valueTooltips;
        if (hashMap == null) {
            CssMicrosoftSchemeGenerator.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    private String extractAndSanitizeDescription(String propertyName, org.jsoup.nodes.Element element) {
        for (org.jsoup.nodes.Element link : element.getElementsByTag("a")) {
            if ("property".equalsIgnoreCase(link.className()) && !propertyName.equalsIgnoreCase(link.text())) {
                Attributes attributes = new Attributes();
                attributes.put("cref", "P:" + link.text());
                link.replaceWith((Node)new org.jsoup.nodes.Element(this.mySeeTag, link.baseUri(), attributes));
                continue;
            }
            link.replaceWith((Node)TextNode.createFromEncoded((String)link.text()));
        }
        return element.toString();
    }

    private static org.jsoup.nodes.Element nextSibling(org.jsoup.nodes.Element element, String tagName) {
        for (org.jsoup.nodes.Element nextSibling = element.nextElementSibling(); nextSibling != null; nextSibling = nextSibling.nextElementSibling()) {
            if (!tagName.equals(nextSibling.tagName())) continue;
            return nextSibling;
        }
        return null;
    }

    private static Elements allNextSiblings(org.jsoup.nodes.Element element, String tagName) {
        Elements result = new Elements();
        for (org.jsoup.nodes.Element nextSibling = element.nextElementSibling(); nextSibling != null; nextSibling = nextSibling.nextElementSibling()) {
            if (!tagName.equals(nextSibling.tagName())) continue;
            result.add((Object)nextSibling);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outForPartialMatchedProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/css/scheme/CssMicrosoftSchemeGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/css/scheme/CssMicrosoftSchemeGenerator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "retrieveValueTooltips";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateProperties";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

