/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

public class XSParticleDecl {
    public static final short PARTICLE_EMPTY = 0;
    public static final short PARTICLE_ELEMENT = 1;
    public static final short PARTICLE_WILDCARD = 2;
    public static final short PARTICLE_CHOICE = 3;
    public static final short PARTICLE_SEQUENCE = 4;
    public static final short PARTICLE_ALL = 5;
    public static final short PARTICLE_ZERO_OR_ONE = 6;
    public static final short PARTICLE_ZERO_OR_MORE = 7;
    public static final short PARTICLE_ONE_OR_MORE = 8;
    public short fType = 0;
    public Object fValue = null;
    public Object fOtherValue = null;
    public int fMinOccurs = 1;
    public int fMaxOccurs = 1;
    private String fDescription = null;

    public boolean emptiable() {
        return this.minEffectiveTotalRange() == 0;
    }

    public boolean isEmpty() {
        if (this.fType == 1 || this.fType == 2) {
            return false;
        }
        if (this.fType == 0) {
            return true;
        }
        boolean bl = this.fValue == null || ((XSParticleDecl)this.fValue).isEmpty();
        boolean bl2 = this.fOtherValue == null || ((XSParticleDecl)this.fOtherValue).isEmpty();
        return bl && bl2;
    }

    public int minEffectiveTotalRange() {
        switch (this.fType) {
            case 4: 
            case 5: {
                return this.minEffectiveTotalRangeAllSeq();
            }
            case 3: {
                return this.minEffectiveTotalRangeChoice();
            }
        }
        return this.fMinOccurs;
    }

    private int minEffectiveTotalRangeAllSeq() {
        int n = ((XSParticleDecl)this.fValue).minEffectiveTotalRange();
        if (this.fOtherValue != null) {
            n += ((XSParticleDecl)this.fOtherValue).minEffectiveTotalRange();
        }
        return this.fMinOccurs * n;
    }

    private int minEffectiveTotalRangeChoice() {
        int n;
        int n2 = ((XSParticleDecl)this.fValue).minEffectiveTotalRange();
        if (this.fOtherValue != null && (n = ((XSParticleDecl)this.fOtherValue).minEffectiveTotalRange()) < n2) {
            n2 = n;
        }
        return this.fMinOccurs * n2;
    }

    public int maxEffectiveTotalRange() {
        switch (this.fType) {
            case 4: 
            case 5: {
                return this.maxEffectiveTotalRangeAllSeq();
            }
            case 3: {
                return this.maxEffectiveTotalRangeChoice();
            }
        }
        return this.fMaxOccurs;
    }

    private int maxEffectiveTotalRangeAllSeq() {
        int n = ((XSParticleDecl)this.fValue).maxEffectiveTotalRange();
        if (n == -1) {
            return -1;
        }
        if (this.fOtherValue != null) {
            int n2 = ((XSParticleDecl)this.fValue).maxEffectiveTotalRange();
            if (n2 == -1) {
                return -1;
            }
            n += n2;
        }
        if (n != 0 && this.fMaxOccurs == -1) {
            return -1;
        }
        return this.fMaxOccurs * n;
    }

    private int maxEffectiveTotalRangeChoice() {
        int n = ((XSParticleDecl)this.fValue).maxEffectiveTotalRange();
        if (n == -1) {
            return -1;
        }
        if (this.fOtherValue != null) {
            int n2 = ((XSParticleDecl)this.fValue).maxEffectiveTotalRange();
            if (n2 == -1) {
                return -1;
            }
            if (n2 < n) {
                n = n2;
            }
        }
        if (n != 0 && this.fMaxOccurs == -1) {
            return -1;
        }
        return this.fMaxOccurs * n;
    }

    public String toString() {
        if (this.fDescription == null) {
            StringBuffer stringBuffer = new StringBuffer();
            this.appendParticle(stringBuffer);
            if (!(this.fMinOccurs == 0 && this.fMaxOccurs == 0 || this.fMinOccurs == 1 && this.fMaxOccurs == 1)) {
                stringBuffer.append("{" + this.fMinOccurs);
                if (this.fMaxOccurs == -1) {
                    stringBuffer.append("-UNBOUNDED");
                } else if (this.fMinOccurs != this.fMaxOccurs) {
                    stringBuffer.append("-" + this.fMaxOccurs);
                }
                stringBuffer.append("}");
            }
            this.fDescription = stringBuffer.toString();
        }
        return this.fDescription;
    }

    void appendParticle(StringBuffer stringBuffer) {
        switch (this.fType) {
            case 0: {
                stringBuffer.append("EMPTY");
                break;
            }
            case 1: 
            case 2: {
                stringBuffer.append('(');
                stringBuffer.append(this.fValue.toString());
                stringBuffer.append(')');
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                if (this.fOtherValue == null) {
                    stringBuffer.append(this.fValue.toString());
                    break;
                }
                if (this.fType == 5) {
                    stringBuffer.append("all(");
                } else {
                    stringBuffer.append('(');
                }
                stringBuffer.append(this.fValue.toString());
                if (this.fType == 3) {
                    stringBuffer.append('|');
                } else {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.fOtherValue.toString());
                stringBuffer.append(')');
            }
        }
    }
}

