/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.local;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeTargetRunSetup;
import com.intellij.javascript.nodejs.interpreter.local.NodeAsdfUtil;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeLocalTargetRunSetup;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsLocalInterpreter
extends NodeJsInterpreter {
    private static final Logger LOG = Logger.getInstance(NodeJsLocalInterpreter.class);
    static final String WIN_EXE_EXT = ".exe";
    private static final int BLOCKING_WAIT_TIMEOUT_MILLIS = 2000;
    private static final int TOTAL_WAIT_TIMEOUT_MILLIS = 30000;
    @NlsSafe
    private final String myInterpreterSystemIndependentPath;
    @NlsSafe
    private final String myInterpreterSystemDependentPath;
    private final Path myInterpreter;
    private FutureTask<String> myConfigPrefixFuture;
    private final Object myConfigPrefixFutureLock;

    public NodeJsLocalInterpreter(@NotNull String interpreterPath) {
        if (interpreterPath == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(0);
        }
        this.myConfigPrefixFutureLock = new Object();
        this.myInterpreterSystemIndependentPath = FileUtil.toSystemIndependentName((String)interpreterPath);
        this.myInterpreterSystemDependentPath = FileUtil.toSystemDependentName((String)interpreterPath);
        this.myInterpreter = Path.of(interpreterPath, new String[0]);
    }

    @Override
    @NotNull
    public String getReferenceName() {
        String path2 = this.myInterpreterSystemIndependentPath;
        if (SystemInfo.isWindows && path2.endsWith(WIN_EXE_EXT)) {
            path2 = path2.substring(0, path2.length() - WIN_EXE_EXT.length());
        }
        String string = path2;
        if (string == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String userHome = FileUtil.toSystemDependentName((String)SystemProperties.getUserHome());
        if (StringUtil.isEmptyOrSpaces((String)userHome)) {
            String string = this.myInterpreterSystemDependentPath;
            if (string == null) {
                NodeJsLocalInterpreter.$$$reportNull$$$0(2);
            }
            return string;
        }
        String userHomeWithSeparator = (userHome = StringUtil.trimEnd((String)userHome, (char)File.separatorChar)) + File.separatorChar;
        if (this.myInterpreterSystemDependentPath.startsWith(userHomeWithSeparator)) {
            String string = "~" + this.myInterpreterSystemDependentPath.substring(userHome.length());
            if (string == null) {
                NodeJsLocalInterpreter.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = this.myInterpreterSystemDependentPath;
        if (string == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @Nullable
    public Ref<SemVer> getCachedVersion() {
        return NodeJsLocalInterpreterManager.getInstance().getCachedVersion(this);
    }

    @Override
    public void fetchVersion(@NotNull NullableConsumer<? super SemVer> consumer) {
        if (consumer == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(5);
        }
        NodeJsLocalInterpreterManager.getInstance().fetchVersion(this, consumer);
    }

    @Override
    @Nullable
    public String validate(@Nullable Project project) {
        return this.isValid() ? null : JavaScriptBundle.message((String)"node.interpreter.specified_interpreter_correctly.dialog.message", (Object[])new Object[0]);
    }

    @NotNull
    public String getInterpreterSystemDependentPath() {
        String string = this.myInterpreterSystemDependentPath;
        if (string == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getInterpreterSystemIndependentPath() {
        String string = this.myInterpreterSystemIndependentPath;
        if (string == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(7);
        }
        return string;
    }

    public boolean isValid() {
        return Files.isRegularFile(this.myInterpreter, new LinkOption[0]) && Files.isExecutable(this.myInterpreter);
    }

    @NotNull
    public NodeJsLocalInterpreterType getType() {
        NodeJsLocalInterpreterType nodeJsLocalInterpreterType = NodeJsLocalInterpreterType.getInstance();
        if (nodeJsLocalInterpreterType == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(8);
        }
        return nodeJsLocalInterpreterType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeJsLocalInterpreter that = (NodeJsLocalInterpreter)o;
        return this.myInterpreterSystemIndependentPath.equals(that.myInterpreterSystemIndependentPath);
    }

    public int hashCode() {
        return this.myInterpreterSystemIndependentPath.hashCode();
    }

    public String toString() {
        return this.myInterpreterSystemIndependentPath;
    }

    @Nullable
    private static String getWinNodistPrefixSystemIndependent() {
        String nodistPrefix;
        if (SystemInfo.isWindows && StringUtil.isNotEmpty((String)(nodistPrefix = EnvironmentUtil.getValue((String)"NODIST_PREFIX")))) {
            return (nodistPrefix = FileUtil.toSystemIndependentName((String)nodistPrefix)).endsWith("/") ? nodistPrefix : nodistPrefix + "/";
        }
        return null;
    }

    public boolean isWrapperSwitchingVersionsInside() {
        String nodistPrefix = NodeJsLocalInterpreter.getWinNodistPrefixSystemIndependent();
        if (nodistPrefix != null && this.myInterpreterSystemIndependentPath.startsWith(nodistPrefix)) {
            return PathUtil.getParentPath((String)this.myInterpreterSystemIndependentPath).equals(nodistPrefix + "bin");
        }
        if (NodeAsdfUtil.isShimsNode(this)) {
            return true;
        }
        return this.myInterpreterSystemIndependentPath.endsWith("/.volta/bin/node") || this.myInterpreterSystemIndependentPath.endsWith("/Volta/node.exe");
    }

    @Nullable
    public VirtualFile getGlobalNodeModulesVirtualDir() {
        Path globalNodeModulesDir;
        String configPrefix = this.getConfigPrefix();
        if (StringUtil.isNotEmpty((String)configPrefix) && Files.isDirectory(globalNodeModulesDir = SystemInfo.isWindows ? Path.of(configPrefix, "node_modules") : Path.of(configPrefix, "lib", "node_modules"), new LinkOption[0])) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByNioFile(globalNodeModulesDir);
            if (file == null) {
                if (ApplicationManager.getApplication().isWriteIntentLockAcquired() && TransactionGuard.getInstance().isWriteSafeModality(ModalityState.defaultModalityState())) {
                    file = (VirtualFile)WriteAction.compute(() -> NodeJsLocalInterpreter.refresh(globalNodeModulesDir, true));
                } else {
                    ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> WriteAction.run(() -> NodeJsLocalInterpreter.refresh(globalNodeModulesDir, false)));
                }
            }
            return file;
        }
        return null;
    }

    @Nullable
    public String getConfigPrefix() {
        String configPrefix = this.fetchConfigPrefix();
        if (StringUtil.isEmpty((String)configPrefix) || !Files.isDirectory(Path.of(configPrefix, new String[0]), new LinkOption[0])) {
            configPrefix = this.guessConfigPrefix();
            LOG.info("Guessed config prefix for " + this.myInterpreterSystemDependentPath + ": " + configPrefix);
        }
        return configPrefix;
    }

    @Nullable
    private String guessConfigPrefix() {
        Path npmDir;
        String appDataDirPath;
        Path interpreterDir = this.myInterpreter.getParent();
        if (interpreterDir == null) {
            return null;
        }
        if (SystemInfo.isWindows && !NodeJsLocalInterpreter.isEmptyNpmRc(interpreterDir) && !(appDataDirPath = StringUtil.notNullize((String)EnvironmentUtil.getValue((String)"APPDATA")).trim()).isEmpty() && (npmDir = Path.of(appDataDirPath, "npm")).isAbsolute() && Files.isDirectory(npmDir, new LinkOption[0])) {
            return npmDir.toAbsolutePath().toString();
        }
        if (SystemInfo.isWindows) {
            return interpreterDir.toAbsolutePath().toString();
        }
        Path parentDir = interpreterDir.getParent();
        return parentDir != null ? parentDir.toAbsolutePath().toString() : null;
    }

    @Nullable
    private static VirtualFile refresh(@NotNull Path globalNodeModulesDir, boolean sync2) {
        if (globalNodeModulesDir == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(9);
        }
        VirtualFile result2 = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(globalNodeModulesDir);
        LOG.info("Npm global node_modules (" + String.valueOf(globalNodeModulesDir) + ") " + (sync2 ? "sync" : "async") + " refresh: " + (result2 != null ? "success" : "not found"));
        return result2;
    }

    private static boolean isEmptyNpmRc(@NotNull Path interpreterDir) {
        Path npmRc;
        if (interpreterDir == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(10);
        }
        if (!Files.isRegularFile(npmRc = interpreterDir.resolve("node_modules").resolve("npm").resolve("npmrc"), new LinkOption[0])) {
            return false;
        }
        try {
            return Files.size(npmRc) == 0L;
        }
        catch (IOException e) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private String fetchConfigPrefix() {
        FutureTask<String> future;
        Object object = this.myConfigPrefixFutureLock;
        synchronized (object) {
            future = this.myConfigPrefixFuture;
            if (future == null) {
                future = new FutureTask<String>(() -> {
                    try {
                        return this.doFetchConfigPrefix();
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to run 'npm config get prefix'", (Throwable)e);
                        return null;
                    }
                });
                ApplicationManager.getApplication().executeOnPooledThread(future);
                this.myConfigPrefixFuture = future;
            }
        }
        try {
            return future.get(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted npm global package dir calculation", (Throwable)e);
        }
        catch (ExecutionException e) {
        }
        catch (TimeoutException e) {
            LOG.warn("Npm global package dir hasn't been calculated in 2000 ms, making a guess");
        }
        return null;
    }

    @NotNull
    private String doFetchConfigPrefix() throws com.intellij.execution.ExecutionException {
        String errorMessage = this.validate(null);
        if (errorMessage != null) {
            throw new com.intellij.execution.ExecutionException(errorMessage);
        }
        long startNano = System.nanoTime();
        Project project = ProjectManager.getInstance().getDefaultProject();
        NodeTargetRun targetRun = new NodeTargetRun((NodeJsInterpreter)this, project, null, NodeTargetRunOptions.of(false));
        NpmUtil.configureNpmCommand(targetRun, NodePackageRef.create("npm"), null, NpmCommand.CONFIG, List.of("get", "prefix"), null);
        ProcessWithCmdLine processWithCmdLine = targetRun.startProcessEx();
        CapturingProcessRunner runner = new CapturingProcessRunner((BaseProcessHandler)processWithCmdLine.getProcessHandler());
        ProcessOutput output = runner.runProcess(30000, true);
        if (output.isTimeout()) {
            throw new com.intellij.execution.ExecutionException(JavaScriptBundle.message((String)"node.interpreter.command_timed_out.dialog.message", (Object[])new Object[]{processWithCmdLine.getCommandLinePresentation(), 30000}));
        }
        String dirName = output.getStdout().trim();
        LOG.info(processWithCmdLine.getCommandLinePresentation() + "=" + dirName + " (" + TimeoutUtil.getDurationMillis((long)startNano) + " ms)");
        String string = OSAgnosticPathUtil.expandUserHome((String)dirName);
        if (string == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(11);
        }
        return string;
    }

    public boolean isElectron() {
        return this.myInterpreterSystemIndependentPath.endsWith("/Contents/MacOS/Electron") || this.myInterpreterSystemIndependentPath.endsWith("/electron") || this.myInterpreterSystemIndependentPath.endsWith("/electron.cmd");
    }

    @Nullable
    public static NodeJsLocalInterpreter tryCast(@Nullable NodeJsInterpreter interpreter2) {
        return (NodeJsLocalInterpreter)ObjectUtils.tryCast((Object)interpreter2, NodeJsLocalInterpreter.class);
    }

    @NotNull
    public static NodeJsLocalInterpreter cast(@Nullable NodeJsInterpreter interpreter2) throws com.intellij.execution.ExecutionException {
        if (interpreter2 == null) {
            throw new com.intellij.execution.ExecutionException(JavaScriptBundle.message((String)"node.interpreter.unspecified_interpreter.dialog.message", (Object[])new Object[0]));
        }
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter2);
        if (localInterpreter == null) {
            throw new com.intellij.execution.ExecutionException(JavaScriptBundle.message((String)"node.interpreter.unspecified_local_interpreter.dialog.message", (Object[])new Object[0]));
        }
        NodeJsLocalInterpreter nodeJsLocalInterpreter = localInterpreter;
        if (nodeJsLocalInterpreter == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(12);
        }
        return nodeJsLocalInterpreter;
    }

    @NotNull
    public static NodeJsLocalInterpreter castAndValidate(@Nullable NodeJsInterpreter interpreter2) throws com.intellij.execution.ExecutionException {
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.cast(interpreter2);
        if (localInterpreter.isValid()) {
            NodeJsLocalInterpreter nodeJsLocalInterpreter = localInterpreter;
            if (nodeJsLocalInterpreter == null) {
                NodeJsLocalInterpreter.$$$reportNull$$$0(13);
            }
            return nodeJsLocalInterpreter;
        }
        throw new com.intellij.execution.ExecutionException(JavaScriptBundle.message((String)"node.interpreter.specified_interpreter_correctly.dialog.message", (Object[])new Object[0]));
    }

    @NlsContexts.DialogMessage
    @Nullable
    public static String getErrorMessage(@Nullable NodeJsInterpreter interpreter2) {
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.tryCast(interpreter2);
        if (localInterpreter == null) {
            return JavaScriptBundle.message((String)"node.interpreter.unspecified_local_interpreter.dialog.message", (Object[])new Object[0]);
        }
        return localInterpreter.validate(null);
    }

    public static void checkForRunConfiguration(@Nullable NodeJsInterpreter interpreter2) throws RuntimeConfigurationError {
        String errorMessage = NodeJsLocalInterpreter.getErrorMessage(interpreter2);
        if (errorMessage != null) {
            throw new RuntimeConfigurationError(errorMessage);
        }
    }

    @Override
    @NotNull
    public NodeTargetRunSetup createTargetRunSetup(@NotNull Project project, @NotNull NodeTargetRunOptions options) {
        if (project == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(14);
        }
        if (options == null) {
            NodeJsLocalInterpreter.$$$reportNull$$$0(15);
        }
        return new NodeLocalTargetRunSetup(this, new LocalTargetEnvironmentRequest());
    }

    @Override
    @Nullable
    public TargetEnvironmentType<?> getTargetEnvironmentType() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 6, 7, 8, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalNodeModulesDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterDir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceName";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterSystemDependentPath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterSystemIndependentPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "doFetchConfigPrefix";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "cast";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "castAndValidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fetchVersion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "refresh";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyNpmRc";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createTargetRunSetup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 6, 7, 8, 11, 12, 13 -> new IllegalStateException(string);
        };
    }
}

