/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.stubs.factories;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSElementType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSVariableBaseImpl;
import com.intellij.lang.javascript.psi.stubs.JSVariableStub;
import com.intellij.lang.javascript.psi.stubs.impl.JSVariableStubImpl;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.javascript.stubs.factories.JSStubFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ(\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\n\u001a\u00020\u00032\u0010\u0010\u000b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\r\u0018\u00010\fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/javascript/stubs/factories/JSVariableStubFactory;", "Lcom/intellij/lang/javascript/stubs/factories/JSStubFactory;", "Lcom/intellij/lang/javascript/psi/stubs/JSVariableStub;", "Lcom/intellij/lang/javascript/psi/JSVariable;", "elementTypeSupplier", "Lkotlin/Function0;", "Lcom/intellij/lang/javascript/psi/JSElementType;", "<init>", "(Lkotlin/jvm/functions/Function0;)V", "createStub", "psi", "parentStub", "Lcom/intellij/psi/stubs/StubElement;", "Lcom/intellij/psi/PsiElement;", "shouldCreateStub", "", "node", "Lcom/intellij/lang/ASTNode;", "intellij.javascript.analysis.impl"})
public class JSVariableStubFactory
extends JSStubFactory<JSVariableStub<JSVariable>, JSVariable> {
    public JSVariableStubFactory(@NotNull Function0<? extends JSElementType<JSVariable>> elementTypeSupplier) {
        Intrinsics.checkNotNullParameter(elementTypeSupplier, (String)"elementTypeSupplier");
        super(elementTypeSupplier);
    }

    @NotNull
    public JSVariableStub<JSVariable> createStub(@NotNull JSVariable psi, @Nullable StubElement<? extends PsiElement> parentStub) {
        Intrinsics.checkNotNullParameter((Object)psi, (String)"psi");
        return new JSVariableStubImpl(psi, parentStub, this.getElementType(), 0);
    }

    public boolean shouldCreateStub(@NotNull ASTNode node) {
        ASTNode parent;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (parent == null || parent.getElementType() != JSElementTypes.VAR_STATEMENT) {
            return true;
        }
        boolean insideFunction = false;
        for (parent = node.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            IElementType type2;
            Intrinsics.checkNotNullExpressionValue((Object)parent.getElementType(), (String)"getElementType(...)");
            if (JSElementTypes.FUNCTIONS.contains(type2)) {
                ASTNode docComment;
                ASTNode aSTNode = node.findChildByType(JSElementTypes.DOC_COMMENT);
                if (aSTNode == null) {
                    aSTNode = node.getTreeParent().findChildByType(JSElementTypes.DOC_COMMENT);
                }
                ASTNode aSTNode2 = docComment = aSTNode;
                if ((aSTNode2 != null ? aSTNode2.getFirstChildNode() : null) != null) {
                    return true;
                }
                insideFunction = true;
                break;
            }
            if (!JSExtendedLanguagesTokenSetProvider.CLASSES.contains(type2)) continue;
            return true;
        }
        if (!insideFunction && !JSVariableBaseImpl.hasBlockScope((ASTNode)node)) {
            return true;
        }
        ASTNode initializer = JSTreeUtil.getInitializerNode((ASTNode)node);
        return initializer != null && !JSSymbolUtil.typeMayBeInlined((ASTNode)initializer);
    }
}

