/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.validation.inspections;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.psi.XsltElementFactory;
import org.intellij.lang.xpath.xslt.psi.XsltVariable;
import org.intellij.lang.xpath.xslt.validation.XsltValidator;
import org.intellij.lang.xpath.xslt.validation.inspections.XsltInspection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class UnusedElementInspection
extends XsltInspection {
    @NonNls
    @NotNull
    public String getShortName() {
        return "XsltUnusedDeclaration";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnusedElementInspection.$$$reportNull$$$0(0);
        }
        if (!(holder.getFile() instanceof XmlFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                UnusedElementInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new MyVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/xslt/validation/inspections/UnusedElementInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/xslt/validation/inspections/UnusedElementInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class MyVisitor
    extends XmlElementVisitor {
        private final ProblemsHolder myHolder;

        MyVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitXmlAttribute(@NotNull XmlAttribute attribute) {
            if (attribute == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            if (!XsltSupport.isVariableOrParamName(attribute)) {
                return;
            }
            XmlTag tag = attribute.getParent();
            if (XsltSupport.isTopLevelElement(tag)) {
                return;
            }
            XsltVariable variable = XsltElementFactory.getInstance().wrapElement(tag, XsltVariable.class);
            String name = variable.getName();
            if (name == null || name.isEmpty()) {
                return;
            }
            XsltValidator.checkUnusedVariable(variable, this.myHolder);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/intellij/lang/xpath/xslt/validation/inspections/UnusedElementInspection$MyVisitor", "visitXmlAttribute"));
        }
    }
}

