/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 70317572158648L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(367520280 + (char)-19878, -367651350 - -((char)-3249), (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(367520280 + (char)-19877, -367651350 - -((char)-2659), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 38828295145907L;
                thread = Thread.currentThread();
                int n2 = SshAgentIpcService.r();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (n2 != 0) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(1790809410 - 29639, -1790809410 - -((char)-31682), (int)l2) + string + WindowsNamedPipeAgentIpc.b(1790809410 - 29640, 1790809410 - 18200, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(1790809410 - 29637, -1790809410 - -((char)-32610), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block14: {
            block15: {
                l2 = 20633881179845L;
                Object object = this.lock;
                n2 = SshAgentIpcService.r();
                synchronized (object) {
                    boolean bl;
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(858246360 + 20786, 858246360 + (char)-23497, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(858246360 + 20785, 858246360 + 22771, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(858246360 + 20784, 858246360 + (char)-32471, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (n2 != 0) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(858246360 + 20783, 858246360 + 29523, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(858246360 + 20782, -858246360 + -16248, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(858246360 + 20781, 858246360 + 30643, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(858246360 + 20783, 858246360 + 29523, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(858246360 + 20780, -858246360 + -29983, (int)l2));
            if (ActionTimestamp.r() != null) {
                SshAgentIpcService.r(++n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int n3;
                block6: {
                    long l2 = 137184376564463L;
                    n3 = SshAgentIpcService.N();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (n3 == 0) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (n3 == 0) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int n2;
        long l2;
        block27: {
            block28: {
                l2 = 106692826239883L;
                int n3 = SshAgentIpcService.N();
                this.assertConnectionThread();
                Object object3 = this.lock;
                n2 = n3;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (n2 == 0) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1543611390 + (char)-10417, 1543611390 + (char)-13154, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1543611390 + (char)-10421, 1543611390 + (char)-32409, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1543611390 + (char)-10418, -1543611390 + -((char)-9250), (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1543611390 + (char)-10421, 1543611390 + (char)-32409, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1543611390 + (char)-10415, 1543611390 + 27434, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1543611390 + (char)-10417, 1543611390 + (char)-13154, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1543611390 + (char)-10421, 1543611390 + (char)-32409, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1543611390 + (char)-10416, 1543611390 + (char)-31533, (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (n2 == 0) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n4 = Kernel32.INSTANCE.GetLastError();
                if (n4 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1543611390 + (char)-10417, 1543611390 + (char)-13154, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1543611390 + (char)-10421, 1543611390 + (char)-32409, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1543611390 + (char)-10413, 1543611390 + (char)-28931, (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(1543611390 + (char)-10421, 1543611390 + (char)-32409, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1543611390 + (char)-10414, -1543611390 + -28322, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n4)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (n2 == 0) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(1543611390 + (char)-10421, 1543611390 + (char)-32409, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1543611390 + (char)-10415, 1543611390 + 27434, (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1543611390 + (char)-10417, 1543611390 + (char)-13154, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1543611390 + (char)-10421, 1543611390 + (char)-32409, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1543611390 + (char)-10411, 1543611390 + (char)-24087, (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 5380554856411L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-1039122960 + -((char)-25342), 1039122960 + 28234, (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 97038189684425L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1993574700 - 14127, 1993574700 - 2376, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "\u00c0Bd\b\u00bb\u00c3\u00f3M\u009a\u008f\u00d8\u00ae\u0094#\u00c8\u00e6\u00b2\u00d9T\u0014\u00926.\u0080\u00e9\u0010\u00c4\u00b2\u00fev\u0091E\u007f\u00a7t\u00fd\u00c8|\u001c\u009f";
                        var4_3 = "\u00c0Bd\b\u00bb\u00c3\u00f3M\u009a\u008f\u00d8\u00ae\u0094#\u00c8\u00e6\u00b2\u00d9T\u0014\u00926.\u0080\u00e9\u0010\u00c4\u00b2\u00fev\u0091E\u007f\u00a7t\u00fd\u00c8|\u001c\u009f".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 51;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 70;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 21;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 53;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 55;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 51;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 97;
                                        break;
                                    }
                                    default: {
                                        v11 = 97;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x3735) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 161;
                            case 1 -> 229;
                            case 2 -> 56;
                            case 3 -> 83;
                            case 4 -> 151;
                            case 5 -> 45;
                            case 6 -> 2;
                            case 7 -> 180;
                            case 8 -> 175;
                            case 9 -> 58;
                            case 10 -> 171;
                            case 11 -> 242;
                            case 12 -> 88;
                            case 13 -> 61;
                            case 14 -> 208;
                            case 15 -> 70;
                            case 16 -> 57;
                            case 17 -> 119;
                            case 18 -> 172;
                            case 19 -> 201;
                            case 20 -> 214;
                            case 21 -> 188;
                            case 22 -> 154;
                            case 23 -> 24;
                            case 24 -> 183;
                            case 25 -> 240;
                            case 26 -> 16;
                            case 27 -> 209;
                            case 28 -> 126;
                            case 29 -> 213;
                            case 30 -> 131;
                            case 31 -> 108;
                            case 32 -> 162;
                            case 33 -> 37;
                            case 34 -> 62;
                            case 35 -> 207;
                            case 36 -> 236;
                            case 37 -> 149;
                            case 38 -> 223;
                            case 39 -> 178;
                            case 40 -> 132;
                            case 41 -> 138;
                            case 42 -> 237;
                            case 43 -> 36;
                            case 44 -> 196;
                            case 45 -> 145;
                            case 46 -> 30;
                            case 47 -> 241;
                            case 48 -> 150;
                            case 49 -> 19;
                            case 50 -> 216;
                            case 51 -> 212;
                            case 52 -> 233;
                            case 53 -> 246;
                            case 54 -> 55;
                            case 55 -> 125;
                            case 56 -> 93;
                            case 57 -> 137;
                            case 58 -> 97;
                            case 59 -> 72;
                            case 60 -> 41;
                            case 61 -> 107;
                            case 62 -> 135;
                            case 63 -> 192;
                            case 64 -> 84;
                            case 65 -> 222;
                            case 66 -> 160;
                            case 67 -> 129;
                            case 68 -> 199;
                            case 69 -> 0;
                            case 70 -> 25;
                            case 71 -> 66;
                            case 72 -> 170;
                            case 73 -> 177;
                            case 74 -> 50;
                            case 75 -> 143;
                            case 76 -> 243;
                            case 77 -> 31;
                            case 78 -> 130;
                            case 79 -> 103;
                            case 80 -> 65;
                            case 81 -> 136;
                            case 82 -> 163;
                            case 83 -> 82;
                            case 84 -> 60;
                            case 85 -> 53;
                            case 86 -> 21;
                            case 87 -> 148;
                            case 88 -> 94;
                            case 89 -> 244;
                            case 90 -> 32;
                            case 91 -> 202;
                            case 92 -> 156;
                            case 93 -> 217;
                            case 94 -> 197;
                            case 95 -> 232;
                            case 96 -> 113;
                            case 97 -> 11;
                            case 98 -> 123;
                            case 99 -> 203;
                            case 100 -> 245;
                            case 101 -> 210;
                            case 102 -> 182;
                            case 103 -> 174;
                            case 104 -> 252;
                            case 105 -> 248;
                            case 106 -> 206;
                            case 107 -> 101;
                            case 108 -> 77;
                            case 109 -> 52;
                            case 110 -> 153;
                            case 111 -> 105;
                            case 112 -> 226;
                            case 113 -> 254;
                            case 114 -> 140;
                            case 115 -> 39;
                            case 116 -> 144;
                            case 117 -> 204;
                            case 118 -> 117;
                            case 119 -> 215;
                            case 120 -> 189;
                            case 121 -> 59;
                            case 122 -> 44;
                            case 123 -> 17;
                            case 124 -> 85;
                            case 125 -> 191;
                            case 126 -> 142;
                            case 127 -> 51;
                            case 128 -> 147;
                            case 129 -> 186;
                            case 130 -> 48;
                            case 131 -> 193;
                            case 132 -> 165;
                            case 133 -> 122;
                            case 134 -> 43;
                            case 135 -> 23;
                            case 136 -> 5;
                            case 137 -> 224;
                            case 138 -> 231;
                            case 139 -> 104;
                            case 140 -> 179;
                            case 141 -> 211;
                            case 142 -> 13;
                            case 143 -> 152;
                            case 144 -> 1;
                            case 145 -> 221;
                            case 146 -> 141;
                            case 147 -> 99;
                            case 148 -> 95;
                            case 149 -> 4;
                            case 150 -> 47;
                            case 151 -> 139;
                            case 152 -> 71;
                            case 153 -> 20;
                            case 154 -> 255;
                            case 155 -> 116;
                            case 156 -> 75;
                            case 157 -> 184;
                            case 158 -> 176;
                            case 159 -> 127;
                            case 160 -> 28;
                            case 161 -> 112;
                            case 162 -> 185;
                            case 163 -> 67;
                            case 164 -> 187;
                            case 165 -> 54;
                            case 166 -> 218;
                            case 167 -> 80;
                            case 168 -> 14;
                            case 169 -> 92;
                            case 170 -> 81;
                            case 171 -> 98;
                            case 172 -> 27;
                            case 173 -> 109;
                            case 174 -> 38;
                            case 175 -> 29;
                            case 176 -> 64;
                            case 177 -> 76;
                            case 178 -> 91;
                            case 179 -> 34;
                            case 180 -> 69;
                            case 181 -> 166;
                            case 182 -> 110;
                            case 183 -> 230;
                            case 184 -> 111;
                            case 185 -> 22;
                            case 186 -> 79;
                            case 187 -> 114;
                            case 188 -> 200;
                            case 189 -> 78;
                            case 190 -> 120;
                            case 191 -> 115;
                            case 192 -> 157;
                            case 193 -> 134;
                            case 194 -> 40;
                            case 195 -> 12;
                            case 196 -> 128;
                            case 197 -> 133;
                            case 198 -> 253;
                            case 199 -> 227;
                            case 200 -> 124;
                            case 201 -> 238;
                            case 202 -> 225;
                            case 203 -> 173;
                            case 204 -> 146;
                            case 205 -> 168;
                            case 206 -> 89;
                            case 207 -> 86;
                            case 208 -> 3;
                            case 209 -> 220;
                            case 210 -> 239;
                            case 211 -> 33;
                            case 212 -> 87;
                            case 213 -> 194;
                            case 214 -> 234;
                            case 215 -> 102;
                            case 216 -> 26;
                            case 217 -> 73;
                            case 218 -> 9;
                            case 219 -> 205;
                            case 220 -> 195;
                            case 221 -> 219;
                            case 222 -> 198;
                            case 223 -> 121;
                            case 224 -> 8;
                            case 225 -> 100;
                            case 226 -> 18;
                            case 227 -> 46;
                            case 228 -> 7;
                            case 229 -> 181;
                            case 230 -> 159;
                            case 231 -> 164;
                            case 232 -> 169;
                            case 233 -> 96;
                            case 234 -> 35;
                            case 235 -> 68;
                            case 236 -> 228;
                            case 237 -> 74;
                            case 238 -> 247;
                            case 239 -> 15;
                            case 240 -> 250;
                            case 241 -> 49;
                            case 242 -> 190;
                            case 243 -> 106;
                            case 244 -> 42;
                            case 245 -> 235;
                            case 246 -> 249;
                            case 247 -> 155;
                            case 248 -> 90;
                            case 249 -> 10;
                            case 250 -> 158;
                            case 251 -> 118;
                            case 252 -> 6;
                            case 253 -> 251;
                            case 254 -> 167;
                            default -> 63;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (n2 == 0) {
                ActionTimestamp.r(new int[3]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 21397476248316L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int n3 = SshAgentIpcService.r();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (n3 != 0) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-50855160 - -((char)-8398), -50855160 - -((char)-6429), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-50855160 - -((char)-8394), -50855160 - -((char)-18166), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-50855160 - -((char)-8419), -50855160 - -((char)-21574), (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n4 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-50855160 - -((char)-8398), -50855160 - -((char)-6429), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-50855160 - -((char)-8394), -50855160 - -((char)-18166), (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-50855160 - -((char)-8422), 50855160 - (char)-10050, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n4));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int n2;
                    block13: {
                        long l2 = 131782965772204L;
                        int n3 = SshAgentIpcService.N();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(484172580 + (char)-2993, 484172580 + (char)-12703, (int)l2));
                        n2 = n3;
                        try {
                            try {
                                try {
                                    try {
                                        if (n2 == 0 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (n2 == 0) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(484172580 + (char)-2996, -484172580 + -((char)-18629), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (n2 == 0) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int n2;
        long l2;
        block25: {
            block26: {
                l2 = 131332274143914L;
                int n3 = SshAgentIpcService.N();
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    n2 = n3;
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (n2 == 0) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (n2 == 0) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(764138100 + 22520, 764138100 + 20297, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(764138100 + 22516, 764138100 + (char)-24112, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(764138100 + 22531, -764138100 + -21348, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(764138100 + 22516, 764138100 + (char)-24112, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(764138100 + 22522, 764138100 + (char)-29803, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(764138100 + 22520, 764138100 + 20297, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(764138100 + 22516, 764138100 + (char)-24112, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(764138100 + 22532, -764138100 + -30611, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (n2 == 0) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(764138100 + 22520, 764138100 + 20297, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(764138100 + 22516, 764138100 + (char)-24112, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(764138100 + 22533, -764138100 + -25692, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (n2 == 0) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(764138100 + 22520, 764138100 + 20297, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(764138100 + 22516, 764138100 + (char)-24112, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(764138100 + 22534, -764138100 + -18248, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                int n3;
                block16: {
                    l2 = 108743725011620L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                n3 = SshAgentIpcService.N();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (n3 == 0) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-551935770 + -26244, -551935770 + -28467, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-551935770 + -26240, -551935770 + -15516, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-551935770 + -26225, -551935770 + -16137, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-551935770 + -26228, 551935770 + (char)-32673, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-551935770 + -26244, -551935770 + -28467, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-551935770 + -26240, -551935770 + -15516, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-551935770 + -26227, -551935770 + -16459, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (n3 == 0) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (n3 == 0) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n4 = n2;
                    if (n4 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-551935770 + -26244, -551935770 + -28467, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-551935770 + -26240, -551935770 + -15516, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-551935770 + -26230, 551935770 + 15076, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n4));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-551935770 + -26244, -551935770 + -28467, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-551935770 + -26240, -551935770 + -15516, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-551935770 + -26229, -551935770 + -((char)-29934), (int)l2));
                    if (n3 == 0) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-551935770 + -26244, -551935770 + -28467, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-551935770 + -26240, -551935770 + -15516, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-551935770 + -26264, 551935770 + 10586, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-551935770 + -26263, 551935770 + 24266, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00be&/\u00e5\u0080Kw\u0081\u0014`\u009a\u00cc\u0095\u0002\u00cd\u0088K\njN+]\u00a5\u00fc\u0090\u009c\u00c2\u00e4\u0087\u0006\u00a95\u00cd\u0087\u00b6F\u0018\f\u0014!t=4m\u00b4~\u00e8\u00cf\u000b\u000b^dm&\u0014\u009d\u00c0G\u00bf\u00e9\u00f5\t3\u00d1X}y\u008a\u00fd+P\u0005\u00c6\u00ad \u0094\u0011\b(\u00b0\u00fdF\u0088\u0019p)\u0014\u00d6Nb\u0094\u00ba\u00e5\u00aa\u00d9 \u00e5\u00a0n\u00ca\u00ae\u00b5\u001c\u00a7\u0080z\u008d\u0005\u00b7K\u000eH\u00d4\u001e\u0099\u00ae\u00de\u0090Sl\u0002\u00c56\u00d2\u008d\u00cb\u000ffF\u000e\u0083\u00e9\u00fb\u008b'\u00f9\u00e9\u00f0e\u00ddl\u00a1\u000e\u0014\u0010\u00d1\n3\u00c1\u00b9t\u00a9?>?\u0001\u008b\u0098;\u001b:\t\u00a0\u0083\u00fc&\u00be\u00c6#=e\u0010\u00bf4\u00fe\u0006\u0000\u008c\u009e \u00d8\u00dc\u00dd\u00f7\u0003\u00b4h\u00cb?\f\u00cfd\u00bc\t\u00e0\u00cc8\u009e\u00bc\u00dd\u00fd\u00baV\u00cd17k\u0010\u001e\u00d4\u0019\u00ec\u008a\u00d5zw\u00e1ZJ:\u001f\u00ae\u00e3\u00d4\u00d1\u0097'\u0081\u008c\u00e0s\u001b\u00b4\u00f4\u00b5\u0019>\u00c8\u0091\u00c1\u00eaRi\u00a84\u0002\u0081\u00e6L\u0019\u00fe\u00ad\bx\u00d4\u00f7\u00ca\u00c9\u0088X\u001b\fusF%\u00e2\u0017\u00d3\u00efXm\u009f\u00c5F\u00f0\u00a4\u00f6\u00df\u00f4H\u0011\u0004\u0000\u001c\u009e/D\u0004\r]\u00d3\u0081\u008c\u00ecU\u0015\u00df9\u0085'\u008eA\u00daw\u0010\u0084\u00d7&9H\u00f0Y\u00c6\u0087\u009b\u0007\u00ff\u00c1\u00b6\u009e\u0005&\u00acj+?\u00e0E\u00e8\u00aa\u0095&\u0082\u0004\u00a6\u009e\u0006\u00f4w\u00ccwS\u009b\u0002\u001f\u009c\u00ae~\u0090Gl\u0080\u00c5f\u00d2\u0087\u00cbN{e\u001c\u009cCe\u0014?\u008a=5\u009e\u00b5\u0004`\u001e\u00dd\u008a\u000b\u0081L\u00d8\u00c21\u00eb\u00a9p\u0017\u0092|\u00156;./\u00e8>~\u00b7\u00d3\u008a,\u000b\u0085\u00cf\u0001\u00dc\u00eb\u00cfV\u00fco)wx\u0003J\u00e87u\u00ae\u00d8\u00bfPf\u00b0\u00c4$\u00ee\u00eb\u0095Pii]1\u00d7p\u00a0\u000e\u00bapr\u00c5\u001a\u0093P\u00d7\u000b3,5\u0080F\u0007i{\u00ca0\u00f5%M\u0007\u00fa\u0012\u00dcq\u00d0\u00e2\u00ff(\u00c3\u0099\u00d9W\u0003\u00fe\u00fe\u00b0\u00d9\u00abZ\u00d2\u00d2\u00d3*\u008f-\u0014&\u001a\u00c6\r\u00ab\u0016\u00b3$\u00c0Q\u009eo\u00c3\u00a0\u00a8l.!\u00b6\u0014\u0016t\u000f\u0082\t\u00bfl'\u00f5\u00df\u0012\u0088r\u00d1\u00b8\u0003\u00ca\u008e\"DpeK$\u0017\u00ec\u00aa\u00eb?6v\u007f\u00ca\u00b9\u00e1\u00b3]\u00d12\u00b36\u00ca\u00ea\u009cS^\u001a^T\u00a2\u00d9Q\u00db\u000e\u0011\u0088\u00cd\\i\u00f3\u0016\u00d2\u00b1j\u00f6\u00bb\u00eb\u00a0\u001b\u00ad@]@\u0080\u00c5\u00beH\u00f3\u00be3 \u0003\u00e5\u0010\u0012.\u0089\u00df4I\u00c2\u00e6\u00d2R9\u00d2\n\u0002\u0083l?\u00b2\u00ce+\u0003\u00ea\u00b5\u0018\u00e8\u00c2\u00f5\u001d\u0094\u00d2\u001d\u00f4\u0099\u00e0\u00bctK<\u00e5\b\u00e7\u00cb1\u0005\u00ec\u00af\t,)\u00f6f3\u0089\u00eeO\u00b5\u00a1\u00c0^SZ\u00d4J7D\u00f7\u00b5\f\u00a8\u00d8uN\u00de\u00ea\u0013\u00c0 \u00fa}/j\u00eb\u0080\r\u0085\u00b6\u00d9\u0085>P\t\u00f0\u008e\u00f6\u0099\u00f5\u00fe\u001ca?";
                var4_3 = "\u00be&/\u00e5\u0080Kw\u0081\u0014`\u009a\u00cc\u0095\u0002\u00cd\u0088K\njN+]\u00a5\u00fc\u0090\u009c\u00c2\u00e4\u0087\u0006\u00a95\u00cd\u0087\u00b6F\u0018\f\u0014!t=4m\u00b4~\u00e8\u00cf\u000b\u000b^dm&\u0014\u009d\u00c0G\u00bf\u00e9\u00f5\t3\u00d1X}y\u008a\u00fd+P\u0005\u00c6\u00ad \u0094\u0011\b(\u00b0\u00fdF\u0088\u0019p)\u0014\u00d6Nb\u0094\u00ba\u00e5\u00aa\u00d9 \u00e5\u00a0n\u00ca\u00ae\u00b5\u001c\u00a7\u0080z\u008d\u0005\u00b7K\u000eH\u00d4\u001e\u0099\u00ae\u00de\u0090Sl\u0002\u00c56\u00d2\u008d\u00cb\u000ffF\u000e\u0083\u00e9\u00fb\u008b'\u00f9\u00e9\u00f0e\u00ddl\u00a1\u000e\u0014\u0010\u00d1\n3\u00c1\u00b9t\u00a9?>?\u0001\u008b\u0098;\u001b:\t\u00a0\u0083\u00fc&\u00be\u00c6#=e\u0010\u00bf4\u00fe\u0006\u0000\u008c\u009e \u00d8\u00dc\u00dd\u00f7\u0003\u00b4h\u00cb?\f\u00cfd\u00bc\t\u00e0\u00cc8\u009e\u00bc\u00dd\u00fd\u00baV\u00cd17k\u0010\u001e\u00d4\u0019\u00ec\u008a\u00d5zw\u00e1ZJ:\u001f\u00ae\u00e3\u00d4\u00d1\u0097'\u0081\u008c\u00e0s\u001b\u00b4\u00f4\u00b5\u0019>\u00c8\u0091\u00c1\u00eaRi\u00a84\u0002\u0081\u00e6L\u0019\u00fe\u00ad\bx\u00d4\u00f7\u00ca\u00c9\u0088X\u001b\fusF%\u00e2\u0017\u00d3\u00efXm\u009f\u00c5F\u00f0\u00a4\u00f6\u00df\u00f4H\u0011\u0004\u0000\u001c\u009e/D\u0004\r]\u00d3\u0081\u008c\u00ecU\u0015\u00df9\u0085'\u008eA\u00daw\u0010\u0084\u00d7&9H\u00f0Y\u00c6\u0087\u009b\u0007\u00ff\u00c1\u00b6\u009e\u0005&\u00acj+?\u00e0E\u00e8\u00aa\u0095&\u0082\u0004\u00a6\u009e\u0006\u00f4w\u00ccwS\u009b\u0002\u001f\u009c\u00ae~\u0090Gl\u0080\u00c5f\u00d2\u0087\u00cbN{e\u001c\u009cCe\u0014?\u008a=5\u009e\u00b5\u0004`\u001e\u00dd\u008a\u000b\u0081L\u00d8\u00c21\u00eb\u00a9p\u0017\u0092|\u00156;./\u00e8>~\u00b7\u00d3\u008a,\u000b\u0085\u00cf\u0001\u00dc\u00eb\u00cfV\u00fco)wx\u0003J\u00e87u\u00ae\u00d8\u00bfPf\u00b0\u00c4$\u00ee\u00eb\u0095Pii]1\u00d7p\u00a0\u000e\u00bapr\u00c5\u001a\u0093P\u00d7\u000b3,5\u0080F\u0007i{\u00ca0\u00f5%M\u0007\u00fa\u0012\u00dcq\u00d0\u00e2\u00ff(\u00c3\u0099\u00d9W\u0003\u00fe\u00fe\u00b0\u00d9\u00abZ\u00d2\u00d2\u00d3*\u008f-\u0014&\u001a\u00c6\r\u00ab\u0016\u00b3$\u00c0Q\u009eo\u00c3\u00a0\u00a8l.!\u00b6\u0014\u0016t\u000f\u0082\t\u00bfl'\u00f5\u00df\u0012\u0088r\u00d1\u00b8\u0003\u00ca\u008e\"DpeK$\u0017\u00ec\u00aa\u00eb?6v\u007f\u00ca\u00b9\u00e1\u00b3]\u00d12\u00b36\u00ca\u00ea\u009cS^\u001a^T\u00a2\u00d9Q\u00db\u000e\u0011\u0088\u00cd\\i\u00f3\u0016\u00d2\u00b1j\u00f6\u00bb\u00eb\u00a0\u001b\u00ad@]@\u0080\u00c5\u00beH\u00f3\u00be3 \u0003\u00e5\u0010\u0012.\u0089\u00df4I\u00c2\u00e6\u00d2R9\u00d2\n\u0002\u0083l?\u00b2\u00ce+\u0003\u00ea\u00b5\u0018\u00e8\u00c2\u00f5\u001d\u0094\u00d2\u001d\u00f4\u0099\u00e0\u00bctK<\u00e5\b\u00e7\u00cb1\u0005\u00ec\u00af\t,)\u00f6f3\u0089\u00eeO\u00b5\u00a1\u00c0^SZ\u00d4J7D\u00f7\u00b5\f\u00a8\u00d8uN\u00de\u00ea\u0013\u00c0 \u00fa}/j\u00eb\u0080\r\u0085\u00b6\u00d9\u0085>P\t\u00f0\u008e\u00f6\u0099\u00f5\u00fe\u001ca?".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 97;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "?\u00e6P\u00c3\u00d8\\)\u0099\t\u00030\u00ab\u00e2.\u00ab\u0092>9?\u00e7\u00b1\u00f9\u00ca\u00cb\u008b\u00f7'\u00a3\u00cc\u0014R\u001f\u00d0\u007f\u00db\u00ca\u00e9\u00f1|g\u00da\u00d0\u0095\u0080\u00bfn\u00aeG\u00f8m";
                    var4_3 = "?\u00e6P\u00c3\u00d8\\)\u0099\t\u00030\u00ab\u00e2.\u00ab\u0092>9?\u00e7\u00b1\u00f9\u00ca\u00cb\u008b\u00f7'\u00a3\u00cc\u0014R\u001f\u00d0\u007f\u00db\u00ca\u00e9\u00f1|g\u00da\u00d0\u0095\u0080\u00bfn\u00aeG\u00f8m".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 49;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 78;
                            break;
                        }
                        case 1: {
                            v15 = 115;
                            break;
                        }
                        case 2: {
                            v15 = 114;
                            break;
                        }
                        case 3: {
                            v15 = 35;
                            break;
                        }
                        case 4: {
                            v15 = 72;
                            break;
                        }
                        case 5: {
                            v15 = 118;
                            break;
                        }
                        default: {
                            v15 = 13;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x68CA) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 203;
                case 1 -> 21;
                case 2 -> 158;
                case 3 -> 171;
                case 4 -> 152;
                case 5 -> 223;
                case 6 -> 163;
                case 7 -> 209;
                case 8 -> 172;
                case 9 -> 142;
                case 10 -> 5;
                case 11 -> 87;
                case 12 -> 199;
                case 13 -> 146;
                case 14 -> 229;
                case 15 -> 61;
                case 16 -> 254;
                case 17 -> 71;
                case 18 -> 176;
                case 19 -> 132;
                case 20 -> 0;
                case 21 -> 159;
                case 22 -> 95;
                case 23 -> 115;
                case 24 -> 126;
                case 25 -> 27;
                case 26 -> 134;
                case 27 -> 125;
                case 28 -> 191;
                case 29 -> 151;
                case 30 -> 36;
                case 31 -> 228;
                case 32 -> 137;
                case 33 -> 81;
                case 34 -> 185;
                case 35 -> 150;
                case 36 -> 129;
                case 37 -> 195;
                case 38 -> 7;
                case 39 -> 97;
                case 40 -> 207;
                case 41 -> 107;
                case 42 -> 31;
                case 43 -> 247;
                case 44 -> 53;
                case 45 -> 220;
                case 46 -> 48;
                case 47 -> 72;
                case 48 -> 210;
                case 49 -> 24;
                case 50 -> 11;
                case 51 -> 79;
                case 52 -> 41;
                case 53 -> 141;
                case 54 -> 154;
                case 55 -> 198;
                case 56 -> 155;
                case 57 -> 114;
                case 58 -> 124;
                case 59 -> 183;
                case 60 -> 70;
                case 61 -> 3;
                case 62 -> 234;
                case 63 -> 167;
                case 64 -> 86;
                case 65 -> 217;
                case 66 -> 246;
                case 67 -> 127;
                case 68 -> 196;
                case 69 -> 157;
                case 70 -> 243;
                case 71 -> 16;
                case 72 -> 14;
                case 73 -> 240;
                case 74 -> 33;
                case 75 -> 251;
                case 76 -> 67;
                case 77 -> 221;
                case 78 -> 17;
                case 79 -> 57;
                case 80 -> 96;
                case 81 -> 106;
                case 82 -> 241;
                case 83 -> 204;
                case 84 -> 118;
                case 85 -> 50;
                case 86 -> 56;
                case 87 -> 54;
                case 88 -> 100;
                case 89 -> 42;
                case 90 -> 250;
                case 91 -> 123;
                case 92 -> 83;
                case 93 -> 12;
                case 94 -> 197;
                case 95 -> 135;
                case 96 -> 60;
                case 97 -> 101;
                case 98 -> 215;
                case 99 -> 29;
                case 100 -> 1;
                case 101 -> 213;
                case 102 -> 109;
                case 103 -> 136;
                case 104 -> 211;
                case 105 -> 40;
                case 106 -> 214;
                case 107 -> 73;
                case 108 -> 2;
                case 109 -> 35;
                case 110 -> 13;
                case 111 -> 253;
                case 112 -> 145;
                case 113 -> 102;
                case 114 -> 175;
                case 115 -> 9;
                case 116 -> 38;
                case 117 -> 116;
                case 118 -> 156;
                case 119 -> 232;
                case 120 -> 20;
                case 121 -> 62;
                case 122 -> 252;
                case 123 -> 77;
                case 124 -> 153;
                case 125 -> 148;
                case 126 -> 59;
                case 127 -> 110;
                case 128 -> 230;
                case 129 -> 88;
                case 130 -> 193;
                case 131 -> 224;
                case 132 -> 58;
                case 133 -> 177;
                case 134 -> 89;
                case 135 -> 65;
                case 136 -> 143;
                case 137 -> 218;
                case 138 -> 194;
                case 139 -> 47;
                case 140 -> 30;
                case 141 -> 90;
                case 142 -> 55;
                case 143 -> 23;
                case 144 -> 32;
                case 145 -> 160;
                case 146 -> 28;
                case 147 -> 208;
                case 148 -> 237;
                case 149 -> 84;
                case 150 -> 169;
                case 151 -> 226;
                case 152 -> 6;
                case 153 -> 186;
                case 154 -> 189;
                case 155 -> 63;
                case 156 -> 245;
                case 157 -> 93;
                case 158 -> 212;
                case 159 -> 200;
                case 160 -> 238;
                case 161 -> 99;
                case 162 -> 144;
                case 163 -> 122;
                case 164 -> 94;
                case 165 -> 166;
                case 166 -> 82;
                case 167 -> 180;
                case 168 -> 244;
                case 169 -> 165;
                case 170 -> 231;
                case 171 -> 168;
                case 172 -> 239;
                case 173 -> 188;
                case 174 -> 216;
                case 175 -> 34;
                case 176 -> 78;
                case 177 -> 149;
                case 178 -> 161;
                case 179 -> 98;
                case 180 -> 184;
                case 181 -> 192;
                case 182 -> 233;
                case 183 -> 39;
                case 184 -> 112;
                case 185 -> 133;
                case 186 -> 117;
                case 187 -> 170;
                case 188 -> 174;
                case 189 -> 121;
                case 190 -> 147;
                case 191 -> 201;
                case 192 -> 236;
                case 193 -> 255;
                case 194 -> 104;
                case 195 -> 44;
                case 196 -> 205;
                case 197 -> 242;
                case 198 -> 4;
                case 199 -> 66;
                case 200 -> 8;
                case 201 -> 80;
                case 202 -> 227;
                case 203 -> 120;
                case 204 -> 173;
                case 205 -> 164;
                case 206 -> 92;
                case 207 -> 249;
                case 208 -> 52;
                case 209 -> 138;
                case 210 -> 69;
                case 211 -> 162;
                case 212 -> 130;
                case 213 -> 103;
                case 214 -> 51;
                case 215 -> 26;
                case 216 -> 68;
                case 217 -> 119;
                case 218 -> 108;
                case 219 -> 111;
                case 220 -> 187;
                case 221 -> 113;
                case 222 -> 75;
                case 223 -> 139;
                case 224 -> 235;
                case 225 -> 74;
                case 226 -> 76;
                case 227 -> 190;
                case 228 -> 179;
                case 229 -> 45;
                case 230 -> 19;
                case 231 -> 25;
                case 232 -> 131;
                case 233 -> 49;
                case 234 -> 64;
                case 235 -> 85;
                case 236 -> 182;
                case 237 -> 105;
                case 238 -> 43;
                case 239 -> 140;
                case 240 -> 248;
                case 241 -> 22;
                case 242 -> 128;
                case 243 -> 178;
                case 244 -> 91;
                case 245 -> 219;
                case 246 -> 202;
                case 247 -> 225;
                case 248 -> 15;
                case 249 -> 10;
                case 250 -> 206;
                case 251 -> 222;
                case 252 -> 18;
                case 253 -> 46;
                case 254 -> 181;
                default -> 37;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 40389063970955L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(808439760 + 27631, 808439760 + (char)-31813, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int n2;
                        block4: {
                            l2 = 90050433257317L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            n2 = SshAgentIpcService.N();
                            try {
                                hANDLE2 = hANDLE;
                                if (n2 == 0) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (n2 == 0) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(2146009110 + 9274, 2146009110 + 31433, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(2146009110 + 9277, 2146009110 + 8903, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(2146009110 + 9276, 2146009110 + 3630, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "fH\u009e\u001fO\u00186W\u0010E\u00e0\u000b\u00abG5\u00ce\u00ab\u008b\u0007\u0080u\u00a4\\ \u008f";
                    var4_3 = "fH\u009e\u001fO\u00186W\u0010E\u00e0\u000b\u00abG5\u00ce\u00ab\u008b\u0007\u0080u\u00a4\\ \u008f".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 66;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0015C.\u00a0\u00f75\u00f3s\u00e5\u00ca\\\u00fek\u00a7\u0096\u00e3o\u00f7p8aW\u00c8\u0087_\u00c0G%\u00b5-v\u0006\u00ce\"\u009f\u0085'H\u00d6g\u00b9bx\u000f\u00d1\u00c5\u0088\u0013\u00e3\u00d7\u00ca\u00db\u000b\u00b3X\u00b4G\u001f.";
                        var4_3 = "\u0015C.\u00a0\u00f75\u00f3s\u00e5\u00ca\\\u00fek\u00a7\u0096\u00e3o\u00f7p8aW\u00c8\u0087_\u00c0G%\u00b5-v\u0006\u00ce\"\u009f\u0085'H\u00d6g\u00b9bx\u000f\u00d1\u00c5\u0088\u0013\u00e3\u00d7\u00ca\u00db\u000b\u00b3X\u00b4G\u001f.".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 22;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 17;
                                break;
                            }
                            case 1: {
                                v15 = 107;
                                break;
                            }
                            case 2: {
                                v15 = 116;
                                break;
                            }
                            case 3: {
                                v15 = 80;
                                break;
                            }
                            case 4: {
                                v15 = 54;
                                break;
                            }
                            case 5: {
                                v15 = 83;
                                break;
                            }
                            default: {
                                v15 = 61;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFAB34) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 35;
                    case 1 -> 102;
                    case 2 -> 68;
                    case 3 -> 49;
                    case 4 -> 71;
                    case 5 -> 104;
                    case 6 -> 152;
                    case 7 -> 21;
                    case 8 -> 28;
                    case 9 -> 96;
                    case 10 -> 48;
                    case 11 -> 185;
                    case 12 -> 110;
                    case 13 -> 144;
                    case 14 -> 212;
                    case 15 -> 221;
                    case 16 -> 231;
                    case 17 -> 145;
                    case 18 -> 86;
                    case 19 -> 63;
                    case 20 -> 109;
                    case 21 -> 87;
                    case 22 -> 73;
                    case 23 -> 75;
                    case 24 -> 183;
                    case 25 -> 247;
                    case 26 -> 115;
                    case 27 -> 201;
                    case 28 -> 92;
                    case 29 -> 172;
                    case 30 -> 37;
                    case 31 -> 79;
                    case 32 -> 225;
                    case 33 -> 23;
                    case 34 -> 25;
                    case 35 -> 64;
                    case 36 -> 197;
                    case 37 -> 22;
                    case 38 -> 11;
                    case 39 -> 204;
                    case 40 -> 166;
                    case 41 -> 120;
                    case 42 -> 20;
                    case 43 -> 177;
                    case 44 -> 16;
                    case 45 -> 67;
                    case 46 -> 245;
                    case 47 -> 168;
                    case 48 -> 72;
                    case 49 -> 200;
                    case 50 -> 140;
                    case 51 -> 27;
                    case 52 -> 65;
                    case 53 -> 187;
                    case 54 -> 132;
                    case 55 -> 56;
                    case 56 -> 88;
                    case 57 -> 52;
                    case 58 -> 227;
                    case 59 -> 242;
                    case 60 -> 60;
                    case 61 -> 174;
                    case 62 -> 237;
                    case 63 -> 114;
                    case 64 -> 61;
                    case 65 -> 150;
                    case 66 -> 45;
                    case 67 -> 2;
                    case 68 -> 47;
                    case 69 -> 84;
                    case 70 -> 178;
                    case 71 -> 194;
                    case 72 -> 186;
                    case 73 -> 146;
                    case 74 -> 127;
                    case 75 -> 162;
                    case 76 -> 90;
                    case 77 -> 224;
                    case 78 -> 157;
                    case 79 -> 226;
                    case 80 -> 135;
                    case 81 -> 0;
                    case 82 -> 8;
                    case 83 -> 255;
                    case 84 -> 128;
                    case 85 -> 101;
                    case 86 -> 12;
                    case 87 -> 233;
                    case 88 -> 155;
                    case 89 -> 184;
                    case 90 -> 43;
                    case 91 -> 203;
                    case 92 -> 206;
                    case 93 -> 222;
                    case 94 -> 82;
                    case 95 -> 93;
                    case 96 -> 252;
                    case 97 -> 31;
                    case 98 -> 125;
                    case 99 -> 236;
                    case 100 -> 122;
                    case 101 -> 131;
                    case 102 -> 108;
                    case 103 -> 141;
                    case 104 -> 34;
                    case 105 -> 100;
                    case 106 -> 191;
                    case 107 -> 202;
                    case 108 -> 241;
                    case 109 -> 228;
                    case 110 -> 19;
                    case 111 -> 153;
                    case 112 -> 126;
                    case 113 -> 198;
                    case 114 -> 220;
                    case 115 -> 57;
                    case 116 -> 1;
                    case 117 -> 42;
                    case 118 -> 106;
                    case 119 -> 173;
                    case 120 -> 210;
                    case 121 -> 165;
                    case 122 -> 13;
                    case 123 -> 80;
                    case 124 -> 107;
                    case 125 -> 234;
                    case 126 -> 74;
                    case 127 -> 190;
                    case 128 -> 105;
                    case 129 -> 112;
                    case 130 -> 32;
                    case 131 -> 176;
                    case 132 -> 103;
                    case 133 -> 50;
                    case 134 -> 189;
                    case 135 -> 246;
                    case 136 -> 66;
                    case 137 -> 175;
                    case 138 -> 151;
                    case 139 -> 59;
                    case 140 -> 81;
                    case 141 -> 44;
                    case 142 -> 251;
                    case 143 -> 138;
                    case 144 -> 116;
                    case 145 -> 111;
                    case 146 -> 121;
                    case 147 -> 40;
                    case 148 -> 230;
                    case 149 -> 38;
                    case 150 -> 6;
                    case 151 -> 214;
                    case 152 -> 219;
                    case 153 -> 99;
                    case 154 -> 33;
                    case 155 -> 134;
                    case 156 -> 253;
                    case 157 -> 29;
                    case 158 -> 147;
                    case 159 -> 54;
                    case 160 -> 91;
                    case 161 -> 46;
                    case 162 -> 211;
                    case 163 -> 119;
                    case 164 -> 213;
                    case 165 -> 53;
                    case 166 -> 24;
                    case 167 -> 188;
                    case 168 -> 182;
                    case 169 -> 149;
                    case 170 -> 254;
                    case 171 -> 179;
                    case 172 -> 77;
                    case 173 -> 238;
                    case 174 -> 10;
                    case 175 -> 159;
                    case 176 -> 239;
                    case 177 -> 208;
                    case 178 -> 167;
                    case 179 -> 98;
                    case 180 -> 51;
                    case 181 -> 158;
                    case 182 -> 89;
                    case 183 -> 136;
                    case 184 -> 195;
                    case 185 -> 118;
                    case 186 -> 216;
                    case 187 -> 156;
                    case 188 -> 36;
                    case 189 -> 117;
                    case 190 -> 180;
                    case 191 -> 123;
                    case 192 -> 17;
                    case 193 -> 218;
                    case 194 -> 199;
                    case 195 -> 130;
                    case 196 -> 70;
                    case 197 -> 154;
                    case 198 -> 240;
                    case 199 -> 209;
                    case 200 -> 58;
                    case 201 -> 97;
                    case 202 -> 235;
                    case 203 -> 181;
                    case 204 -> 3;
                    case 205 -> 232;
                    case 206 -> 148;
                    case 207 -> 14;
                    case 208 -> 9;
                    case 209 -> 85;
                    case 210 -> 113;
                    case 211 -> 215;
                    case 212 -> 94;
                    case 213 -> 205;
                    case 214 -> 76;
                    case 215 -> 41;
                    case 216 -> 124;
                    case 217 -> 133;
                    case 218 -> 217;
                    case 219 -> 4;
                    case 220 -> 229;
                    case 221 -> 62;
                    case 222 -> 5;
                    case 223 -> 160;
                    case 224 -> 78;
                    case 225 -> 143;
                    case 226 -> 30;
                    case 227 -> 243;
                    case 228 -> 69;
                    case 229 -> 249;
                    case 230 -> 244;
                    case 231 -> 137;
                    case 232 -> 26;
                    case 233 -> 250;
                    case 234 -> 193;
                    case 235 -> 169;
                    case 236 -> 55;
                    case 237 -> 170;
                    case 238 -> 18;
                    case 239 -> 196;
                    case 240 -> 39;
                    case 241 -> 163;
                    case 242 -> 129;
                    case 243 -> 7;
                    case 244 -> 83;
                    case 245 -> 248;
                    case 246 -> 223;
                    case 247 -> 171;
                    case 248 -> 139;
                    case 249 -> 192;
                    case 250 -> 95;
                    case 251 -> 15;
                    case 252 -> 142;
                    case 253 -> 164;
                    case 254 -> 207;
                    default -> 161;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 133237969847928L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "\u0014Ek;lO\fM\t\u0013Ox1!\r\u0011Q\t";
                    var5_4 = "\u0014Ek;lO\fM\t\u0013Ox1!\r\u0011Q\t".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 124;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 3;
                                    break;
                                }
                                case 1: {
                                    v11 = 92;
                                    break;
                                }
                                case 2: {
                                    v11 = 101;
                                    break;
                                }
                                case 3: {
                                    v11 = 41;
                                    break;
                                }
                                case 4: {
                                    v11 = 117;
                                    break;
                                }
                                case 5: {
                                    v11 = 95;
                                    break;
                                }
                                default: {
                                    v11 = 67;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 15988582575064L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "f\n\u001e@\u0000c>\u0004`\u0014\u0012Z\nl\u000b\u0019Z\fa&F\n\u0010\tl\u000b\u0019Z\fa&J\u0000\rk\r\u0004W\u0006l<J\u0007\u0003]\u0007e";
                    var5_4 = "f\n\u001e@\u0000c>\u0004`\u0014\u0012Z\nl\u000b\u0019Z\fa&F\n\u0010\tl\u000b\u0019Z\fa&J\u0000\rk\r\u0004W\u0006l<J\u0007\u0003]\u0007e".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 71;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "m\t\u0019F\u0001m4\u0006m\t\u0019F\rg";
                        var5_4 = "m\t\u0019F\u0001m4\u0006m\t\u0019F\rg".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 70;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 104;
                                break;
                            }
                            case 1: {
                                v15 = 35;
                                break;
                            }
                            case 2: {
                                v15 = 48;
                                break;
                            }
                            case 3: {
                                v15 = 115;
                                break;
                            }
                            case 4: {
                                v15 = 46;
                                break;
                            }
                            case 5: {
                                v15 = 69;
                                break;
                            }
                            default: {
                                v15 = 21;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 31320432434643L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1530897600 + 17440, -1530897600 + -9248, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 120644789179878L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00cc\u0088n\u0015\u00d1\u0003\u00c5\u0011\u00fb\u0005Wy;\u00ef\u0098\r\u0089a\u00d6\u00a6\u00d0\u00c6\u00ed8}rk\u0085\u00f8\u0010\u00cb/Y\u0084\u001e\u0017\u001f?\u00ea\u0016zD<\u0080\u00e3O\u0005\u00c5\u00ddi{\u00d23\u00c9<\u00f90\u00df\u00c5\u0017q\u0096\"~\u00ebz$\u0007\u00c4i\u00e6\u00d1\u00f5\u0015\u008b\u001c-\u0080T\u00e0\u001a\u00ea\u00b3\u00eb\u00dbC\u00aa\u00cf\u00be\u00c9\u008b_\u0092\u00dd\u0087V\u00f2P\u0005\u00fb[\u00eb\u0097D";
                    var4_3 = "\u00cc\u0088n\u0015\u00d1\u0003\u00c5\u0011\u00fb\u0005Wy;\u00ef\u0098\r\u0089a\u00d6\u00a6\u00d0\u00c6\u00ed8}rk\u0085\u00f8\u0010\u00cb/Y\u0084\u001e\u0017\u001f?\u00ea\u0016zD<\u0080\u00e3O\u0005\u00c5\u00ddi{\u00d23\u00c9<\u00f90\u00df\u00c5\u0017q\u0096\"~\u00ebz$\u0007\u00c4i\u00e6\u00d1\u00f5\u0015\u008b\u001c-\u0080T\u00e0\u001a\u00ea\u00b3\u00eb\u00dbC\u00aa\u00cf\u00be\u00c9\u008b_\u0092\u00dd\u0087V\u00f2P\u0005\u00fb[\u00eb\u0097D".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 118;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "7\u000f$bS)T\u001aaP\u00e9n\u00ac'\u0013YL!\u00ba\u0011\u001e\u00dfn\u00ab\u009c\u0017\u0013\u008b\u00bf\u00ee\u0093\u00c8\u00b6w\u009b\u000fNDz\u00feS\u001d\u0092\u0094\u00e6|\u00874\u00d0J\u00c7}\u00edO\u00ddW\u00dc\bQ\u00c1\u00b7U\u0091r\u0013\u00caHj\u00ab\u000b\u0090UY7\u0018DEq\u008e\u00a8\r78\u0086\u00a4%\u000b\u00e7u}\u00dcC1";
                        var4_3 = "7\u000f$bS)T\u001aaP\u00e9n\u00ac'\u0013YL!\u00ba\u0011\u001e\u00dfn\u00ab\u009c\u0017\u0013\u008b\u00bf\u00ee\u0093\u00c8\u00b6w\u009b\u000fNDz\u00feS\u001d\u0092\u0094\u00e6|\u00874\u00d0J\u00c7}\u00edO\u00ddW\u00dc\bQ\u00c1\u00b7U\u0091r\u0013\u00caHj\u00ab\u000b\u0090UY7\u0018DEq\u008e\u00a8\r78\u0086\u00a4%\u000b\u00e7u}\u00dcC1".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 80;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 120;
                                break;
                            }
                            case 1: {
                                v15 = 3;
                                break;
                            }
                            case 2: {
                                v15 = 104;
                                break;
                            }
                            case 3: {
                                v15 = 57;
                                break;
                            }
                            case 4: {
                                v15 = 20;
                                break;
                            }
                            case 5: {
                                v15 = 11;
                                break;
                            }
                            default: {
                                v15 = 49;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x3533) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 100;
                    case 1 -> 233;
                    case 2 -> 89;
                    case 3 -> 223;
                    case 4 -> 125;
                    case 5 -> 130;
                    case 6 -> 237;
                    case 7 -> 195;
                    case 8 -> 95;
                    case 9 -> 197;
                    case 10 -> 6;
                    case 11 -> 58;
                    case 12 -> 229;
                    case 13 -> 0;
                    case 14 -> 186;
                    case 15 -> 151;
                    case 16 -> 234;
                    case 17 -> 74;
                    case 18 -> 57;
                    case 19 -> 126;
                    case 20 -> 5;
                    case 21 -> 34;
                    case 22 -> 241;
                    case 23 -> 27;
                    case 24 -> 252;
                    case 25 -> 191;
                    case 26 -> 240;
                    case 27 -> 78;
                    case 28 -> 46;
                    case 29 -> 81;
                    case 30 -> 90;
                    case 31 -> 245;
                    case 32 -> 36;
                    case 33 -> 221;
                    case 34 -> 204;
                    case 35 -> 247;
                    case 36 -> 164;
                    case 37 -> 161;
                    case 38 -> 20;
                    case 39 -> 120;
                    case 40 -> 77;
                    case 41 -> 250;
                    case 42 -> 178;
                    case 43 -> 242;
                    case 44 -> 180;
                    case 45 -> 56;
                    case 46 -> 66;
                    case 47 -> 93;
                    case 48 -> 238;
                    case 49 -> 10;
                    case 50 -> 127;
                    case 51 -> 28;
                    case 52 -> 113;
                    case 53 -> 42;
                    case 54 -> 143;
                    case 55 -> 144;
                    case 56 -> 64;
                    case 57 -> 21;
                    case 58 -> 35;
                    case 59 -> 170;
                    case 60 -> 152;
                    case 61 -> 171;
                    case 62 -> 1;
                    case 63 -> 63;
                    case 64 -> 236;
                    case 65 -> 25;
                    case 66 -> 251;
                    case 67 -> 76;
                    case 68 -> 102;
                    case 69 -> 167;
                    case 70 -> 198;
                    case 71 -> 184;
                    case 72 -> 162;
                    case 73 -> 138;
                    case 74 -> 103;
                    case 75 -> 73;
                    case 76 -> 37;
                    case 77 -> 129;
                    case 78 -> 112;
                    case 79 -> 51;
                    case 80 -> 61;
                    case 81 -> 55;
                    case 82 -> 123;
                    case 83 -> 96;
                    case 84 -> 14;
                    case 85 -> 2;
                    case 86 -> 85;
                    case 87 -> 183;
                    case 88 -> 3;
                    case 89 -> 249;
                    case 90 -> 124;
                    case 91 -> 111;
                    case 92 -> 141;
                    case 93 -> 72;
                    case 94 -> 117;
                    case 95 -> 226;
                    case 96 -> 43;
                    case 97 -> 142;
                    case 98 -> 190;
                    case 99 -> 119;
                    case 100 -> 168;
                    case 101 -> 48;
                    case 102 -> 23;
                    case 103 -> 175;
                    case 104 -> 177;
                    case 105 -> 211;
                    case 106 -> 255;
                    case 107 -> 71;
                    case 108 -> 115;
                    case 109 -> 69;
                    case 110 -> 157;
                    case 111 -> 253;
                    case 112 -> 201;
                    case 113 -> 203;
                    case 114 -> 248;
                    case 115 -> 140;
                    case 116 -> 189;
                    case 117 -> 187;
                    case 118 -> 205;
                    case 119 -> 17;
                    case 120 -> 200;
                    case 121 -> 136;
                    case 122 -> 181;
                    case 123 -> 134;
                    case 124 -> 147;
                    case 125 -> 173;
                    case 126 -> 220;
                    case 127 -> 154;
                    case 128 -> 213;
                    case 129 -> 231;
                    case 130 -> 32;
                    case 131 -> 172;
                    case 132 -> 199;
                    case 133 -> 227;
                    case 134 -> 60;
                    case 135 -> 212;
                    case 136 -> 29;
                    case 137 -> 139;
                    case 138 -> 31;
                    case 139 -> 83;
                    case 140 -> 12;
                    case 141 -> 62;
                    case 142 -> 114;
                    case 143 -> 179;
                    case 144 -> 202;
                    case 145 -> 192;
                    case 146 -> 228;
                    case 147 -> 254;
                    case 148 -> 98;
                    case 149 -> 215;
                    case 150 -> 216;
                    case 151 -> 24;
                    case 152 -> 217;
                    case 153 -> 86;
                    case 154 -> 4;
                    case 155 -> 84;
                    case 156 -> 148;
                    case 157 -> 166;
                    case 158 -> 160;
                    case 159 -> 87;
                    case 160 -> 54;
                    case 161 -> 133;
                    case 162 -> 30;
                    case 163 -> 128;
                    case 164 -> 53;
                    case 165 -> 110;
                    case 166 -> 244;
                    case 167 -> 156;
                    case 168 -> 118;
                    case 169 -> 105;
                    case 170 -> 165;
                    case 171 -> 38;
                    case 172 -> 33;
                    case 173 -> 88;
                    case 174 -> 158;
                    case 175 -> 230;
                    case 176 -> 210;
                    case 177 -> 13;
                    case 178 -> 155;
                    case 179 -> 49;
                    case 180 -> 176;
                    case 181 -> 97;
                    case 182 -> 26;
                    case 183 -> 218;
                    case 184 -> 16;
                    case 185 -> 131;
                    case 186 -> 246;
                    case 187 -> 116;
                    case 188 -> 59;
                    case 189 -> 188;
                    case 190 -> 222;
                    case 191 -> 193;
                    case 192 -> 52;
                    case 193 -> 68;
                    case 194 -> 80;
                    case 195 -> 94;
                    case 196 -> 108;
                    case 197 -> 11;
                    case 198 -> 22;
                    case 199 -> 149;
                    case 200 -> 169;
                    case 201 -> 235;
                    case 202 -> 99;
                    case 203 -> 159;
                    case 204 -> 107;
                    case 205 -> 15;
                    case 206 -> 224;
                    case 207 -> 174;
                    case 208 -> 92;
                    case 209 -> 194;
                    case 210 -> 79;
                    case 211 -> 153;
                    case 212 -> 101;
                    case 213 -> 206;
                    case 214 -> 121;
                    case 215 -> 132;
                    case 216 -> 75;
                    case 217 -> 67;
                    case 218 -> 163;
                    case 219 -> 44;
                    case 220 -> 47;
                    case 221 -> 137;
                    case 222 -> 70;
                    case 223 -> 18;
                    case 224 -> 40;
                    case 225 -> 109;
                    case 226 -> 82;
                    case 227 -> 219;
                    case 228 -> 150;
                    case 229 -> 145;
                    case 230 -> 50;
                    case 231 -> 41;
                    case 232 -> 243;
                    case 233 -> 19;
                    case 234 -> 239;
                    case 235 -> 9;
                    case 236 -> 65;
                    case 237 -> 106;
                    case 238 -> 7;
                    case 239 -> 146;
                    case 240 -> 91;
                    case 241 -> 196;
                    case 242 -> 45;
                    case 243 -> 182;
                    case 244 -> 104;
                    case 245 -> 39;
                    case 246 -> 185;
                    case 247 -> 135;
                    case 248 -> 122;
                    case 249 -> 225;
                    case 250 -> 208;
                    case 251 -> 232;
                    case 252 -> 214;
                    case 253 -> 209;
                    case 254 -> 207;
                    default -> 8;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 109787586959642L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(366996000 + (char)-22929, -366996000 + -((char)-12513), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 107436861059787L;
                    int n3 = SshAgentIpcService.N();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1745852400 + 25455, -1745852400 + -6023, (int)l2));
                    int n4 = n3;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (n4 == 0) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 64310555524246L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\\\u00de1\u00ff)\u00038\u0019\u00eb";
                var4_3 = "\\\u00de1\u00ff)\u00038\u0019\u00eb".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 48;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 5;
                                break;
                            }
                            case 1: {
                                v11 = 5;
                                break;
                            }
                            case 2: {
                                v11 = 4;
                                break;
                            }
                            case 3: {
                                v11 = 87;
                                break;
                            }
                            case 4: {
                                v11 = 4;
                                break;
                            }
                            case 5: {
                                v11 = 67;
                                break;
                            }
                            default: {
                                v11 = 19;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFF8995) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 67;
                    case 1 -> 72;
                    case 2 -> 86;
                    case 3 -> 183;
                    case 4 -> 4;
                    case 5 -> 220;
                    case 6 -> 58;
                    case 7 -> 228;
                    case 8 -> 206;
                    case 9 -> 80;
                    case 10 -> 6;
                    case 11 -> 180;
                    case 12 -> 1;
                    case 13 -> 196;
                    case 14 -> 135;
                    case 15 -> 202;
                    case 16 -> 143;
                    case 17 -> 237;
                    case 18 -> 50;
                    case 19 -> 141;
                    case 20 -> 8;
                    case 21 -> 96;
                    case 22 -> 184;
                    case 23 -> 222;
                    case 24 -> 95;
                    case 25 -> 161;
                    case 26 -> 176;
                    case 27 -> 87;
                    case 28 -> 89;
                    case 29 -> 117;
                    case 30 -> 139;
                    case 31 -> 103;
                    case 32 -> 122;
                    case 33 -> 93;
                    case 34 -> 53;
                    case 35 -> 81;
                    case 36 -> 136;
                    case 37 -> 232;
                    case 38 -> 120;
                    case 39 -> 172;
                    case 40 -> 192;
                    case 41 -> 112;
                    case 42 -> 126;
                    case 43 -> 113;
                    case 44 -> 227;
                    case 45 -> 22;
                    case 46 -> 84;
                    case 47 -> 33;
                    case 48 -> 36;
                    case 49 -> 244;
                    case 50 -> 200;
                    case 51 -> 148;
                    case 52 -> 124;
                    case 53 -> 19;
                    case 54 -> 234;
                    case 55 -> 101;
                    case 56 -> 138;
                    case 57 -> 201;
                    case 58 -> 48;
                    case 59 -> 221;
                    case 60 -> 158;
                    case 61 -> 166;
                    case 62 -> 60;
                    case 63 -> 160;
                    case 64 -> 129;
                    case 65 -> 104;
                    case 66 -> 169;
                    case 67 -> 61;
                    case 68 -> 182;
                    case 69 -> 204;
                    case 70 -> 164;
                    case 71 -> 177;
                    case 72 -> 64;
                    case 73 -> 24;
                    case 74 -> 109;
                    case 75 -> 0;
                    case 76 -> 78;
                    case 77 -> 251;
                    case 78 -> 194;
                    case 79 -> 173;
                    case 80 -> 167;
                    case 81 -> 30;
                    case 82 -> 34;
                    case 83 -> 91;
                    case 84 -> 210;
                    case 85 -> 199;
                    case 86 -> 134;
                    case 87 -> 162;
                    case 88 -> 225;
                    case 89 -> 73;
                    case 90 -> 174;
                    case 91 -> 74;
                    case 92 -> 105;
                    case 93 -> 188;
                    case 94 -> 108;
                    case 95 -> 216;
                    case 96 -> 208;
                    case 97 -> 28;
                    case 98 -> 15;
                    case 99 -> 18;
                    case 100 -> 198;
                    case 101 -> 159;
                    case 102 -> 163;
                    case 103 -> 151;
                    case 104 -> 16;
                    case 105 -> 211;
                    case 106 -> 157;
                    case 107 -> 5;
                    case 108 -> 231;
                    case 109 -> 68;
                    case 110 -> 248;
                    case 111 -> 150;
                    case 112 -> 82;
                    case 113 -> 75;
                    case 114 -> 21;
                    case 115 -> 79;
                    case 116 -> 23;
                    case 117 -> 142;
                    case 118 -> 13;
                    case 119 -> 76;
                    case 120 -> 71;
                    case 121 -> 189;
                    case 122 -> 253;
                    case 123 -> 149;
                    case 124 -> 241;
                    case 125 -> 9;
                    case 126 -> 193;
                    case 127 -> 14;
                    case 128 -> 12;
                    case 129 -> 130;
                    case 130 -> 190;
                    case 131 -> 140;
                    case 132 -> 145;
                    case 133 -> 175;
                    case 134 -> 246;
                    case 135 -> 94;
                    case 136 -> 65;
                    case 137 -> 123;
                    case 138 -> 121;
                    case 139 -> 17;
                    case 140 -> 43;
                    case 141 -> 205;
                    case 142 -> 32;
                    case 143 -> 203;
                    case 144 -> 37;
                    case 145 -> 25;
                    case 146 -> 62;
                    case 147 -> 254;
                    case 148 -> 116;
                    case 149 -> 168;
                    case 150 -> 207;
                    case 151 -> 186;
                    case 152 -> 252;
                    case 153 -> 209;
                    case 154 -> 131;
                    case 155 -> 133;
                    case 156 -> 250;
                    case 157 -> 213;
                    case 158 -> 218;
                    case 159 -> 197;
                    case 160 -> 7;
                    case 161 -> 38;
                    case 162 -> 239;
                    case 163 -> 40;
                    case 164 -> 20;
                    case 165 -> 226;
                    case 166 -> 229;
                    case 167 -> 245;
                    case 168 -> 214;
                    case 169 -> 154;
                    case 170 -> 111;
                    case 171 -> 156;
                    case 172 -> 127;
                    case 173 -> 83;
                    case 174 -> 144;
                    case 175 -> 215;
                    case 176 -> 52;
                    case 177 -> 147;
                    case 178 -> 85;
                    case 179 -> 69;
                    case 180 -> 255;
                    case 181 -> 55;
                    case 182 -> 235;
                    case 183 -> 125;
                    case 184 -> 217;
                    case 185 -> 59;
                    case 186 -> 54;
                    case 187 -> 107;
                    case 188 -> 90;
                    case 189 -> 146;
                    case 190 -> 106;
                    case 191 -> 178;
                    case 192 -> 45;
                    case 193 -> 41;
                    case 194 -> 247;
                    case 195 -> 31;
                    case 196 -> 42;
                    case 197 -> 88;
                    case 198 -> 155;
                    case 199 -> 39;
                    case 200 -> 98;
                    case 201 -> 26;
                    case 202 -> 56;
                    case 203 -> 44;
                    case 204 -> 171;
                    case 205 -> 212;
                    case 206 -> 238;
                    case 207 -> 114;
                    case 208 -> 132;
                    case 209 -> 99;
                    case 210 -> 66;
                    case 211 -> 170;
                    case 212 -> 3;
                    case 213 -> 137;
                    case 214 -> 77;
                    case 215 -> 92;
                    case 216 -> 242;
                    case 217 -> 230;
                    case 218 -> 102;
                    case 219 -> 35;
                    case 220 -> 46;
                    case 221 -> 187;
                    case 222 -> 29;
                    case 223 -> 118;
                    case 224 -> 185;
                    case 225 -> 219;
                    case 226 -> 236;
                    case 227 -> 57;
                    case 228 -> 223;
                    case 229 -> 49;
                    case 230 -> 152;
                    case 231 -> 70;
                    case 232 -> 233;
                    case 233 -> 224;
                    case 234 -> 97;
                    case 235 -> 47;
                    case 236 -> 110;
                    case 237 -> 128;
                    case 238 -> 2;
                    case 239 -> 249;
                    case 240 -> 243;
                    case 241 -> 191;
                    case 242 -> 181;
                    case 243 -> 10;
                    case 244 -> 195;
                    case 245 -> 165;
                    case 246 -> 51;
                    case 247 -> 63;
                    case 248 -> 27;
                    case 249 -> 153;
                    case 250 -> 11;
                    case 251 -> 240;
                    case 252 -> 115;
                    case 253 -> 100;
                    case 254 -> 119;
                    default -> 179;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

