/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.psi.util;

import com.intellij.openapi.util.TextRange;
import com.intellij.protobuf.lang.descriptor.Descriptor;
import com.intellij.protobuf.lang.psi.PbDefinition;
import com.intellij.protobuf.lang.psi.PbElement;
import com.intellij.protobuf.lang.psi.PbEnumDefinition;
import com.intellij.protobuf.lang.psi.PbExtendDefinition;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbGroupDefinition;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbNamedTypeElement;
import com.intellij.protobuf.lang.psi.PbOneofDefinition;
import com.intellij.protobuf.lang.psi.PbOptionExpression;
import com.intellij.protobuf.lang.psi.PbOptionName;
import com.intellij.protobuf.lang.psi.PbOptionOwner;
import com.intellij.protobuf.lang.psi.PbPackageName;
import com.intellij.protobuf.lang.psi.PbStatement;
import com.intellij.protobuf.lang.psi.PbSymbolOwner;
import com.intellij.protobuf.lang.psi.PbTypeName;
import com.intellij.protobuf.lang.psi.ProtoBooleanValue;
import com.intellij.protobuf.lang.psi.ProtoTokenTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PbPsiUtil {
    public static final QualifiedName EMPTY_QUALIFIED_NAME = QualifiedName.fromComponents((String[])new String[0]);

    public static boolean isStatement(PsiElement element) {
        return element instanceof PbStatement;
    }

    public static boolean isDefinition(PsiElement element) {
        return element instanceof PbDefinition;
    }

    public static boolean isTypeElement(PsiElement element) {
        return element instanceof PbNamedTypeElement;
    }

    public static boolean isMessageElement(PsiElement element) {
        return element instanceof PbMessageType;
    }

    private static boolean isGroupElement(PsiElement element) {
        return element instanceof PbGroupDefinition;
    }

    public static boolean isPackageElement(PsiElement element) {
        return element instanceof PbPackageName;
    }

    public static boolean isExtendElement(PsiElement element) {
        return element instanceof PbExtendDefinition;
    }

    public static boolean isEnumElement(PsiElement element) {
        return element instanceof PbEnumDefinition;
    }

    public static boolean isOneofElement(PsiElement element) {
        return element instanceof PbOneofDefinition;
    }

    @Nullable
    public static PbOptionExpression getDescriptorOption(PbOptionOwner owner, String name) {
        Descriptor descriptor = Descriptor.locate(owner.getPbFile());
        if (descriptor == null) {
            return null;
        }
        QualifiedName fqn = owner.getDescriptorOptionsTypeName(descriptor).append(name);
        for (PbOptionExpression option : owner.getOptions()) {
            PbField optionField = PbPsiUtil.resolveRefToType(option.getOptionName().getEffectiveReference(), PbField.class);
            if (optionField == null || !fqn.equals((Object)optionField.getQualifiedName())) continue;
            return option;
        }
        return null;
    }

    @Nullable
    public static Boolean getBooleanDescriptorOption(PbOptionOwner owner, String optionName) {
        PbOptionExpression option = PbPsiUtil.getDescriptorOption(owner, optionName);
        if (option == null) {
            return null;
        }
        ProtoBooleanValue booleanValue = option.getBooleanValue();
        if (booleanValue == null) {
            return Boolean.FALSE;
        }
        Boolean value = booleanValue.getBooleanValue();
        if (value == null) {
            return Boolean.FALSE;
        }
        return value;
    }

    public static Boolean isDescriptorOption(PbOptionExpression option, String name) {
        PbOptionName optionName = option.getOptionName();
        PbOptionOwner optionOwner = (PbOptionOwner)PsiTreeUtil.getParentOfType((PsiElement)option, PbOptionOwner.class);
        if (optionOwner == null) {
            return false;
        }
        Descriptor descriptor = Descriptor.locate(option.getPbFile());
        if (descriptor == null) {
            return false;
        }
        PbField optionField = PbPsiUtil.resolveRefToType(optionName.getEffectiveReference(), PbField.class);
        if (optionField == null) {
            return false;
        }
        QualifiedName optionQualifiedName = optionField.getQualifiedName();
        if (optionQualifiedName == null) {
            return false;
        }
        QualifiedName descriptorTypeName = optionOwner.getDescriptorOptionsTypeName(descriptor);
        return optionQualifiedName.equals((Object)descriptorTypeName.append(name));
    }

    public static boolean isGeneratedMapEntry(PbElement element) {
        if (element instanceof PbMessageType && !element.isPhysical()) {
            Boolean mapEntryOption = PbPsiUtil.getBooleanDescriptorOption(((PbMessageType)element).getBody(), "map_entry");
            return Boolean.TRUE.equals(mapEntryOption);
        }
        return false;
    }

    @Nullable
    public static PbSymbolOwner getSymbolOwner(PsiElement element) {
        PbSymbolOwner owner = (PbSymbolOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PbSymbolOwner.class);
        if (owner instanceof PbFile) {
            return ((PbFile)owner).getPrimarySymbolOwner();
        }
        return owner;
    }

    @Nullable
    public static <T> T resolveRefToType(PsiReference ref, Class<T> type) {
        return PbPsiUtil.streamRefToType(ref, type).findFirst().orElse(null);
    }

    public static <T> List<T> multiResolveRefToType(PsiReference ref, Class<T> type) {
        return PbPsiUtil.streamRefToType(ref, type).collect(Collectors.toList());
    }

    private static <T> Stream<T> streamRefToType(PsiReference ref, Class<T> type) {
        PsiElement resolved;
        if (ref instanceof PsiPolyVariantReference) {
            PsiPolyVariantReference polyRef = (PsiPolyVariantReference)ref;
            return Arrays.stream(polyRef.multiResolve(false)).map(ResolveResult::getElement).filter(type::isInstance).map(type::cast);
        }
        if (ref != null && type.isInstance(resolved = ref.resolve())) {
            return Stream.of(type.cast(resolved));
        }
        return Stream.empty();
    }

    public static boolean fieldIsExtensionOrMember(PbField field, PbNamedTypeElement type) {
        return type.equals(field.getSymbolOwner()) || PbPsiUtil.fieldIsExtension(field, type);
    }

    public static boolean fieldIsExtension(PbField field, PbNamedTypeElement type) {
        PbTypeName extendeeType = field.getExtendee();
        if (extendeeType == null) {
            return false;
        }
        PsiReference ref = extendeeType.getEffectiveReference();
        return ref != null && type.equals(ref.resolve());
    }

    public static boolean fieldIsMessage(PbField field) {
        PbTypeName fieldType = field.getTypeName();
        if (fieldType == null) {
            return false;
        }
        PsiReference ref = fieldType.getEffectiveReference();
        return ref != null && PbPsiUtil.isMessageElement(ref.resolve());
    }

    public static boolean fieldIsGroup(PbField field) {
        PbTypeName fieldType = field.getTypeName();
        if (fieldType == null) {
            return false;
        }
        PsiReference ref = fieldType.getEffectiveReference();
        return ref != null && PbPsiUtil.isGroupElement(ref.resolve());
    }

    public static boolean isFirstInside(@NotNull PsiElement element, @NotNull PsiElement ancestor) {
        if (element == null) {
            PbPsiUtil.$$$reportNull$$$0(0);
        }
        if (ancestor == null) {
            PbPsiUtil.$$$reportNull$$$0(1);
        }
        TextRange ancestorTextRange = ancestor.getTextRange();
        TextRange elementTextRange = element.getTextRange();
        if (ancestorTextRange == null || elementTextRange == null) {
            return false;
        }
        return ancestorTextRange.getStartOffset() == elementTextRange.getStartOffset();
    }

    static boolean isElementType(PsiElement element, IElementType type) {
        return element != null && type.equals(element.getNode().getElementType());
    }

    static boolean isWhitespace(PsiElement element) {
        return PbPsiUtil.isElementType(element, TokenType.WHITE_SPACE);
    }

    static boolean isBlockComment(PsiElement element) {
        return PbPsiUtil.isElementType(element, ProtoTokenTypes.BLOCK_COMMENT);
    }

    static boolean isLineComment(PsiElement element) {
        return PbPsiUtil.isElementType(element, ProtoTokenTypes.LINE_COMMENT);
    }

    static boolean isComment(PsiElement element) {
        return PbPsiUtil.isLineComment(element) || PbPsiUtil.isBlockComment(element);
    }

    private PbPsiUtil() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "ancestor";
                break;
            }
        }
        objectArray[1] = "com/intellij/protobuf/lang/psi/util/PbPsiUtil";
        objectArray[2] = "isFirstInside";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

