/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.tree;

import ai.grazie.rules.tree.Node;
import ai.grazie.rules.tree.NodeMatch;
import ai.grazie.rules.tree.NodeMatcher;
import ai.grazie.rules.tree.PosEnumerator;
import ai.grazie.rules.util.regex.Regex;
import ai.grazie.rules.util.regex.RegexMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

abstract class PosMatcher
implements NodeMatcher {
    private final boolean usePotentialPos;

    private PosMatcher(boolean usePotentialPos) {
        this.usePotentialPos = usePotentialPos;
    }

    @Override
    @Nullable
    public NodeMatch matchWithPrevention(Node node, NodeMatch match) {
        short[] ids = (this.usePotentialPos ? node.tagIndependently() : node).sortedPosIds(node.tree().treeSupport());
        return ids.length > 0 && this.matchIds(node, ids) ? match : null;
    }

    abstract boolean matchIds(Node var1, short[] var2);

    static NodeMatcher create(String regex, boolean usePotentialPos) {
        if (".+".equals(regex) || ".*".equals(regex)) {
            return (node, match) -> (usePotentialPos ? node.tagIndependently().posReadings() : node.posReadings()).isEmpty() ? null : match;
        }
        Regex parsed = Regex.parse(regex);
        Set<String> values = parsed.possibleValues();
        if (values != null && values.size() == 1) {
            return PosMatcher.singleMatcher(usePotentialPos, values.iterator().next());
        }
        return PosMatcher.bitMaskMatcher(usePotentialPos, parsed.caseSensitiveMatcher(), (List<String>)(values == null ? null : new ArrayList<String>(values)));
    }

    private static PosMatcher singleMatcher(boolean potential, final String single) {
        return new PosMatcher(potential){
            short posId;

            @Override
            boolean matchIds(Node node, short[] sortedIds) {
                short posId = this.posId;
                if (posId == 0) {
                    this.posId = posId = this.enumerateSingle(node);
                }
                for (short each : sortedIds) {
                    if (each < posId) continue;
                    return each == posId;
                }
                return false;
            }

            private short enumerateSingle(Node node) {
                return PosEnumerator.forLanguage(node.tree().treeSupport().getGrazieLanguage()).enumerate(List.of(single))[0];
            }
        };
    }

    private static PosMatcher bitMaskMatcher(boolean potential, final RegexMatcher matcher, final @Nullable List<String> knownValues) {
        return new PosMatcher(potential){
            PosEnumerator.MatchedBitSet matchedSet;
            {
                super(usePotentialPos);
                this.matchedSet = null;
            }

            @Override
            boolean matchIds(Node node, short[] sortedIds) {
                PosEnumerator.MatchedBitSet snapshot = this.matchedSet;
                if (snapshot == null || snapshot.needsUpdate()) {
                    this.matchedSet = snapshot = this.updateSnapshot(node, snapshot);
                }
                return snapshot.matchIds(sortedIds);
            }

            private PosEnumerator.MatchedBitSet updateSnapshot(Node node, PosEnumerator.MatchedBitSet snapshot) {
                PosEnumerator enumerator = PosEnumerator.forLanguage(node.tree().treeSupport().getGrazieLanguage());
                return knownValues != null ? enumerator.matchTags(knownValues) : enumerator.growMatchedSet(matcher, snapshot);
            }
        };
    }
}

