/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.RunConfigurationExtension;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.profiler.DefaultProfilerExecutorGroup;
import com.intellij.profiler.MisConfiguredException;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.ToolWindowActivationProperties;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.api.configurations.ProfilerConfigurationState;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ultimate.JavaProfilerProcess;
import com.intellij.profiler.ultimate.ProcessUtilKt;
import com.intellij.profiler.ultimate.ProfilerRunnerSettings;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.widget.JavaProfilerConsoleWidgetManager;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 .*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001.B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J3\u0010\u0005\u001a\u00020\u0006\"\f\b\u0001\u0010\u0007*\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u0002H\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u0018\u001a\u00020\u00062\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\bJ\u0014\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0002J\u0014\u0010\u001f\u001a\u00020\u001d2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001eH\u0002J1\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00028\u00002\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010#\u001a\u00020$H$\u00a2\u0006\u0002\u0010%J\u0012\u0010&\u001a\u00020\u001d2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J&\u0010 \u001a\u00020\u00062\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010#\u001a\u00020$2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0004J\u0016\u0010'\u001a\u00020\u00062\f\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010\bH\u0016J$\u0010)\u001a\u0004\u0018\u0001H*\"\n\b\u0001\u0010*\u0018\u0001*\u00020\u00112\u0006\u0010+\u001a\u00020,H\u0084\b\u00a2\u0006\u0002\u0010-R'\u0010\u000f\u001a\u0015\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u00110\u0010\u00a2\u0006\u0002\b\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006/"}, d2={"Lcom/intellij/profiler/ultimate/JavaProfilerConfigurationExtension;", "ProfilerParameters", "Lcom/intellij/execution/RunConfigurationExtension;", "<init>", "()V", "updateJavaParameters", "", "T", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "configuration", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "(Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/JavaParameters;Lcom/intellij/execution/configurations/RunnerSettings;)V", "profilerConfigurationStateKey", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getProfilerConfigurationStateKey", "()Lcom/intellij/openapi/util/Key;", "profilerParametersKey", "getProfilerParametersKey", "openToolWindowAndReportStart", "profilerProcess", "Lcom/intellij/profiler/api/ProfilerProcess;", "runConfiguration", "profilerProcessIsStoppedByUserAndProfilerWidgetExists", "", "Lcom/intellij/profiler/ultimate/JavaProfilerProcess;", "profilerWidgetExists", "attachToProcess", "profilerConfigurationState", "profilerParameters", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "(Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;Ljava/lang/Object;Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/process/ProcessHandler;)V", "isApplicableFor", "cleanUserData", "runConfigurationBase", "getConfigurationState", "State", "executor", "Lcom/intellij/execution/Executor;", "(Lcom/intellij/execution/Executor;)Lcom/intellij/profiler/api/configurations/ProfilerConfigurationState;", "Companion", "intellij.profiler.ultimate"})
public abstract class JavaProfilerConfigurationExtension<ProfilerParameters>
extends RunConfigurationExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Key<ProfilerConfigurationState> profilerConfigurationStateKey;

    public JavaProfilerConfigurationExtension() {
        Key key = Key.create((String)"profiler.configuration.state");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.profilerConfigurationStateKey = key;
    }

    public final <T extends RunConfigurationBase<?>> void updateJavaParameters(@NotNull T configuration, @NotNull JavaParameters params, @Nullable RunnerSettings runnerSettings) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (!this.isApplicableFor(runnerSettings)) {
            return;
        }
        Project project = configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        throw new Companion.CantDetectProfilerExecutorId(project);
    }

    @NotNull
    protected final Key<ProfilerConfigurationState> getProfilerConfigurationStateKey() {
        return this.profilerConfigurationStateKey;
    }

    @NotNull
    protected abstract Key<ProfilerParameters> getProfilerParametersKey();

    public final void openToolWindowAndReportStart(@NotNull ProfilerProcess<?> profilerProcess, @NotNull RunConfigurationBase<?> runConfiguration) {
        Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
        Intrinsics.checkNotNullParameter(runConfiguration, (String)"runConfiguration");
        Project project = runConfiguration.getProject();
        String string = profilerProcess.getProfilerConfiguration().getConfigurationTypeId();
        String string2 = runConfiguration.getType().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
        ProfilerUsageTriggerCollector.logRecordingStarted((Project)project, (String)string, (String)string2);
        if (!(profilerProcess instanceof JavaProfilerProcess)) {
            return;
        }
        Project project2 = runConfiguration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        boolean showProfilerAttachedBalloon = !JavaProfilerConsoleWidgetManager.Companion.getInstance(project2).registerProfilerProcess(runConfiguration, (JavaProfilerProcess)profilerProcess);
        ToolWindowActivationProperties properties = new ToolWindowActivationProperties(false, showProfilerAttachedBalloon, () -> JavaProfilerConfigurationExtension.openToolWindowAndReportStart$lambda$0(this, profilerProcess));
        Project project3 = runConfiguration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
        ProfilerToolWindowManager.Companion.getInstance(project3).addProfilerProcessTab(profilerProcess, properties);
    }

    private final boolean profilerProcessIsStoppedByUserAndProfilerWidgetExists(JavaProfilerProcess<?> profilerProcess) {
        return this.profilerWidgetExists(profilerProcess) && (ProcessUtilKt.isProcessLikelyTerminatedByUser(profilerProcess.getTargetProcessHandler().getExitCode()) || ProcessUtilKt.isProfilerDetached(profilerProcess));
    }

    private final boolean profilerWidgetExists(JavaProfilerProcess<?> profilerProcess) {
        return JavaProfilerConsoleWidgetManager.Companion.getInstance(profilerProcess.getProject()).findWidget(profilerProcess) != null;
    }

    protected abstract void attachToProcess(@NotNull ProfilerConfigurationState var1, ProfilerParameters var2, @NotNull RunConfigurationBase<?> var3, @NotNull ProcessHandler var4) throws ExecutionException;

    protected boolean isApplicableFor(@Nullable RunnerSettings runnerSettings) {
        return runnerSettings instanceof ProfilerRunnerSettings;
    }

    protected final void attachToProcess(@NotNull RunConfigurationBase<?> configuration, @NotNull ProcessHandler handler, @Nullable RunnerSettings runnerSettings) {
        Intrinsics.checkNotNullParameter(configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        if (!this.isApplicableFor(runnerSettings)) {
            return;
        }
        Object profilerParameters = configuration.getUserData(this.getProfilerParametersKey());
        ProfilerConfigurationState profilerConfigurationState = (ProfilerConfigurationState)configuration.getUserData(this.profilerConfigurationStateKey);
        this.cleanUserData(configuration);
        if (profilerParameters == null || profilerConfigurationState == null) {
            return;
        }
        this.attachToProcess(profilerConfigurationState, profilerParameters, configuration, handler);
    }

    public void cleanUserData(@Nullable RunConfigurationBase<?> runConfigurationBase) {
        block1: {
            RunConfigurationBase<?> runConfigurationBase2 = runConfigurationBase;
            if (runConfigurationBase2 != null) {
                runConfigurationBase2.putUserData(this.getProfilerParametersKey(), null);
            }
            RunConfigurationBase<?> runConfigurationBase3 = runConfigurationBase;
            if (runConfigurationBase3 == null) break block1;
            runConfigurationBase3.putUserData(this.profilerConfigurationStateKey, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected final /* synthetic */ <State extends ProfilerConfigurationState> State getConfigurationState(Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        $i$f$getConfigurationState = false;
        v0 = DefaultProfilerExecutorGroup.Companion.getInstance();
        if (v0 == null) ** GOTO lbl-1000
        v1 = executor.getId();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getId(...)");
        if ((v0 = (DefaultProfilerExecutorGroup.ProfilerExecutorSettings)v0.getRegisteredSettings(v1)) != null) {
            v2 = v0.getState();
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        Intrinsics.reifiedOperationMarker((int)2, (String)"State");
        return (State)v2;
    }

    private static final boolean openToolWindowAndReportStart$lambda$0(JavaProfilerConfigurationExtension this$0, ProfilerProcess $profilerProcess) {
        return !this$0.profilerProcessIsStoppedByUserAndProfilerWidgetExists((JavaProfilerProcess)$profilerProcess);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lcom/intellij/profiler/ultimate/JavaProfilerConfigurationExtension$Companion;", "", "<init>", "()V", "CantDetectProfilerExecutorId", "intellij.profiler.ultimate"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ultimate/JavaProfilerConfigurationExtension$Companion$CantDetectProfilerExecutorId;", "Lcom/intellij/profiler/MisConfiguredException;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "fixAction", "", "intellij.profiler.ultimate"})
        private static final class CantDetectProfilerExecutorId
        extends MisConfiguredException {
            public CantDetectProfilerExecutorId(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                super(project, UltimateProfilerBundleKt.profilerMessage("profiler.exceptions.configurations.patch", new Object[0]), UltimateProfilerBundleKt.profilerMessage("profiler.exceptions.ask.report", new Object[0]));
            }

            public void fixAction(@NotNull Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                BrowserUtil.browse((String)"https://youtrack.jetbrains.com/newIssue?project=IDEA");
            }
        }
    }
}

