/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.jfr.configuration;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.api.AttachableTargetProcess;
import com.intellij.profiler.api.configurations.ProfilerAttacher;
import com.intellij.profiler.ultimate.JavaProfilerConfigurationType;
import com.intellij.profiler.ultimate.jfr.JFRProfilerProcess;
import com.intellij.profiler.ultimate.jfr.RecordingConfiguration;
import com.intellij.profiler.ultimate.jfr.configuration.JFRConfigurationState;
import com.intellij.profiler.ultimate.jfr.configuration.JFRSimpleConfigurable;
import com.intellij.profiler.ultimate.jfr.configuration.JFRStarter;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/intellij/profiler/ultimate/jfr/configuration/JFRConfigurationType;", "Lcom/intellij/profiler/ultimate/JavaProfilerConfigurationType;", "Lcom/intellij/profiler/ultimate/jfr/configuration/JFRConfigurationState;", "<init>", "()V", "displayName", "", "getDisplayName", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "id", "getId", "isAvailableForTarget", "", "getTemplateState", "createConfigurable", "Lcom/intellij/openapi/options/UnnamedConfigurable;", "state", "createAttacher", "Lcom/intellij/profiler/api/configurations/ProfilerAttacher;", "createStarter", "Lcom/intellij/profiler/ultimate/jfr/configuration/JFRStarter;", "intellij.profiler.ultimate"})
public final class JFRConfigurationType
extends JavaProfilerConfigurationType<JFRConfigurationState> {
    @NotNull
    private final String displayName;
    @NotNull
    private final String id;

    public JFRConfigurationType() {
        this.displayName = "Java Flight Recorder";
        this.id = "JFRSimpleConfiguration";
    }

    @NotNull
    public String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Actions.ProfileRed;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ProfileRed");
        return icon;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    public boolean isAvailableForTarget() {
        return true;
    }

    @NotNull
    public JFRConfigurationState getTemplateState() {
        return JFRConfigurationState.Companion.create$default(JFRConfigurationState.Companion, this.getDisplayName(), null, null, 6, null);
    }

    @NotNull
    public UnnamedConfigurable createConfigurable(@NotNull JFRConfigurationState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return (UnnamedConfigurable)new JFRSimpleConfigurable(state);
    }

    @NotNull
    public ProfilerAttacher createAttacher(@NotNull JFRConfigurationState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return new ProfilerAttacher(state){
            final /* synthetic */ JFRConfigurationState $state;
            {
                this.$state = $state;
            }

            public Promise<JFRProfilerProcess<AttachableTargetProcess>> attachTo(AttachableTargetProcess targetProcess, Project project) {
                Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                RecordingConfiguration configuration = RecordingConfiguration.Companion.create(String.valueOf(targetProcess.getPid()), targetProcess.getShortName(), project);
                return JFRProfilerProcess.Companion.attach(targetProcess, configuration, this.$state, project);
            }
        };
    }

    @NotNull
    public JFRStarter createStarter(@NotNull JFRConfigurationState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return JFRStarter.INSTANCE;
    }
}

