/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.google.common.net.HostAndPort;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.config.OpenSshConfigForwardInfo;
import com.intellij.ssh.config.ProxyJumpOptions;
import com.intellij.ssh.config.TildeExpandFilenameException;
import com.intellij.util.SystemProperties;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004H\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0007\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u0001H\u0007\u001a\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0001H\u0002\u001a\n\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\f\u0010\u0018\u001a\u00020\u0001*\u00020\u0019H\u0007\u001a\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0001H\u0007\u001a&\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001d2\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0005H\u0000\u001a&\u0010\u001f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00010\u001d2\u0006\u0010\u001b\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u0005H\u0000\u001a\u001e\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0006\u0012\u0004\u0018\u00010!0\u001d2\u0006\u0010\"\u001a\u00020\u0001H\u0007\u001a\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0001\"\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000ej\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0001`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"2\u0010\u0010\u001a&\u0012\u0004\u0012\u00020\u0001\u0012\b\u0012\u00060\u0011j\u0002`\u00120\u000ej\u0012\u0012\u0004\u0012\u00020\u0001\u0012\b\u0012\u00060\u0011j\u0002`\u0012`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006+"}, d2={"percentExpand", "", "pattern", "tokens", "", "", "resolveHostName", "hostName", "host", "tildeExpandFilename", "path", "homesLock", "Ljava/lang/Object;", "cachedHomes", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "cachedExceptions", "Ljava/lang/Exception;", "Lkotlin/Exception;", "o", "username", "N", "r", "r", "toProxyCommand", "Lcom/intellij/ssh/config/ProxyJumpOptions;", "parseJump", "value", "splitMinHead", "Lkotlin/Pair;", "delimiter", "splitMinTail", "splitHostPort", "", "hostPort", "parseOpenSshConfigForwardInfo", "Lcom/intellij/ssh/config/OpenSshConfigForwardInfo;", "conf", "defaultKnownHostsFiles", "", "Ljava/nio/file/Path;", "getDefaultKnownHostsFiles", "()Ljava/util/List;", "intellij.platform.ssh"})
@JvmName(name="OpenSSHConfigUtil")
@SourceDebugExtension(value={"SMAP\nopenSSHConfigUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 openSSHConfigUtil.kt\ncom/intellij/ssh/config/OpenSSHConfigUtil\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,305:1\n1179#2,2:306\n1#3:308\n37#4,2:309\n*S KotlinDebug\n*F\n+ 1 openSSHConfigUtil.kt\ncom/intellij/ssh/config/OpenSSHConfigUtil\n*L\n26#1:306,2\n272#1:309,2\n*E\n"})
public final class OpenSSHConfigUtil {
    @NotNull
    private static final Object homesLock = new Object();
    @NotNull
    private static final HashMap<String, String> cachedHomes = new HashMap();
    @NotNull
    private static final HashMap<String, Exception> cachedExceptions = new HashMap();

    @NotNull
    public static final String percentExpand(@NotNull String pattern, @NotNull Map<Character, String> tokens) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
        StringBuilder stringBuilder = new StringBuilder(pattern.length());
        boolean bl = false;
        CharSequence charSequence = pattern;
        boolean bl2 = false;
        for (int i = 0; i < charSequence.length(); ++i) {
            char c;
            char c2 = c = charSequence.charAt(i);
            boolean bl3 = false;
            Pair pair = c2 == '%' && !bl ? TuplesKt.to((Object)"", (Object)true) : (c2 == '%' && bl ? TuplesKt.to((Object)Character.valueOf('%'), (Object)false) : (tokens.containsKey(Character.valueOf(c2)) && bl ? TuplesKt.to((Object)tokens.get(Character.valueOf(c2)), (Object)false) : (bl ? TuplesKt.to((Object)("%" + c2), (Object)false) : TuplesKt.to((Object)Character.valueOf(c2), (Object)false))));
            Object object = pair.component1();
            boolean bl4 = (Boolean)pair.component2();
            stringBuilder.append(object);
            bl = bl4;
        }
        if (bl) {
            stringBuilder.append('%');
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @VisibleForTesting
    @NotNull
    public static final String resolveHostName(@NotNull String hostName, @NotNull String host) {
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return OpenSSHConfigUtil.percentExpand(hostName, MapsKt.mapOf((Pair)TuplesKt.to((Object)Character.valueOf('h'), (Object)host)));
    }

    @VisibleForTesting
    @NotNull
    public static final String tildeExpandFilename(@NotNull String path2) {
        List list;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        if (SystemInfo.isWindows) {
            Object[] objectArray = new String[]{"\\", "/"};
            v0 = CollectionsKt.listOf((Object[])objectArray);
        } else {
            v0 = list = CollectionsKt.listOf((Object)"/");
        }
        if (StringsKt.startsWith$default((String)path2, (String)"~", (boolean)false, (int)2, null)) {
            String string;
            Pair pair = StringsKt.findAnyOf$default((CharSequence)path2, (Collection)list, (int)1, (boolean)false, (int)4, null);
            int n = pair != null ? ((Number)pair.getFirst()).intValue() : path2.length();
            String string2 = path2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String string3 = string2;
            if (n == 1) {
                string = SystemProperties.getUserHome();
            } else {
                String string4;
                String string5 = path2.substring(1, n);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                String string6 = string5;
                try {
                    string4 = OpenSSHConfigUtil.o(string6);
                }
                catch (Exception exception) {
                    throw new TildeExpandFilenameException("Failed to expand ~" + string6 + " in " + path2, exception);
                }
                string = string4;
            }
            String string7 = string;
            Intrinsics.checkNotNull((Object)string7);
            String string8 = string7;
            return string8 + string3;
        }
        return path2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final String o(String string) {
        Object object = homesLock;
        synchronized (object) {
            boolean bl = false;
            String string2 = cachedHomes.get(string);
            if (string2 != null) {
                return string2;
            }
            Exception exception = cachedExceptions.get(string);
            if (exception != null) {
                throw new RuntimeException("Previous attempt to retrieve home directory for `" + string + "` user failed", exception);
            }
            try {
                String string3 = OpenSSHConfigUtil.N(string);
                ((Map)cachedHomes).put(string, string3);
                return string3;
            }
            catch (Exception exception2) {
                ((Map)cachedExceptions).put(string, exception2);
                throw exception2;
            }
        }
    }

    private static final String N(String string) {
        if (Intrinsics.areEqual((Object)SystemProperties.getUserName(), (Object)string)) {
            String string2 = SystemProperties.getUserHome();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUserHome(...)");
            return string2;
        }
        if (!SystemInfo.isWindows) {
            return OpenSSHConfigUtil.r(string);
        }
        return ((Object)Paths.get(SystemProperties.getUserHome(), new String[0]).resolveSibling(string)).toString();
    }

    private static final String r(String string) {
        String[] stringArray = new String[]{"sh", "-c", "echo ~" + string};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(stringArray);
        try {
            stringArray = ExecUtil.execAndGetOutput((GeneralCommandLine)generalCommandLine, (int)1000);
            if (stringArray.getExitCode() != 0) {
                throw new RuntimeException("Shell exited with code " + stringArray.getExitCode());
            }
            String string2 = stringArray.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStdout(...)");
            String string3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (Intrinsics.areEqual((Object)string3, (Object)("~" + string))) {
                throw new RuntimeException("Shell didn't expand ~" + string + ". Probably user does not exist.");
            }
            return string3;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to retrieve home directory for `" + string + "` user using `" + generalCommandLine.getCommandLineString() + "` command", exception);
        }
    }

    private static final String r() {
        String string;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            string = null;
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    public static final String toProxyCommand(@NotNull ProxyJumpOptions $this$toProxyCommand) {
        Intrinsics.checkNotNullParameter((Object)$this$toProxyCommand, (String)"<this>");
        StringBuilder stringBuilder = new StringBuilder();
        if ($this$toProxyCommand.getUser() != null) {
            stringBuilder.append(" -l " + $this$toProxyCommand.getUser());
        }
        if ($this$toProxyCommand.getPort() != null) {
            stringBuilder.append(" -p " + $this$toProxyCommand.getPort());
        }
        if ($this$toProxyCommand.getExtra() != null) {
            stringBuilder.append(" -J " + $this$toProxyCommand.getExtra());
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = string;
        return "ssh" + string2 + " -W '[%h]:%p' " + $this$toProxyCommand.getHost();
    }

    @VisibleForTesting
    @NotNull
    public static final ProxyJumpOptions parseJump(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Pair<String, String> pair = OpenSSHConfigUtil.splitMinHead(value, ',');
        String string = (String)pair.component1();
        String string2 = (String)pair.component2();
        if (StringsKt.startsWith$default((String)string, (String)"ssh://", (boolean)false, (int)2, null)) {
            URI uRI = URI.create(string);
            String string3 = uRI.getUserInfo();
            String string4 = uRI.getHost();
            Integer n = uRI.getPort() == -1 ? null : Integer.valueOf(uRI.getPort());
            Intrinsics.checkNotNull((Object)string4);
            return new ProxyJumpOptions(string3, string4, n, string2);
        }
        Pair<String, String> pair2 = OpenSSHConfigUtil.splitMinTail(string, '@');
        String string5 = (String)pair2.component1();
        String string6 = (String)pair2.component2();
        Pair<String, Integer> pair3 = OpenSSHConfigUtil.splitHostPort(string6);
        String string7 = (String)pair3.component1();
        Integer n = (Integer)pair3.component2();
        return new ProxyJumpOptions(string5, string7, n, string2);
    }

    @NotNull
    public static final Pair<String, String> splitMinHead(@NotNull String value, char delimiter) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int n = StringsKt.indexOf$default((CharSequence)value, (char)delimiter, (int)0, (boolean)false, (int)6, null);
        if (n == -1) {
            pair = TuplesKt.to((Object)value, null);
        } else {
            String string = value.substring(0, n);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = value.substring(n + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            pair = TuplesKt.to((Object)string, (Object)string2);
        }
        return pair;
    }

    @NotNull
    public static final Pair<String, String> splitMinTail(@NotNull String value, char delimiter) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int n = StringsKt.lastIndexOf$default((CharSequence)value, (char)delimiter, (int)0, (boolean)false, (int)6, null);
        if (n == -1) {
            pair = TuplesKt.to(null, (Object)value);
        } else {
            String string = value.substring(0, n);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String string2 = value.substring(n + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            pair = TuplesKt.to((Object)string, (Object)string2);
        }
        return pair;
    }

    @VisibleForTesting
    @NotNull
    public static final Pair<String, Integer> splitHostPort(@NotNull String hostPort) {
        HostAndPort hostAndPort;
        Intrinsics.checkNotNullParameter((Object)hostPort, (String)"hostPort");
        if (((CharSequence)hostPort).length() == 0) {
            throw new IllegalArgumentException("host[:port] must not be empty");
        }
        if (StringsKt.endsWith$default((CharSequence)hostPort, (char)':', (boolean)false, (int)2, null)) {
            throw new IllegalArgumentException("Port is not specified after the colon `:`");
        }
        HostAndPort hostAndPort2 = HostAndPort.fromString((String)hostPort).requireBracketsForIPv6();
        Intrinsics.checkNotNullExpressionValue((Object)hostAndPort2, (String)"requireBracketsForIPv6(...)");
        HostAndPort hostAndPort3 = hostAndPort = hostAndPort2;
        boolean bl = false;
        return hostAndPort3.hasPort() ? TuplesKt.to((Object)hostAndPort3.getHost(), (Object)hostAndPort3.getPort()) : TuplesKt.to((Object)hostAndPort3.getHost(), null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public static final OpenSshConfigForwardInfo parseOpenSshConfigForwardInfo(@NotNull String conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        var2_1 = conf;
        var3_2 = new Regex("( +|:)");
        var4_5 = 0;
        var2_1 = var3_2.split((CharSequence)var2_1, var4_5);
        var3_3 = false;
        var4_6 = var2_1;
        var1_7 = var4_6.toArray(new String[0]);
        switch (var1_7.length) {
            case 3: {
                var4_6 = new SpreadBuilder(2);
                var4_6.add((Object)"");
                var4_6.addSpread((Object)var1_7);
                v0 = (String[])var4_6.toArray((Object[])new String[var4_6.size()]);
                break;
            }
            case 4: {
                v0 = var1_7;
                break;
            }
            default: {
                throw new IllegalStateException("Can't parse " + conf);
            }
        }
        var2_1 = v0;
        var3_4 = var2_1[0];
        var4_6 = var2_1[1];
        var5_8 = var2_1[2];
        var6_9 = var2_1[3];
        try {
            block11: {
                var7_10 /* !! */  = var3_4;
                switch (var7_10 /* !! */ .hashCode()) {
                    case 0: {
                        if (var7_10 /* !! */ .equals("")) break;
                        ** break;
                    }
                    case -1204607085: {
                        if (var7_10 /* !! */ .equals("localhost")) break;
                        ** break;
                    }
                    case 42: {
                        if (!var7_10 /* !! */ .equals("*")) ** break;
                        v1 /* !! */  = "0.0.0.0";
                        break block11;
                    }
                }
                v1 /* !! */  = "127.0.0.1";
                break block11;
lbl43:
                // 4 sources

                v1 /* !! */  = var3_4;
            }
            var7_10 /* !! */  = new OpenSshConfigForwardInfo((String)v1 /* !! */ , Integer.parseInt((String)var4_6), (String)var5_8, Integer.parseInt(var6_9));
        }
        catch (Exception var8_11) {
            throw new IllegalStateException("Can't parse " + conf, var8_11);
        }
        return var7_10 /* !! */ ;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final List<Path> getDefaultKnownHostsFiles() {
        List list;
        Path path2 = Ssh.getHomeSshDirectory();
        Path path3 = path2.resolve("known_hosts");
        Path path4 = path2.resolve("known_hosts2");
        Intrinsics.checkNotNull((Object)path3);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Intrinsics.checkNotNull((Object)path4);
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            if (Files.exists(path4, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
                Object[] objectArray = new Path[]{path3, path4};
                list = CollectionsKt.listOf((Object[])objectArray);
                return list;
            }
        }
        Intrinsics.checkNotNull((Object)path4);
        LinkOption[] linkOptionArray3 = new LinkOption[]{};
        if (Files.exists(path4, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
            list = CollectionsKt.listOf((Object)path4);
            return list;
        }
        list = CollectionsKt.listOf((Object)path3);
        return list;
    }
}

