/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config.unified;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.AnalyzeKeyPairResult;
import com.intellij.ssh.InvalidKeyPair;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.ValidKeyPair;
import com.intellij.ssh.config.unified.ErrorMessageAndField;
import com.intellij.util.concurrency.Semaphore;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class SshCredentialsVerifier {
    private static final Logger LOG = Logger.getInstance(SshCredentialsVerifier.class);
    public static final int SLOW_VALIDATION_TIMEOUT_MS = Math.max(10, Integer.getInteger("com.jetbrains.ssh.validation.timeout.ms", 400));

    private SshCredentialsVerifier() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static ErrorMessageAndField verify(boolean checkSsh, @NonNls String accessTypeName, boolean fast, long msTimeout, boolean checkUserName, String host, int port, String username, AuthType authType, String privateKeyFile, @NotNull SshBackendLibrary sshBackendLibrary) throws TimeoutException {
        ErrorMessageAndField errorMessageAndField;
        if (sshBackendLibrary == null) {
            SshCredentialsVerifier.r(0);
        }
        if ((errorMessageAndField = SshCredentialsVerifier.validateWithoutAuth(accessTypeName, host, port)) != null) {
            return errorMessageAndField;
        }
        if (checkUserName && StringUtil.isEmpty((String)username)) {
            return new ErrorMessageAndField(SshBundle.message("credentials.username.is.empty", new Object[0]), "USERNAME");
        }
        if (checkSsh && authType == AuthType.KEY_PAIR) {
            if (StringUtil.isEmpty((String)privateKeyFile)) {
                return new ErrorMessageAndField(SshBundle.message("credentials.private.key.empty", new Object[0]), "PRIVATE_KEY_FILE");
            }
            if (!fast) {
                void backendLibrary;
                return (ErrorMessageAndField)SshCredentialsVerifier.runWithTimeout(msTimeout, () -> SshCredentialsVerifier.r(privateKeyFile, (SshBackendLibrary)backendLibrary));
            }
        }
        return null;
    }

    @Nullable
    public static ErrorMessageAndField validateWithoutAuth(@NonNls String accessTypeName, String host, int port) {
        URI uRI;
        if (StringUtil.isEmpty((String)host)) {
            return new ErrorMessageAndField(SshBundle.message("credentials.host.is.empty", accessTypeName), "HOST");
        }
        String string = host.replaceAll("_", "a");
        if (!string.startsWith("[")) {
            uRI = SshCredentialsVerifier.r(string);
            if (uRI == null || uRI.getScheme() == null) {
                uRI = SshCredentialsVerifier.r("ftp://" + string);
            }
        } else {
            uRI = SshCredentialsVerifier.r("ftp://" + string);
            if (uRI == null || uRI.getScheme() == null) {
                uRI = SshCredentialsVerifier.r(string);
            }
        }
        if (uRI == null || uRI.getHost() == null) {
            if (host.contains(":")) {
                boolean bl = true;
                for (int i = 0; i < host.length(); ++i) {
                    char c = host.charAt(i);
                    if (c >= '0' && c <= '9' || c == ':' || c == '[' || c == ']') continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    return new ErrorMessageAndField(SshBundle.message("credentials.host.is.invalid.try.ip6", accessTypeName), "HOST");
                }
            }
            if (!SshCredentialsVerifier.r(host)) {
                return new ErrorMessageAndField(SshBundle.message("credentials.host.is.invalid.try.type", accessTypeName), "HOST");
            }
            return new ErrorMessageAndField(SshBundle.message("credentials.host.is.invalid", accessTypeName), "HOST");
        }
        if (port <= 0) {
            return new ErrorMessageAndField(SshBundle.message("credentials.port.is.invalid", accessTypeName), "PORT");
        }
        return null;
    }

    private static boolean r(@Nullable String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= ' ' && c < '\u007f') continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static ErrorMessageAndField validate(ValidationMode mode, RemoteCredentials credentials, long msTimeout, @NotNull SshBackendLibrary sshBackendLibrary) throws TimeoutException {
        void backendLibrary;
        ErrorMessageAndField errorMessageAndField;
        if (sshBackendLibrary == null) {
            SshCredentialsVerifier.r(1);
        }
        if ((errorMessageAndField = SshCredentialsVerifier.validateWithoutAuth("SSH", credentials.getHost(), credentials.getPort())) != null) {
            return errorMessageAndField;
        }
        return SshCredentialsVerifier.validateAuthDataProvided(mode, credentials.getUserName(), credentials.getAuthType(), credentials.getPassword(), credentials.getPrivateKeyFile(), credentials.getPassphrase(), msTimeout, (SshBackendLibrary)backendLibrary);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static ErrorMessageAndField validateAuthDataProvided(RemoteCredentials credentials, long msTimeout, @NotNull SshBackendLibrary sshBackendLibrary) throws TimeoutException {
        void backendLibrary;
        if (sshBackendLibrary == null) {
            SshCredentialsVerifier.r(2);
        }
        return SshCredentialsVerifier.validateAuthDataProvided(credentials.getUserName(), credentials.getAuthType(), credentials.getPassword(), credentials.getPrivateKeyFile(), credentials.getPassphrase(), msTimeout, (SshBackendLibrary)backendLibrary);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static ErrorMessageAndField validateAuthDataProvided(String username, @NotNull AuthType authType, String password, String keyPath, String passphrase, long msTimeout, @NotNull SshBackendLibrary sshBackendLibrary) throws TimeoutException {
        void backendLibrary;
        if (authType == null) {
            SshCredentialsVerifier.r(3);
        }
        if (sshBackendLibrary == null) {
            SshCredentialsVerifier.r(4);
        }
        return SshCredentialsVerifier.validateAuthDataProvided(ValidationMode.FULL, username, authType, password, keyPath, passphrase, msTimeout, (SshBackendLibrary)backendLibrary);
    }

    @Nullable
    public static ErrorMessageAndField validateAuthDataProvided(ValidationMode mode, String username, @NotNull AuthType authType, String password, String keyPath, String passphrase, long msTimeout, @NotNull SshBackendLibrary sshBackendLibrary) throws TimeoutException {
        if (authType == null) {
            SshCredentialsVerifier.r(5);
        }
        if (sshBackendLibrary == null) {
            SshCredentialsVerifier.r(6);
        }
        if (StringUtil.isEmpty((String)username)) {
            return new ErrorMessageAndField(SshBundle.message("credentials.username.is.empty", new Object[0]), "USERNAME");
        }
        return switch (authType) {
            default -> throw new MatchException(null, null);
            case AuthType.OPEN_SSH -> null;
            case AuthType.PASSWORD -> {
                if (mode == ValidationMode.FULL && StringUtil.isEmpty((String)password)) {
                    yield new ErrorMessageAndField(SshBundle.message("credentials.password.is.not.specified", new Object[0]), "PASSWORD");
                }
                yield null;
            }
            case AuthType.KEY_PAIR -> {
                void backendLibrary;
                yield mode == ValidationMode.FULL && StringUtil.isEmpty((String)keyPath) ? new ErrorMessageAndField(SshBundle.message("credentials.private.key.empty", new Object[0]), "PRIVATE_KEY_FILE") : (mode == ValidationMode.WITHOUT_SLOW_KEY_CHECKS ? null : (ErrorMessageAndField)SshCredentialsVerifier.runWithTimeout(msTimeout, () -> SshCredentialsVerifier.r(keyPath, (SshBackendLibrary)backendLibrary, passphrase)));
            }
        };
    }

    @Nullable
    private static ErrorMessageAndField N(String string, @NotNull SshBackendLibrary sshBackendLibrary) {
        File file;
        if (sshBackendLibrary == null) {
            SshCredentialsVerifier.r(7);
        }
        if (!(file = new File(string)).isFile() || !file.canRead()) {
            return new ErrorMessageAndField(SshBundle.message("credentials.private.key.file.not.found", string), "PRIVATE_KEY_FILE");
        }
        AnalyzeKeyPairResult analyzeKeyPairResult = Ssh.analyzeKeyPair(file, sshBackendLibrary);
        if (analyzeKeyPairResult instanceof ValidKeyPair) {
            return null;
        }
        String string2 = ((InvalidKeyPair)analyzeKeyPairResult).getErrorMessage();
        if (string2 != null) {
            return new ErrorMessageAndField(SshBundle.message("credentials.invalid.keypair.massage", string, string2), "PRIVATE_KEY_FILE");
        }
        return new ErrorMessageAndField(SshBundle.message("credentials.invalid.keypair", string), "PRIVATE_KEY_FILE");
    }

    private static URI r(@NonNls String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            LOG.info("Invalid URI " + string + ": " + uRISyntaxException.getMessage());
            return null;
        }
    }

    public static <T> T runWithTimeout(long timeout, Computable<T> computable) throws TimeoutException {
        if (timeout <= 0L) {
            return (T)computable.compute();
        }
        Ref ref = new Ref();
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                ref.set(computable.compute());
            }
            finally {
                semaphore.up();
            }
        });
        if (!semaphore.waitFor(timeout)) {
            throw new TimeoutException();
        }
        return (T)ref.get();
    }

    @Nullable
    public static ValidationInfo wrapValidation(@NotNull ThrowableComputable<@Nls String, ? extends TimeoutException> validate) {
        Object object;
        block4: {
            if (validate == null) {
                SshCredentialsVerifier.r(8);
            }
            try {
                object = (String)validate.compute();
            }
            catch (TimeoutException timeoutException) {
                object = SshBundle.message("ssh.verifier.message.connection.timeout", new Object[0]);
                if (timeoutException.getMessage() == null) break block4;
                object = (String)object + ":" + timeoutException.getMessage();
            }
        }
        if (object != null) {
            return new ValidationInfo((String)object);
        }
        return null;
    }

    private static /* synthetic */ ErrorMessageAndField r(String string, SshBackendLibrary sshBackendLibrary, String string2) {
        boolean bl;
        ErrorMessageAndField errorMessageAndField = SshCredentialsVerifier.N(string, sshBackendLibrary);
        if (errorMessageAndField != null) {
            return errorMessageAndField;
        }
        if (StringUtil.isEmpty((String)string2) && (bl = Ssh.isPassphraseMayBeRequired(string, sshBackendLibrary))) {
            return new ErrorMessageAndField(SshBundle.message("credentials.provided.private.key.requires.a.passphrase", new Object[0]), "PASSPHRASE");
        }
        return null;
    }

    private static /* synthetic */ ErrorMessageAndField r(String string, SshBackendLibrary sshBackendLibrary) {
        return SshCredentialsVerifier.N(string, sshBackendLibrary);
    }

    private static /* synthetic */ void r(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendLibrary";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validate";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ssh/config/unified/SshCredentialsVerifier";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "verify";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "validateAuthDataProvided";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doSshSlowCheck";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapValidation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class ValidationMode
    extends Enum<ValidationMode> {
        public static final /* enum */ ValidationMode WITHOUT_SLOW_KEY_CHECKS = new ValidationMode();
        public static final /* enum */ ValidationMode WITHOUT_STRICT_CREDENTIALS = new ValidationMode();
        public static final /* enum */ ValidationMode FULL = new ValidationMode();
        private static final /* synthetic */ ValidationMode[] $VALUES;

        public static ValidationMode[] values() {
            return (ValidationMode[])$VALUES.clone();
        }

        public static ValidationMode valueOf(String name) {
            return Enum.valueOf(ValidationMode.class, name);
        }

        private static /* synthetic */ ValidationMode[] r() {
            return new ValidationMode[]{WITHOUT_SLOW_KEY_CHECKS, WITHOUT_STRICT_CREDENTIALS, FULL};
        }

        static {
            $VALUES = ValidationMode.r();
        }
    }
}

