/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj;

import com.hierynomus.sshj.key.KeyAlgorithm;
import com.intellij.ssh.impl.sshj.PlatformAgentProxy;
import com.jcraft.jsch.agentproxy.AgentProxy;
import com.jcraft.jsch.agentproxy.Identity;
import com.jcraft.jsch.agentproxy.sshj.AuthAgent;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.schmizz.sshj.common.Buffer;
import net.schmizz.sshj.common.KeyType;
import net.schmizz.sshj.common.Message;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.transport.Transport;
import net.schmizz.sshj.userauth.UserAuthException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0014J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010\n\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/ssh/impl/sshj/PlatformAuthAgent;", "Lcom/jcraft/jsch/agentproxy/sshj/AuthAgent;", "agentProxy", "Lcom/intellij/ssh/impl/sshj/PlatformAgentProxy;", "identity", "Lcom/jcraft/jsch/agentproxy/Identity;", "PlatformAuthAgent", "(Lcom/intellij/ssh/impl/sshj/PlatformAgentProxy;Lcom/jcraft/jsch/agentproxy/Identity;)V", "getIdentity", "()Lcom/jcraft/jsch/agentproxy/Identity;", "algorithm", "", "kotlin.jvm.PlatformType", "keyType", "Lnet/schmizz/sshj/common/KeyType;", "available", "Ljava/util/Queue;", "Lcom/hierynomus/sshj/key/KeyAlgorithm;", "toString", "r", "shouldRetry", "", "putPubKey", "Lnet/schmizz/sshj/common/SSHPacket;", "reqBuf", "handle", "", "cmd", "Lnet/schmizz/sshj/common/Message;", "buf", "r", "", "r", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSshjConnectionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshjConnectionUtil.kt\ncom/intellij/ssh/impl/sshj/PlatformAuthAgent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1113:1\n1#2:1114\n*E\n"})
final class PlatformAuthAgent
extends AuthAgent {
    @NotNull
    private final PlatformAgentProxy agentProxy;
    @NotNull
    private final Identity identity;
    private final String algorithm;
    private final KeyType keyType;
    @Nullable
    private Queue<KeyAlgorithm> available;

    public PlatformAuthAgent(@NotNull PlatformAgentProxy agentProxy, @NotNull Identity identity) {
        Intrinsics.checkNotNullParameter((Object)((Object)agentProxy), (String)"agentProxy");
        Intrinsics.checkNotNullParameter((Object)identity, (String)"identity");
        super((AgentProxy)agentProxy, identity);
        this.agentProxy = agentProxy;
        this.identity = identity;
        this.algorithm = new Buffer.PlainBuffer(this.identity.getBlob()).readString();
        this.keyType = KeyType.fromString((String)this.algorithm);
    }

    @NotNull
    public final Identity getIdentity() {
        return this.identity;
    }

    @NotNull
    public String toString() {
        String string = this.getName();
        byte[] byArray = this.identity.getComment();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getComment(...)");
        byte[] byArray2 = byArray;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return string + " from the SSH agent, comment: " + new String(byArray2, charset2);
    }

    private final KeyAlgorithm r(KeyType keyType) {
        Queue queue = this.available;
        if (queue == null) {
            queue = new ArrayDeque(this.params.getTransport().getClientKeyAlgorithms(keyType));
        }
        Queue queue2 = queue;
        this.available = queue2;
        return queue2.peek();
    }

    public boolean shouldRetry() {
        boolean bl;
        Queue<KeyAlgorithm> queue = this.available;
        if (queue != null) {
            Queue<KeyAlgorithm> queue2;
            Queue<KeyAlgorithm> queue3 = queue2 = queue;
            boolean bl2 = false;
            queue3.poll();
            bl = !((Collection)queue2).isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    protected SSHPacket putPubKey(@NotNull SSHPacket reqBuf) {
        Intrinsics.checkNotNullParameter((Object)reqBuf, (String)"reqBuf");
        try {
            KeyType keyType = this.keyType;
            Intrinsics.checkNotNullExpressionValue((Object)keyType, (String)"keyType");
            KeyAlgorithm keyAlgorithm = this.r(keyType);
            if (keyAlgorithm != null) {
                ((SSHPacket)((SSHPacket)reqBuf.putString(keyAlgorithm.getKeyAlgorithm())).putBytes(this.identity.getBlob())).getCompactData();
                return reqBuf;
            }
        }
        catch (IOException iOException) {
            throw new UserAuthException("No KeyAlgorithm configured for key " + this.keyType, (Throwable)iOException);
        }
        throw new UserAuthException("No KeyAlgorithm configured for key " + this.keyType);
    }

    public void handle(@NotNull Message cmd, @NotNull SSHPacket buf) {
        Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        if (cmd == Message.USERAUTH_60) {
            Transport transport = this.params.getTransport();
            Buffer buffer = ((SSHPacket)((SSHPacket)((SSHPacket)new SSHPacket(Message.USERAUTH_REQUEST).putString(this.params.getUsername())).putString(this.params.getNextServiceName())).putString(this.getName())).putBoolean(true);
            Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"putBoolean(...)");
            transport.write(this.r(this.putPubKey((SSHPacket)buffer)));
        } else {
            super.handle(cmd, buf);
        }
    }

    private final int r(KeyAlgorithm keyAlgorithm) {
        String string;
        KeyAlgorithm keyAlgorithm2 = keyAlgorithm;
        String string2 = string = keyAlgorithm2 != null ? keyAlgorithm2.getKeyAlgorithm() : null;
        return Intrinsics.areEqual((Object)string, (Object)"rsa-sha2-256") ? 2 : (Intrinsics.areEqual((Object)string, (Object)"rsa-sha2-512") ? 4 : 0);
    }

    private final SSHPacket r(SSHPacket sSHPacket) {
        byte[] byArray = ((Buffer.PlainBuffer)((Buffer.PlainBuffer)new Buffer.PlainBuffer().putString(this.params.getTransport().getSessionID())).putBuffer((Buffer)sSHPacket)).getCompactData();
        byte[] byArray2 = this.identity.getBlob();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBlob(...)");
        Intrinsics.checkNotNull((Object)byArray);
        KeyType keyType = this.keyType;
        Intrinsics.checkNotNullExpressionValue((Object)keyType, (String)"keyType");
        sSHPacket.putBytes(this.agentProxy.sign(byArray2, byArray, this.r(this.r(keyType))));
        return sSHPacket;
    }
}

