/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ssh.RemoteFileObject;
import com.intellij.ssh.SftpChannelException;
import com.intellij.ssh.impl.sshj.SshjLazyLstatHolder;
import com.intellij.ssh.impl.sshj.SshjRemoteFileObjectKt;
import com.intellij.ssh.impl.sshj.UtilKt;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.OpenMode;
import net.schmizz.sshj.sftp.RemoteFile;
import net.schmizz.sshj.sftp.RemoteResourceInfo;
import net.schmizz.sshj.sftp.Response;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\rJ\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u001a\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001eH\u0016J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00010\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001eH\u0002J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\nH\u0016J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020#2\u0006\u0010(\u001a\u00020\u0017H\u0016J!\u0010)\u001a\u00020#2\u0017\u0010*\u001a\u0013\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020#0+\u00a2\u0006\u0002\b-H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\nH\u0016J\b\u00101\u001a\u00020\u0017H\u0016J\u0010\u00102\u001a\u00020#2\u0006\u00103\u001a\u00020\u0005H\u0016J\b\u00104\u001a\u00020\u0014H\u0016J\u0010\u00105\u001a\u00020#2\u0006\u0010(\u001a\u00020\u0014H\u0016J\b\u00106\u001a\u00020\u0005H\u0016J\"\u00107\u001a\u0002H8\"\u0004\b\u0000\u001082\f\u00109\u001a\b\u0012\u0004\u0012\u0002H80:H\u0082\b\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u00020#H\u0016J\b\u0010=\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019\u00a8\u0006>"}, d2={"Lcom/intellij/ssh/impl/sshj/SshjRemoteFileObject;", "Lcom/intellij/ssh/RemoteFileObject;", "sftp", "Lnet/schmizz/sshj/sftp/SFTPClient;", "path", "", "ownerName", "fileAttributes", "Lnet/schmizz/sshj/sftp/FileAttributes;", "surelyImaginary", "", "SshjRemoteFileObject", "(Lnet/schmizz/sshj/sftp/SFTPClient;Ljava/lang/String;Ljava/lang/String;Lnet/schmizz/sshj/sftp/FileAttributes;Z)V", "(Lnet/schmizz/sshj/sftp/SFTPClient;Ljava/lang/String;Ljava/lang/String;Z)V", "lstat", "Lcom/intellij/ssh/impl/sshj/SshjLazyLstatHolder;", "exists", "isDir", "isSymbolicLink", "size", "", "name", "permissions", "", "getPermissions", "()I", "UId", "getUId", "child", "list", "", "r", "remoteResourceInfos", "Lnet/schmizz/sshj/sftp/RemoteResourceInfo;", "mkdir", "", "rm", "inputStream", "Ljava/io/InputStream;", "setPermissions", "value", "r", "block", "Lkotlin/Function1;", "Lnet/schmizz/sshj/sftp/FileAttributes$Builder;", "Lkotlin/ExtensionFunctionType;", "outputStream", "Ljava/io/OutputStream;", "append", "getGroupId", "moveTo", "newAbsolutePath", "getLastModifiedTime", "setLastModifiedTime", "canonicalPath", "r", "T", "handler", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "clearCachedData", "toString", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nSshjRemoteFileObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshjRemoteFileObject.kt\ncom/intellij/ssh/impl/sshj/SshjRemoteFileObject\n+ 2 Util.kt\ncom/intellij/ssh/impl/sshj/UtilKt\n+ 3 SshjRemoteFileObject.kt\ncom/intellij/ssh/impl/sshj/SshjRemoteFileObjectKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,248:1\n168#1,2:312\n172#1,2:329\n168#1,2:365\n172#1,2:397\n168#1,2:482\n172#1,2:499\n168#1,2:535\n172#1,2:552\n168#1,2:588\n172#1,2:605\n44#2,3:249\n48#2,28:267\n41#2,6:306\n48#2,28:331\n41#2,6:359\n48#2,28:399\n41#2,6:427\n48#2,28:448\n41#2,6:476\n48#2,28:501\n41#2,6:529\n48#2,28:554\n41#2,6:582\n48#2,28:607\n41#2,6:635\n48#2,28:656\n233#3,15:252\n233#3,15:314\n233#3,15:367\n233#3,15:382\n233#3,15:433\n233#3,15:484\n233#3,15:537\n233#3,15:590\n233#3,15:641\n1740#4,3:295\n1563#4:298\n1634#4,3:299\n1563#4:302\n1634#4,3:303\n*S KotlinDebug\n*F\n+ 1 SshjRemoteFileObject.kt\ncom/intellij/ssh/impl/sshj/SshjRemoteFileObject\n*L\n69#1:312,2\n69#1:329,2\n81#1:365,2\n81#1:397,2\n118#1:482,2\n118#1:499,2\n130#1:535,2\n130#1:552,2\n151#1:588,2\n151#1:605,2\n41#1:249,3\n41#1:267,28\n68#1:306,6\n68#1:331,28\n74#1:359,6\n74#1:399,28\n102#1:427,6\n102#1:448,28\n117#1:476,6\n117#1:501,28\n125#1:529,6\n125#1:554,28\n150#1:582,6\n150#1:607,28\n160#1:635,6\n160#1:656,28\n42#1:252,15\n70#1:314,15\n84#1:367,15\n87#1:382,15\n103#1:433,15\n120#1:484,15\n131#1:537,15\n152#1:590,15\n161#1:641,15\n53#1:295,3\n59#1:298\n59#1:299,3\n65#1:302\n65#1:303,3\n*E\n"})
public final class SshjRemoteFileObject
implements RemoteFileObject {
    @NotNull
    private final SFTPClient sftp;
    @NotNull
    private final String path;
    @NotNull
    private final String ownerName;
    @NotNull
    private final SshjLazyLstatHolder lstat;

    private SshjRemoteFileObject(SFTPClient sftp, String path2, String ownerName, FileAttributes fileAttributes, boolean surelyImaginary) {
        this.sftp = sftp;
        this.path = path2;
        this.ownerName = ownerName;
        this.lstat = new SshjLazyLstatHolder(this.sftp, this.path, fileAttributes, surelyImaginary);
    }

    /* synthetic */ SshjRemoteFileObject(SFTPClient sFTPClient, String string, String string2, FileAttributes fileAttributes, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(sFTPClient, string, string2, fileAttributes, bl);
    }

    public SshjRemoteFileObject(@NotNull SFTPClient sftp, @NotNull String path2, @NotNull String ownerName, boolean surelyImaginary) {
        Intrinsics.checkNotNullParameter((Object)sftp, (String)"sftp");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Intrinsics.checkNotNullParameter((Object)ownerName, (String)"ownerName");
        this(sftp, path2, ownerName, null, surelyImaginary);
    }

    public /* synthetic */ SshjRemoteFileObject(SFTPClient sFTPClient, String string, String string2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        this(sFTPClient, string, string2, bl);
    }

    @Override
    public boolean exists() {
        return this.lstat.isFileExist();
    }

    @Override
    public boolean isDir() {
        return this.lstat.getOrThrow().getType() == FileMode.Type.DIRECTORY;
    }

    @Override
    public boolean isSymbolicLink() {
        return this.lstat.getOrThrow().getType() == FileMode.Type.SYMLINK;
    }

    @Override
    public long size() {
        return this.lstat.getOrThrow().getSize();
    }

    @Override
    @NotNull
    public String path() {
        return this.path;
    }

    @Override
    @NotNull
    public String name() {
        return UtilKt.posixBasename(this.path);
    }

    @Override
    public int getPermissions() {
        return this.lstat.getOrThrow().getMode().getMask();
    }

    @Override
    public int getUId() {
        return this.lstat.getOrThrow().getUID();
    }

    @Override
    @NotNull
    public RemoteFileObject child(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.r(name, null);
    }

    private final SshjRemoteFileObject r(String string, FileAttributes fileAttributes) {
        return new SshjRemoteFileObject(this.sftp, this.path + "/" + string, this.ownerName, fileAttributes, false, 16, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<RemoteFileObject> list() {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        try {
            List list;
            List list2;
            boolean bl4 = false;
            boolean bl5 = false;
            if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                boolean bl6 = false;
                list2 = this.sftp.ls(this.path);
            } else {
                List list3;
                long l = System.nanoTime();
                String string = "ok";
                try {
                    boolean bl7 = false;
                    list3 = this.sftp.ls(this.path);
                }
                catch (Throwable throwable) {
                    string = "exception";
                    throw throwable;
                }
                finally {
                    long l2 = System.nanoTime();
                    Logger logger = UtilKt.getSSHJ_LOG();
                    boolean bl8 = false;
                    logger.debug("Called " + (this + ".sftp.ls()") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(l2 - l) / 1000000.0) + " ms (" + string + ")");
                }
                list2 = list3;
            }
            List list4 = list = list2;
            boolean bl9 = false;
            Logger logger = UtilKt.getSSHJ_LOG();
            Intrinsics.checkNotNull((Object)list4);
            logger.debug("list() results:\n" + CollectionsKt.joinToString$default((Iterable)list4, (CharSequence)"\n", null, null, (int)0, null, SshjRemoteFileObject::r, (int)30, null));
            List list5 = list;
            Intrinsics.checkNotNull((Object)list5);
            return this.r(list5);
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl10 = false;
            object = "Failed to list files in path " + this.path;
            Response.StatusCode statusCode = sFTPException.getStatusCode();
            switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                case 1: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                    }
                    UtilKt.getSSHJ_LOG().info((String)object);
                    break;
                }
                case 2: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                    }
                    UtilKt.getSSHJ_LOG().warn((String)object);
                    break;
                }
                default: {
                    UtilKt.getSSHJ_LOG().warn((String)object, (Throwable)sFTPException);
                }
            }
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl11 = false;
            String string = "Failed to list files in path " + this.path;
            UtilKt.getSSHJ_LOG().warn(string, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string, iOException);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final List<RemoteFileObject> r(List<? extends RemoteResourceInfo> var1_1) {
        block7: {
            block6: {
                block8: {
                    if (!Intrinsics.areEqual((Object)this.path, (Object)"/")) break block7;
                    var3_2 = var1_1;
                    var4_4 = false;
                    if (!(var3_2 instanceof Collection) || !((Collection)var3_2).isEmpty()) break block8;
                    v0 = true;
                    break block6;
                }
                for (Object var6_7 : var3_2) {
                    var7_9 = (RemoteResourceInfo)var6_7;
                    var8_11 = false;
                    if (!var7_9.isDirectory() || var7_9.getName().length() != 2) ** GOTO lbl-1000
                    var9_14 = var7_9.getName().charAt(0);
                    v1 = 'A' <= var9_14 ? var9_14 < '[' : false;
                    if (v1 && var7_9.getName().charAt(1) == ':') {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    if (v2) continue;
                    v0 = false;
                    break block6;
                }
                v0 = var2_17 = true;
            }
            if (var2_17) {
                var3_2 = var1_1;
                var4_4 = false;
                var5_6 = var3_2;
                var6_7 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)var3_2, (int)10));
                var7_10 = false;
                var8_12 = var5_6.iterator();
                while (var8_12.hasNext()) {
                    var9_15 = var8_12.next();
                    var10_19 = (RemoteResourceInfo)var9_15;
                    var12_22 = var6_7;
                    var11_21 = false;
                    var12_22.add((SshjRemoteFileObject)new SshjRemoteFileObject(this.sftp, "/" + var10_19.getName() + "/", this.ownerName, var10_19.getAttributes(), false, 16, null));
                }
                return (List)var6_7;
            }
        }
        var2_18 = var1_1;
        var3_3 = false;
        var4_5 = var2_18;
        var5_6 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)var2_18, (int)10));
        var6_8 = false;
        for (E var8_13 : var4_5) {
            var9_16 = (RemoteResourceInfo)var8_13;
            var12_23 = var5_6;
            var10_20 = false;
            v3 = var9_16.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getName(...)");
            var12_23.add(this.r(v3, var9_16.getAttributes()));
        }
        return (List)var5_6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mkdir() {
        String string = this.path;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl;
        boolean bl5 = bl2;
        boolean bl6 = false;
        try {
            boolean bl7 = false;
            SshjRemoteFileObject sshjRemoteFileObject = this;
            boolean bl8 = false;
            try {
                boolean bl9 = false;
                boolean bl10 = false;
                if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                    boolean bl11 = false;
                    this.sftp.mkdir(this.path);
                } else {
                    long l = System.nanoTime();
                    String string2 = "ok";
                    try {
                        boolean bl12 = false;
                        this.sftp.mkdir(this.path);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        string2 = "exception";
                        throw throwable;
                    }
                    finally {
                        long l2 = System.nanoTime();
                        Logger logger = UtilKt.getSSHJ_LOG();
                        boolean bl13 = false;
                        logger.debug("Called " + (this + ".mkdir()") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(l2 - l) / 1000000.0) + " ms (" + string2 + ")");
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                sshjRemoteFileObject.lstat.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl14 = false;
            object = "File " + string + ": " + ((Throwable)object).getMessage();
            Response.StatusCode statusCode = sFTPException.getStatusCode();
            switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                case 1: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                    }
                    UtilKt.getSSHJ_LOG().info((String)object);
                    break;
                }
                case 2: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                    }
                    UtilKt.getSSHJ_LOG().warn((String)object);
                    break;
                }
                default: {
                    UtilKt.getSSHJ_LOG().warn((String)object, (Throwable)sFTPException);
                }
            }
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl15 = false;
            String string3 = "File " + string + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string3, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string3, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean rm() {
        boolean bl;
        String string = this.path;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = bl2;
        boolean bl6 = bl3;
        boolean bl7 = false;
        try {
            boolean bl8;
            boolean bl9 = false;
            SshjRemoteFileObject sshjRemoteFileObject = this;
            boolean bl10 = false;
            try {
                boolean bl11;
                boolean bl12 = false;
                try {
                    block31: {
                        try {
                            bl11 = false;
                            if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                                boolean bl13 = false;
                                this.sftp.rm(this.path);
                                break block31;
                            }
                            long l = System.nanoTime();
                            String string2 = "ok";
                            try {
                                boolean bl14 = false;
                                this.sftp.rm(this.path);
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable) {
                                string2 = "exception";
                                throw throwable;
                            }
                            finally {
                                long l2 = System.nanoTime();
                                Logger logger = UtilKt.getSSHJ_LOG();
                                boolean bl15 = false;
                                logger.debug("Called " + (this + ".sftp.rm()") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(l2 - l) / 1000000.0) + " ms (" + string2 + ")");
                            }
                        }
                        catch (SFTPException sFTPException) {
                            boolean bl16 = false;
                            if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                                boolean bl17 = false;
                                this.sftp.rmdir(this.path);
                            }
                            long l = System.nanoTime();
                            String string3 = "ok";
                            try {
                                boolean bl18 = false;
                                this.sftp.rmdir(this.path);
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable) {
                                string3 = "exception";
                                throw throwable;
                            }
                            finally {
                                long l3 = System.nanoTime();
                                Logger logger = UtilKt.getSSHJ_LOG();
                                boolean bl19 = false;
                                logger.debug("Called " + (this + ".sftp.rmdir()") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(l3 - l) / 1000000.0) + " ms (" + string3 + ")");
                            }
                        }
                    }
                    bl11 = true;
                }
                catch (SFTPException sFTPException) {
                    UtilKt.getSSHJ_LOG().debug(this + ".rm(): Got error " + sFTPException);
                    Response.StatusCode statusCode = sFTPException.getStatusCode();
                    switch (statusCode == null ? -1 : WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                        case 1: 
                        case 2: {
                            break;
                        }
                        default: {
                            throw sFTPException;
                        }
                    }
                    bl11 = false;
                }
                bl8 = bl11;
            }
            finally {
                sshjRemoteFileObject.lstat.clear();
            }
            bl = bl8;
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl20 = false;
            object = "File " + string + ": " + ((Throwable)object).getMessage();
            Response.StatusCode statusCode = sFTPException.getStatusCode();
            switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                case 1: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                    }
                    UtilKt.getSSHJ_LOG().info((String)object);
                    break;
                }
                case 2: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                    }
                    UtilKt.getSSHJ_LOG().warn((String)object);
                    break;
                }
                default: {
                    UtilKt.getSSHJ_LOG().warn((String)object, (Throwable)sFTPException);
                }
            }
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl21 = false;
            String string4 = "File " + string + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string4, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string4, iOException);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public InputStream inputStream() {
        FilterInputStream filterInputStream;
        String string = this.path;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl;
        boolean bl5 = bl2;
        boolean bl6 = false;
        try {
            RemoteFile remoteFile;
            boolean bl7 = false;
            boolean bl8 = false;
            if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                boolean bl9 = false;
                remoteFile = this.sftp.open(this.path);
            } else {
                RemoteFile remoteFile2;
                long l = System.nanoTime();
                String string2 = "ok";
                try {
                    boolean bl10 = false;
                    remoteFile2 = this.sftp.open(this.path);
                }
                catch (Throwable throwable) {
                    string2 = "exception";
                    throw throwable;
                }
                finally {
                    long l2 = System.nanoTime();
                    Logger logger = UtilKt.getSSHJ_LOG();
                    boolean bl11 = false;
                    logger.debug("Called " + (this + ".sftp.open()") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(l2 - l) / 1000000.0) + " ms (" + string2 + ")");
                }
                remoteFile = remoteFile2;
            }
            RemoteFile remoteFile3 = remoteFile;
            Intrinsics.checkNotNull((Object)remoteFile3);
            RemoteFile.ReadAheadRemoteFileInputStream readAheadRemoteFileInputStream = new RemoteFile.ReadAheadRemoteFileInputStream(remoteFile3, 10);
            filterInputStream = new FilterInputStream(remoteFile3, readAheadRemoteFileInputStream){
                final /* synthetic */ RemoteFile $file;
                {
                    this.$file = $file;
                    super((InputStream)$super_call_param$1);
                }

                public void close() {
                    UtilKt.getSSHJ_LOG().debug(this + ".inputStream() is being closed");
                    super.close();
                    this.$file.close();
                }
            };
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl12 = false;
            object = "File " + string + ": " + ((Throwable)object).getMessage();
            Response.StatusCode statusCode = sFTPException.getStatusCode();
            switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                case 1: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                    }
                    UtilKt.getSSHJ_LOG().info((String)object);
                    break;
                }
                case 2: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                    }
                    UtilKt.getSSHJ_LOG().warn((String)object);
                    break;
                }
                default: {
                    UtilKt.getSSHJ_LOG().warn((String)object, (Throwable)sFTPException);
                }
            }
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl13 = false;
            String string3 = "File " + string + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string3, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string3, iOException);
        }
        return filterInputStream;
    }

    @Override
    public void setPermissions(int value) {
        this.r((Function1<? super FileAttributes.Builder, Unit>)((Function1)arg_0 -> SshjRemoteFileObject.r(value, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void r(Function1<? super FileAttributes.Builder, Unit> function1) {
        String string = this.path;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl;
        boolean bl5 = bl2;
        boolean bl6 = false;
        try {
            boolean bl7 = false;
            SshjRemoteFileObject sshjRemoteFileObject = this;
            boolean bl8 = false;
            try {
                boolean bl9 = false;
                FileAttributes.Builder builder = new FileAttributes.Builder();
                function1.invoke((Object)builder);
                FileAttributes fileAttributes = builder.build();
                boolean bl10 = false;
                if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                    boolean bl11 = false;
                    this.sftp.setattr(this.path, fileAttributes);
                } else {
                    long l = System.nanoTime();
                    String string2 = "ok";
                    try {
                        boolean bl12 = false;
                        this.sftp.setattr(this.path, fileAttributes);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        string2 = "exception";
                        throw throwable;
                    }
                    finally {
                        long l2 = System.nanoTime();
                        Logger logger = UtilKt.getSSHJ_LOG();
                        boolean bl13 = false;
                        logger.debug("Called " + (this + ".sftp.setattr(" + fileAttributes + ")") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(l2 - l) / 1000000.0) + " ms (" + string2 + ")");
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                sshjRemoteFileObject.lstat.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl14 = false;
            object = "File " + string + ": " + ((Throwable)object).getMessage();
            Response.StatusCode statusCode = sFTPException.getStatusCode();
            switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                case 1: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                    }
                    UtilKt.getSSHJ_LOG().info((String)object);
                    break;
                }
                case 2: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                    }
                    UtilKt.getSSHJ_LOG().warn((String)object);
                    break;
                }
                default: {
                    UtilKt.getSSHJ_LOG().warn((String)object, (Throwable)sFTPException);
                }
            }
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl15 = false;
            String string3 = "File " + string + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string3, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string3, iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public OutputStream outputStream(boolean append) {
        String string = this.path;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl;
        boolean bl5 = bl2;
        boolean bl6 = false;
        try {
            FilterOutputStream filterOutputStream;
            boolean bl7 = false;
            EnumSet<Enum> enumSet = EnumSet.of((Enum)OpenMode.CREAT, (Enum)OpenMode.WRITE, (Enum)(append ? OpenMode.APPEND : OpenMode.TRUNC));
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(...)");
            Set set = enumSet;
            SshjRemoteFileObject sshjRemoteFileObject = this;
            boolean bl8 = false;
            try {
                RemoteFile remoteFile;
                boolean bl9 = false;
                boolean bl10 = false;
                if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                    var15_16 = false;
                    remoteFile = this.sftp.open(this.path, set);
                } else {
                    RemoteFile remoteFile2;
                    long l = System.nanoTime();
                    String string2 = "ok";
                    try {
                        var15_16 = false;
                        remoteFile2 = this.sftp.open(this.path, set);
                    }
                    catch (Throwable throwable) {
                        string2 = "exception";
                        throw throwable;
                    }
                    finally {
                        long l2 = System.nanoTime();
                        Logger logger = UtilKt.getSSHJ_LOG();
                        boolean bl11 = false;
                        logger.debug("Called " + (this + ".sftp.open(" + set + ")") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(l2 - l) / 1000000.0) + " ms (" + string2 + ")");
                    }
                    remoteFile = remoteFile2;
                }
                RemoteFile remoteFile3 = remoteFile;
                Intrinsics.checkNotNull((Object)remoteFile3);
                RemoteFile.RemoteFileOutputStream remoteFileOutputStream = new RemoteFile.RemoteFileOutputStream(remoteFile3, 0L, 10);
                filterOutputStream = new FilterOutputStream(remoteFileOutputStream, remoteFile3){
                    final /* synthetic */ RemoteFile.RemoteFileOutputStream $realOutputStream;
                    final /* synthetic */ RemoteFile $file;
                    {
                        this.$realOutputStream = $realOutputStream;
                        this.$file = $file;
                        super((OutputStream)$realOutputStream);
                    }

                    public void write(byte[] b, int off, int len) {
                        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                        this.$realOutputStream.write(b, off, len);
                    }

                    public void close() {
                        UtilKt.getSSHJ_LOG().debug(this + ".outputStream() is being closed");
                        super.close();
                        this.$file.close();
                    }
                };
            }
            finally {
                sshjRemoteFileObject.lstat.clear();
            }
            return filterOutputStream;
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl12 = false;
            object = "File " + string + ": " + ((Throwable)object).getMessage();
            Response.StatusCode statusCode = sFTPException.getStatusCode();
            switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                case 1: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                    }
                    UtilKt.getSSHJ_LOG().info((String)object);
                    break;
                }
                case 2: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                    }
                    UtilKt.getSSHJ_LOG().warn((String)object);
                    break;
                }
                default: {
                    UtilKt.getSSHJ_LOG().warn((String)object, (Throwable)sFTPException);
                }
            }
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl13 = false;
            String string3 = "File " + string + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string3, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string3, iOException);
        }
    }

    @Override
    public int getGroupId() {
        return this.lstat.getOrThrow().getGID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveTo(@NotNull String newAbsolutePath) {
        Intrinsics.checkNotNullParameter((Object)newAbsolutePath, (String)"newAbsolutePath");
        String string = this.path + " => " + newAbsolutePath;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl;
        boolean bl5 = bl2;
        boolean bl6 = false;
        try {
            boolean bl7 = false;
            SshjRemoteFileObject sshjRemoteFileObject = this;
            boolean bl8 = false;
            try {
                boolean bl9 = false;
                boolean bl10 = false;
                if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                    boolean bl11 = false;
                    this.sftp.rename(this.path, newAbsolutePath);
                } else {
                    long l = System.nanoTime();
                    String string2 = "ok";
                    try {
                        boolean bl12 = false;
                        this.sftp.rename(this.path, newAbsolutePath);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable) {
                        string2 = "exception";
                        throw throwable;
                    }
                    finally {
                        long l2 = System.nanoTime();
                        Logger logger = UtilKt.getSSHJ_LOG();
                        boolean bl13 = false;
                        logger.debug("Called " + (this + ".sftp.rename(" + newAbsolutePath + ")") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(l2 - l) / 1000000.0) + " ms (" + string2 + ")");
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                sshjRemoteFileObject.lstat.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl14 = false;
            object = "File " + string + ": " + ((Throwable)object).getMessage();
            Response.StatusCode statusCode = sFTPException.getStatusCode();
            switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                case 1: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                    }
                    UtilKt.getSSHJ_LOG().info((String)object);
                    break;
                }
                case 2: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                    }
                    UtilKt.getSSHJ_LOG().warn((String)object);
                    break;
                }
                default: {
                    UtilKt.getSSHJ_LOG().warn((String)object, (Throwable)sFTPException);
                }
            }
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl15 = false;
            String string3 = "File " + string + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string3, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string3, iOException);
        }
    }

    @Override
    public long getLastModifiedTime() {
        return this.lstat.getOrThrow().getMtime();
    }

    @Override
    public void setLastModifiedTime(long value) {
        this.r((Function1<? super FileAttributes.Builder, Unit>)((Function1)arg_0 -> SshjRemoteFileObject.r(this, value, arg_0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public String canonicalPath() {
        String string;
        String string2 = this.path;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = bl;
        boolean bl5 = bl2;
        boolean bl6 = false;
        try {
            String string3;
            String string4;
            boolean bl7 = false;
            boolean bl8 = false;
            if (!UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                boolean bl9 = false;
                string4 = this.sftp.canonicalize(this.path());
            } else {
                String string5;
                long l = System.nanoTime();
                String string6 = "ok";
                try {
                    boolean bl10 = false;
                    string5 = this.sftp.canonicalize(this.path());
                }
                catch (Throwable throwable) {
                    string6 = "exception";
                    throw throwable;
                }
                finally {
                    long l2 = System.nanoTime();
                    Logger logger = UtilKt.getSSHJ_LOG();
                    boolean bl11 = false;
                    logger.debug("Called " + (this + ".sftp.canonicalize()") + " in " + SshjRemoteFileObjectKt.access$getMeasureCallDecimalFormat$p().format((double)(l2 - l) / 1000000.0) + " ms (" + string6 + ")");
                }
                string4 = string5;
            }
            String string7 = string3 = string4;
            boolean bl12 = false;
            UtilKt.getSSHJ_LOG().debug("Canonical path of " + this.path + " is " + string7);
            string = string3;
        }
        catch (SFTPException sFTPException) {
            Object object = (IOException)((Object)sFTPException);
            boolean bl13 = false;
            object = "File " + string2 + ": " + ((Throwable)object).getMessage();
            Response.StatusCode statusCode = sFTPException.getStatusCode();
            switch (statusCode == null ? -1 : UtilKt.WhenMappings.$EnumSwitchMapping$0[statusCode.ordinal()]) {
                case 1: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                    }
                    UtilKt.getSSHJ_LOG().info((String)object);
                    break;
                }
                case 2: {
                    if (UtilKt.getSSHJ_LOG().isDebugEnabled()) {
                        UtilKt.getSSHJ_LOG().debug((String)object, (Throwable)sFTPException);
                    }
                    UtilKt.getSSHJ_LOG().warn((String)object);
                    break;
                }
                default: {
                    UtilKt.getSSHJ_LOG().warn((String)object, (Throwable)sFTPException);
                }
            }
            throw SftpChannelException.Companion.create(sFTPException.getStatusCode().getCode(), (String)object, sFTPException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            boolean bl14 = false;
            String string8 = "File " + string2 + ": " + iOException2.getMessage();
            UtilKt.getSSHJ_LOG().warn(string8, (Throwable)iOException);
            throw SftpChannelException.Companion.create(-1, string8, iOException);
        }
        String string9 = string;
        Intrinsics.checkNotNull((Object)string9);
        return string9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> T r(Function0<? extends T> function0) {
        Object object;
        boolean bl = false;
        try {
            object = function0.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.lstat.clear();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    @Override
    public void clearCachedData() {
        this.lstat.clear();
    }

    @NotNull
    public String toString() {
        return "SshjRemoteFileObject@" + UtilKt.hexId(this) + "(path " + this.path + ", owned by " + this.ownerName + ")";
    }

    private static final CharSequence r(RemoteResourceInfo remoteResourceInfo) {
        return remoteResourceInfo.getName() + " " + remoteResourceInfo.getAttributes();
    }

    private static final Unit r(int n, FileAttributes.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"$this$updateFileAttributes");
        builder.withPermissions(n);
        return Unit.INSTANCE;
    }

    private static final Unit r(SshjRemoteFileObject sshjRemoteFileObject, long l, FileAttributes.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"$this$updateFileAttributes");
        builder.withAtimeMtime(sshjRemoteFileObject.lstat.getOrThrow().getAtime(), l);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Response.StatusCode.values().length];
            try {
                nArray[Response.StatusCode.NO_SUCH_FILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Response.StatusCode.FAILURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

