/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj.channels;

import com.intellij.ssh.SshConnectionService;
import com.intellij.ssh.impl.sshj.UtilKt;
import com.intellij.ssh.impl.sshj.channels.SshAgentForwardingChannelOpener;
import com.intellij.ssh.impl.sshj.tunnels.SingleTunnelBrokerKt;
import com.jcraft.jsch.agentproxy.Connector;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.SSHPacket;
import net.schmizz.sshj.connection.Connection;
import net.schmizz.sshj.connection.channel.OpenFailException;
import net.schmizz.sshj.connection.channel.forwarded.AbstractForwardedChannel;
import net.schmizz.sshj.connection.channel.forwarded.ForwardedChannelOpener;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ssh/impl/sshj/channels/SshAgentForwardingChannelOpener;", "Lnet/schmizz/sshj/connection/channel/forwarded/ForwardedChannelOpener;", "sshClient", "Lnet/schmizz/sshj/SSHClient;", "threadPoolExecutor", "Ljava/util/concurrent/ExecutorService;", "label", "", "SshAgentForwardingChannelOpener", "(Lnet/schmizz/sshj/SSHClient;Ljava/util/concurrent/ExecutorService;Ljava/lang/String;)V", "getChannelType", "handleOpen", "", "buf", "Lnet/schmizz/sshj/common/SSHPacket;", "r", "agent", "Lcom/jcraft/jsch/agentproxy/Connector;", "channel", "Lnet/schmizz/sshj/connection/channel/forwarded/AbstractForwardedChannel;", "intellij.platform.ssh"})
public final class SshAgentForwardingChannelOpener
implements ForwardedChannelOpener {
    @NotNull
    private final SSHClient sshClient;
    @NotNull
    private final ExecutorService threadPoolExecutor;
    @NotNull
    private final String label;

    public SshAgentForwardingChannelOpener(@NotNull SSHClient sshClient, @NotNull ExecutorService threadPoolExecutor, @NotNull String label) {
        Intrinsics.checkNotNullParameter((Object)sshClient, (String)"sshClient");
        Intrinsics.checkNotNullParameter((Object)threadPoolExecutor, (String)"threadPoolExecutor");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        this.sshClient = sshClient;
        this.threadPoolExecutor = threadPoolExecutor;
        this.label = label;
    }

    @NotNull
    public String getChannelType() {
        return "auth-agent@openssh.com";
    }

    public void handleOpen(@NotNull SSHPacket buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int n = buf.readUInt32AsInt();
        long l = buf.readUInt32();
        long l2 = buf.readUInt32();
        Pair<Connector, String> pair = this.sshClient.getConnection();
        String string = this.getChannelType();
        AbstractForwardedChannel abstractForwardedChannel = new AbstractForwardedChannel(n, l, l2, (Connection)pair, string){};
        Pair<Connector, String> pair2 = SshConnectionService.Companion.getInstance().getAgentProxyConnectorFactory().get();
        if (pair2 == null) {
            SshAgentForwardingChannelOpener sshAgentForwardingChannelOpener = this;
            boolean bl = false;
            UtilKt.getSSHJ_LOG().debug("Rejecting SSH agent forwarding for " + sshAgentForwardingChannelOpener.label + ": No SSH agent is available");
            abstractForwardedChannel.reject(OpenFailException.Reason.ADMINISTRATIVELY_PROHIBITED, "open failed");
            return;
        }
        pair = pair2;
        string = (Connector)pair.component1();
        String string2 = (String)pair.component2();
        UtilKt.getSSHJ_LOG().debug("Confirming SSH agent forwarding for " + this.label + " to " + string2);
        abstractForwardedChannel.confirm();
        this.threadPoolExecutor.execute(() -> SshAgentForwardingChannelOpener.r(this, (Connector)string, abstractForwardedChannel));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void r(Connector connector, AbstractForwardedChannel abstractForwardedChannel) {
        try {
            Closeable closeable = (Closeable)abstractForwardedChannel;
            Throwable throwable = null;
            try {
                AbstractForwardedChannel abstractForwardedChannel2 = (AbstractForwardedChannel)closeable;
                boolean bl = false;
                DataInputStream dataInputStream = new DataInputStream(abstractForwardedChannel.getInputStream());
                DataOutputStream dataOutputStream = new DataOutputStream(abstractForwardedChannel.getOutputStream());
                while (abstractForwardedChannel.isOpen()) {
                    UtilKt.forwardOneQuery(connector, dataInputStream, dataOutputStream);
                }
                abstractForwardedChannel2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            UtilKt.getSSHJ_LOG().debug("SSH agent forwarding for " + this.label + " has been successfully closed");
        }
        catch (Throwable throwable) {
            if (!abstractForwardedChannel.isOpen() || throwable instanceof IOException && SingleTunnelBrokerKt.getCausedByConnectionLoss((IOException)throwable)) {
                UtilKt.getSSHJ_LOG().info("SSH agent forwarding for " + this.label + " has been suddenly closed: " + throwable);
            }
            UtilKt.getSSHJ_LOG().error("Unexpected error in SSH agent forwarding for " + this.label, throwable);
        }
    }

    private static final void r(SshAgentForwardingChannelOpener sshAgentForwardingChannelOpener, Connector connector, handleOpen.channel.1 var2_2) {
        sshAgentForwardingChannelOpener.r(connector, var2_2);
    }
}

