/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui;

import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.ActionManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0007H\u0007\u001a\u0010\u0010\b\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u001a\u0018\u0010\t\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b\"\u0011\u0010\u0000\u001a\u00020\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\f"}, d2={"KubernetesNotificationGroup", "Lcom/intellij/notification/NotificationGroup;", "getKubernetesNotificationGroup", "()Lcom/intellij/notification/NotificationGroup;", "createModelLoadingErrorNotification", "Lcom/intellij/notification/Notification;", "errorMessage", "", "createKubernetesErrorNotification", "createKubernetesNotification", "type", "Lcom/intellij/notification/NotificationType;", "intellij.clouds.kubernetes"})
public final class NotificationsKt {
    @NotNull
    public static final NotificationGroup getKubernetesNotificationGroup() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Kubernetes.General");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getNotificationGroup(...)");
        return notificationGroup;
    }

    @ApiStatus.Internal
    @NotNull
    public static final Notification createModelLoadingErrorNotification(@Nls @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Notification notification = NotificationsKt.createKubernetesErrorNotification(errorMessage).setSubtitle(KubernetesBundle.message("KubernetesNotification.model.loading.subtitle", new Object[0])).addAction(ActionManager.getInstance().getAction("Kubernetes.ConfigureExternalSchema"));
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"addAction(...)");
        return notification;
    }

    @NotNull
    public static final Notification createKubernetesErrorNotification(@Nls @NotNull String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        return NotificationsKt.createKubernetesNotification(errorMessage, NotificationType.ERROR);
    }

    @NotNull
    public static final Notification createKubernetesNotification(@Nls @NotNull String errorMessage, @NotNull NotificationType type) {
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        NotificationGroup notificationGroup = NotificationsKt.getKubernetesNotificationGroup();
        String string = KubernetesBundle.message(KubernetesBundle.message("KubernetesNotification.title", new Object[0]), new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return notificationGroup.createNotification(string, errorMessage, type);
    }
}

