/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.javaee.web.WebBundle;
import com.intellij.javaee.web.model.xml.MimeMapping;
import com.intellij.javaee.web.model.xml.WebApp;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class MimeTypeInspection
extends DomElementsInspection<WebApp> {
    @NonNls
    private final Pattern myPattern = Pattern.compile("[^\\p{Cc}^\\s]+/[^\\p{Cc}^\\s]+");

    public MimeTypeInspection() {
        super(WebApp.class, new Class[0]);
    }

    public void checkFileElement(@NotNull DomFileElement<WebApp> domFileElement, @NotNull DomElementAnnotationHolder holder) {
        if (domFileElement == null) {
            MimeTypeInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            MimeTypeInspection.$$$reportNull$$$0(1);
        }
        for (MimeMapping mapping : ((WebApp)domFileElement.getRootElement()).getMimeMappings()) {
            GenericDomValue mimeType = mapping.getMimeType();
            String stringValue = mimeType.getStringValue();
            if (stringValue == null || this.myPattern.matcher(stringValue).matches()) continue;
            holder.createProblem((DomElement)mimeType, WebBundle.message("inspection.javaee.web.xml.mime.type.message", stringValue), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "domFileElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/javaee/web/highlighting/MimeTypeInspection";
        objectArray[2] = "checkFileElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

