/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.provider.AbstractFileSystem;

public final class VFS {
    private static FileSystemManager instance;

    private VFS() {
    }

    public static synchronized void close() {
        if (instance != null) {
            instance.close();
            instance = null;
        }
    }

    public static synchronized FileSystemManager getManager() throws FileSystemException {
        if (instance == null) {
            instance = VFS.reset();
        }
        return instance;
    }

    public static FileSystemManager reset() throws FileSystemException {
        VFS.close();
        instance = VFS.createFileSystemManager("org.apache.commons.vfs2.impl.StandardFileSystemManager");
        return instance;
    }

    private static FileSystemManager createFileSystemManager(String managerClassName) throws FileSystemException {
        try {
            Class<?> clazz = Class.forName(managerClassName);
            FileSystemManager manager = (FileSystemManager)clazz.newInstance();
            if (manager instanceof AbstractFileSystem) {
                ((AbstractFileSystem)((Object)manager)).init();
            } else {
                Method method = MethodUtils.getMatchingMethod(clazz, (String)"init", (Class[])new Class[0]);
                if (method != null) {
                    method.invoke((Object)manager, (Object[])null);
                }
            }
            return manager;
        }
        catch (InvocationTargetException e) {
            throw new FileSystemException("vfs/create-manager.error", (Object)managerClassName, e.getTargetException());
        }
        catch (Exception e) {
            throw new FileSystemException("vfs/create-manager.error", (Object)managerClassName, (Throwable)e);
        }
    }

    public static synchronized void setManager(FileSystemManager manager) {
        instance = manager;
    }
}

