/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.sftp;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SocketFactory;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.time.Duration;
import java.util.Properties;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.time.DurationUtils;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import org.apache.commons.vfs2.provider.sftp.IdentityRepositoryFactory;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.sftp.SftpStreamProxy;

public final class SftpClientFactory {
    private static final String SSH_DIR_NAME = ".ssh";

    private SftpClientFactory() {
    }

    public static Session createConnection(String hostname, int port, char[] username, char[] password, FileSystemOptions fileSystemOptions) throws FileSystemException {
        Session session;
        JSch jsch = new JSch();
        SftpFileSystemConfigBuilder builder = SftpFileSystemConfigBuilder.getInstance();
        File knownHostsFile = builder.getKnownHosts(fileSystemOptions);
        IdentityInfo[] identities = builder.getIdentityInfo(fileSystemOptions);
        IdentityRepositoryFactory repositoryFactory = builder.getIdentityRepositoryFactory(fileSystemOptions);
        File sshDir = SftpClientFactory.findSshDir();
        SftpClientFactory.setKnownHosts(jsch, sshDir, knownHostsFile);
        if (repositoryFactory != null) {
            jsch.setIdentityRepository(repositoryFactory.create(jsch));
        }
        SftpClientFactory.addIdentities(jsch, sshDir, identities);
        try {
            Integer keepAliveCountMax;
            Integer keepAliveTimeout;
            SocketFactory socketFactory;
            String proxyHost;
            String keyExchangeAlgorithm;
            String compression;
            String preferredAuthentications;
            UserInfo userInfo;
            Duration sessionTimeout;
            session = jsch.getSession(new String(username), hostname, port);
            if (password != null) {
                session.setPassword(new String(password));
            }
            if ((sessionTimeout = builder.getSessionTimeout(fileSystemOptions)) != null) {
                session.setTimeout(DurationUtils.toMillisInt((Duration)sessionTimeout));
            }
            if ((userInfo = builder.getUserInfo(fileSystemOptions)) != null) {
                session.setUserInfo(userInfo);
            }
            Properties config = new Properties();
            String strictHostKeyChecking = builder.getStrictHostKeyChecking(fileSystemOptions);
            if (strictHostKeyChecking != null) {
                config.setProperty("StrictHostKeyChecking", strictHostKeyChecking);
            }
            if ((preferredAuthentications = builder.getPreferredAuthentications(fileSystemOptions)) != null) {
                config.setProperty("PreferredAuthentications", preferredAuthentications);
            }
            if ((compression = builder.getCompression(fileSystemOptions)) != null) {
                config.setProperty("compression.s2c", compression);
                config.setProperty("compression.c2s", compression);
            }
            if ((keyExchangeAlgorithm = builder.getKeyExchangeAlgorithm(fileSystemOptions)) != null) {
                config.setProperty("kex", keyExchangeAlgorithm);
            }
            if ((proxyHost = builder.getProxyHost(fileSystemOptions)) != null) {
                int proxyPort = builder.getProxyPort(fileSystemOptions);
                SftpFileSystemConfigBuilder.ProxyType proxyType = builder.getProxyType(fileSystemOptions);
                ProxyHTTP proxy = null;
                if (SftpFileSystemConfigBuilder.PROXY_HTTP.equals(proxyType)) {
                    proxy = SftpClientFactory.createProxyHTTP(proxyHost, proxyPort);
                } else if (SftpFileSystemConfigBuilder.PROXY_SOCKS5.equals(proxyType)) {
                    proxy = SftpClientFactory.createProxySOCKS5(proxyHost, proxyPort);
                } else if (SftpFileSystemConfigBuilder.PROXY_STREAM.equals(proxyType)) {
                    proxy = SftpClientFactory.createStreamProxy(proxyHost, proxyPort, fileSystemOptions, builder);
                }
                if (proxy != null) {
                    session.setProxy((Proxy)proxy);
                }
            }
            if (!config.isEmpty()) {
                session.setConfig(config);
            }
            if ((socketFactory = builder.getSocketFactory(fileSystemOptions)) != null) {
                session.setSocketFactory(socketFactory);
            }
            if ((keepAliveTimeout = builder.getKeepAliveTimeout(fileSystemOptions)) != null) {
                session.setServerAliveInterval(keepAliveTimeout.intValue());
            }
            if ((keepAliveCountMax = builder.getKeepAliveMaxCount(fileSystemOptions)) != null) {
                session.setServerAliveCountMax(keepAliveCountMax.intValue());
            }
            session.setDaemonThread(true);
            session.connect();
        }
        catch (Exception exc) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", (Throwable)exc, hostname);
        }
        return session;
    }

    public static void addIdentities(JSch jsch, File sshDir, IdentityInfo[] identities) throws FileSystemException {
        if (identities != null) {
            for (IdentityInfo info : identities) {
                SftpClientFactory.addIndentity(jsch, info);
            }
        } else {
            File privateKeyFile = new File(sshDir, "id_rsa");
            if (privateKeyFile.isFile() && privateKeyFile.canRead()) {
                SftpClientFactory.addIndentity(jsch, new IdentityInfo(privateKeyFile));
            }
        }
    }

    private static void addIndentity(JSch jsch, IdentityInfo info) throws FileSystemException {
        try {
            String privateKeyFile = info.getPrivateKey() != null ? info.getPrivateKey().getAbsolutePath() : null;
            String publicKeyFile = info.getPublicKey() != null ? info.getPublicKey().getAbsolutePath() : null;
            jsch.addIdentity(privateKeyFile, publicKeyFile, info.getPassPhrase());
        }
        catch (JSchException e) {
            throw new FileSystemException("vfs.provider.sftp/load-private-key.error", (Object)info, (Throwable)e);
        }
    }

    public static void setKnownHosts(JSch jsch, File sshDir, File knownHostsFile) throws FileSystemException {
        try {
            if (knownHostsFile != null) {
                jsch.setKnownHosts(knownHostsFile.getAbsolutePath());
            } else {
                knownHostsFile = new File(sshDir, "known_hosts");
                if (knownHostsFile.isFile() && knownHostsFile.canRead()) {
                    jsch.setKnownHosts(knownHostsFile.getAbsolutePath());
                }
            }
        }
        catch (JSchException e) {
            throw new FileSystemException("vfs.provider.sftp/known-hosts.error", (Object)knownHostsFile.getAbsolutePath(), (Throwable)e);
        }
    }

    public static Proxy createStreamProxy(String proxyHost, int proxyPort, FileSystemOptions fileSystemOptions, SftpFileSystemConfigBuilder builder) {
        String proxyUser = builder.getProxyUser(fileSystemOptions);
        String proxyPassword = builder.getProxyPassword(fileSystemOptions);
        FileSystemOptions proxyOptions = builder.getProxyOptions(fileSystemOptions);
        String proxyCommand = builder.getProxyCommand(fileSystemOptions);
        return new SftpStreamProxy(proxyCommand, proxyUser, proxyHost, proxyPort, proxyPassword, proxyOptions);
    }

    public static ProxySOCKS5 createProxySOCKS5(String proxyHost, int proxyPort) {
        return proxyPort == 0 ? new ProxySOCKS5(proxyHost) : new ProxySOCKS5(proxyHost, proxyPort);
    }

    public static ProxyHTTP createProxyHTTP(String proxyHost, int proxyPort) {
        return proxyPort == 0 ? new ProxyHTTP(proxyHost) : new ProxyHTTP(proxyHost, proxyPort);
    }

    public static File findSshDir() {
        File sshDir;
        String sshDirPath = System.getProperty("vfs.sftp.sshdir");
        if (sshDirPath != null && (sshDir = new File(sshDirPath)).exists()) {
            return sshDir;
        }
        sshDir = new File(System.getProperty("user.home"), SSH_DIR_NAME);
        if (sshDir.exists()) {
            return sshDir;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            String userName = System.getProperty("user.name");
            sshDir = new File("C:\\cygwin\\home\\" + userName + "\\" + SSH_DIR_NAME);
            if (sshDir.exists()) {
                return sshDir;
            }
        }
        return new File("");
    }
}

