/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage.backend;

import com.intellij.database.dataSource.srcStorage.DbSrcStorageDsMetadata;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendFiles;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendUtils;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcBackendZipWriter;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.backend.DbSrcZipFile;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.GuardedRef;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class DbSrcBackendZipData {
    private static final Logger LOG = Logger.getInstance(DbSrcBackendZipData.class);
    private final Map<ObjectPath, DirInfo> myStructure;
    private final Map<ObjectPath, FileInfo> myFileStamps;
    private final ObjectPath myRoot;
    private final int myRootDepth;
    private final DbSrcBackendFiles myFiles;
    private final DbSrcBackendZipWriter myWriter;
    private volatile boolean myLoaded;

    public DbSrcBackendZipData(@NotNull String path, @NotNull ObjectPath root, @NotNull DbSrcBackendFiles files) {
        if (path == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(0);
        }
        if (root == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(1);
        }
        if (files == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(2);
        }
        this.myStructure = new HashMap<ObjectPath, DirInfo>();
        this.myFileStamps = new HashMap<ObjectPath, FileInfo>();
        this.myWriter = new DbSrcBackendZipWriter(path, this::scheduleClose);
        this.myRoot = root;
        this.myRootDepth = ObjectPaths.getLength((ObjectPath)root);
        this.myFiles = files;
        this.myLoaded = !this.myWriter.isExists();
    }

    private void scheduleClose() {
        LazyData.ourCloseQueue.queue(new Update(this, false){

            public void run() {
                try (DbSrcBackendFiles.Locker lock = DbSrcBackendZipData.this.myFiles.writeLock();){
                    if (DbSrcBackendZipData.this.myWriter.canClose()) {
                        DbSrcBackendZipData.this.closeWriter();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build() {
        try (DbSrcBackendFiles.Locker lock = this.myFiles.writeLock();){
            if (this.myLoaded) {
                return;
            }
            if (!this.myWriter.isExists()) {
                this.myLoaded = true;
                return;
            }
            try (GuardedRef<DbSrcZipFile> zip = this.myWriter.openZip();){
                Map<ObjectPath, DirInfo> map = this.myStructure;
                synchronized (map) {
                    this.fillStructure((DbSrcZipFile)zip.get(), this.extractNamesMapping((DbSrcZipFile)zip.get()));
                }
            }
            catch (IOException e) {
                LOG.warn("ZipData build failed", (Throwable)e);
            }
            finally {
                this.myLoaded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void list(@Nullable ObjectPath object, @Nullable ObjectKind group, @NotNull DbSrcStorage.ListingConsumer consumer) {
        if (consumer == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(3);
        }
        ArrayList<ObjectPath> dirs = new ArrayList<ObjectPath>();
        ArrayList<ObjectPath> files = new ArrayList<ObjectPath>();
        Iterator iterator = this.myStructure;
        synchronized (iterator) {
            DirInfo info = this.getDirInfo(object);
            if (info == null) {
                return;
            }
            for (ObjectPath dir : info.dirs) {
                if (group != null && dir.kind != group) continue;
                dirs.add(dir);
            }
            for (ObjectPath file : info.files) {
                if (group != null && file.kind != group) continue;
                files.add(file);
            }
        }
        for (ObjectPath dir : dirs) {
            consumer.consume(dir, DbSrcBackendUtils.SrcType.FOLDER);
        }
        for (ObjectPath file : files) {
            consumer.consume(file, DbSrcBackendUtils.SrcType.ORIGINAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listGroups(@Nullable ObjectPath object, @NotNull Consumer<? super ObjectKind> consumer) {
        if (consumer == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(4);
        }
        ArrayList<ObjectKind> kinds = new ArrayList<ObjectKind>();
        Map<ObjectPath, DirInfo> map = this.myStructure;
        synchronized (map) {
            DirInfo info = this.getDirInfo(object);
            if (info == null) {
                return;
            }
            for (ObjectPath dir : info.dirs) {
                kinds.add(dir.kind);
            }
            for (ObjectPath file : info.files) {
                kinds.add(file.kind);
            }
        }
        for (ObjectKind kind : kinds) {
            consumer.consume((Object)kind);
        }
    }

    public boolean hasChildren(@Nullable ObjectPath object) {
        DirInfo info = this.getDirInfo(object);
        return info != null && (!info.dirs.isEmpty() || !info.files.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasGroup(@Nullable ObjectPath object, @NotNull ObjectKind group) {
        if (group == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(5);
        }
        Map<ObjectPath, DirInfo> map = this.myStructure;
        synchronized (map) {
            DirInfo info = this.getDirInfo(object);
            if (info == null) {
                return false;
            }
            for (ObjectPath dir : info.dirs) {
                if (dir.kind != group) continue;
                return true;
            }
            for (ObjectPath file : info.files) {
                if (file.kind != group) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putMetaData(@NotNull ObjectPath object, @NotNull DbSrcStorageDsMetadata.MetaData metaData) throws IOException {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(6);
        }
        if (metaData == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(7);
        }
        StringBuilder path = new StringBuilder("/");
        DbSrcBackendUtils.appendPath(path, object, this.myRootDepth, "/");
        path.append(".meta");
        try (DbSrcBackendFiles.Locker lock = this.myFiles.writeLock();
             GuardedRef<DbSrcZipFile> ref = this.myWriter.openZip();){
            byte[] data = DbSrcBackendUtils.serializeMetaData(object, metaData);
            ((DbSrcZipFile)ref.get()).putData(path.toString(), data, System.currentTimeMillis(), DbSrcBackendZipData.getDisplayName(object));
            this.myFiles.putMetaDataToCache(object, metaData);
            Map<ObjectPath, DirInfo> map = this.myStructure;
            synchronized (map) {
                DirInfo info = this.getOrCreateDirInfo(object.parent);
                if (info != null) {
                    info.dirs.add(object);
                }
            }
        }
        finally {
            this.myFiles.getListener().dirChanged(object, false, false);
            this.myFiles.getListener().fileChanged(object, DbSrcBackendUtils.SrcType.ORIGINAL);
        }
    }

    @Nullable
    private DbSrcStorageDsMetadata.MetaData getMetaData(@NotNull ObjectPath object) {
        DbSrcStorageDsMetadata.MetaData metaData;
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(8);
        }
        if ((metaData = this.myFiles.getCachedMetaData(object)) == null && (metaData = this.readMetaData(object)) != null) {
            this.myFiles.putMetaDataToCache(object, metaData);
        }
        return metaData;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public DbSrcStorageDsMetadata.MetaData readMetaData(@NotNull ObjectPath object) {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(9);
        }
        if (!this.myWriter.isExists()) {
            return null;
        }
        StringBuilder path = new StringBuilder("/");
        DbSrcBackendUtils.appendPath(path, object, this.myRootDepth, "/");
        path.append(".meta");
        try (DbSrcBackendFiles.Locker lock = this.myFiles.readLock();){
            DbSrcStorageDsMetadata.MetaData metaData;
            block20: {
                byte[] data;
                GuardedRef<DbSrcZipFile> ref;
                block18: {
                    DbSrcStorageDsMetadata.MetaData metaData2;
                    block19: {
                        ref = this.myWriter.openZip();
                        try {
                            data = this.getEntryData((DbSrcZipFile)ref.get(), path.toString());
                            if (data != null) break block18;
                            metaData2 = null;
                            if (ref == null) break block19;
                        }
                        catch (Throwable throwable) {
                            if (ref != null) {
                                try {
                                    ref.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        ref.close();
                    }
                    return metaData2;
                }
                metaData = DbSrcBackendUtils.deserializeMetaData(new ByteArrayInputStream(data));
                if (ref == null) break block20;
                ref.close();
            }
            return metaData;
        }
        catch (IOException e) {
            return null;
        }
    }

    private synchronized byte[] getEntryData(DbSrcZipFile file, String name) throws IOException {
        return file.getData(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putContent(@NotNull ObjectPath object, byte @Nullable [] content) throws IOException {
        block25: {
            if (object == null) {
                DbSrcBackendZipData.$$$reportNull$$$0(10);
            }
            StringBuilder path = new StringBuilder("/");
            DbSrcBackendUtils.appendPath(path, object, this.myRootDepth, "/");
            path.append(".sql");
            try (DbSrcBackendFiles.Locker lock = this.myFiles.writeLock();
                 GuardedRef<DbSrcZipFile> ref = this.myWriter.openZip();){
                if (content != null) {
                    String comment = DbSrcBackendZipData.getDisplayName(object);
                    ((DbSrcZipFile)ref.get()).putData(path.toString(), content, System.currentTimeMillis(), comment);
                    Map<ObjectPath, DirInfo> map = this.myStructure;
                    synchronized (map) {
                        DirInfo info = this.getOrCreateDirInfo(object.parent);
                        this.myFileStamps.put(object, new FileInfo(System.currentTimeMillis(), content.length));
                        if (info != null) {
                            info.files.add(object);
                        }
                        break block25;
                    }
                }
                ((DbSrcZipFile)ref.get()).eraseEntry(path.toString());
                Map<ObjectPath, DirInfo> map = this.myStructure;
                synchronized (map) {
                    DirInfo info = this.getDirInfo(object.parent);
                    if (info != null) {
                        info.files.remove(object);
                    }
                    this.myFileStamps.remove(object);
                }
            }
            finally {
                this.myFiles.getListener().fileChanged(object, DbSrcBackendUtils.SrcType.ORIGINAL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAll(@NotNull ObjectPath from, @NotNull DbSrcBackendZipData toData, @NotNull ObjectPath to, boolean physical) throws IOException {
        if (from == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(11);
        }
        if (toData == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(12);
        }
        if (to == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(13);
        }
        if (!this.exists(from)) {
            return;
        }
        try (DbSrcBackendFiles.Locker fromLock = this.myFiles.writeLock();
             DbSrcBackendFiles.Locker toLock = toData.myFiles.writeLock();){
            this.copyFile(from, toData, to);
            this.copyDir(from, toData, to, false);
            this.dropObjectInner(from, physical);
        }
        finally {
            this.myFiles.getListener().fileMoved(from, to);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyDir(ObjectPath from, DbSrcBackendZipData toData, ObjectPath to, boolean meta) {
        DirInfo dirInfo;
        if (meta) {
            this.copyMeta(from, toData, to);
        }
        Iterator<ObjectPath> iterator = this.myStructure;
        synchronized (iterator) {
            dirInfo = this.myStructure.get(from);
        }
        if (dirInfo == null) {
            return;
        }
        for (ObjectPath file : dirInfo.files) {
            this.copyFile(file, toData, ObjectPath.copyUnder((ObjectPath)file, (ObjectPath)to));
        }
        for (ObjectPath dir : dirInfo.dirs) {
            this.copyDir(dir, toData, ObjectPath.copyUnder((ObjectPath)dir, (ObjectPath)to), !dirInfo.files.contains(dir));
        }
    }

    private void copyFile(ObjectPath from, DbSrcBackendZipData toData, ObjectPath to) {
        this.copyMeta(from, toData, to);
        try {
            byte[] content = this.getContent(from);
            if (content != null) {
                toData.putContent(to, content);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to move content", (Throwable)e);
        }
    }

    private void copyMeta(ObjectPath from, DbSrcBackendZipData toData, ObjectPath to) {
        DbSrcStorageDsMetadata.MetaData data = this.getMetaData(from);
        if (data != null) {
            try {
                toData.putMetaData(to, data);
            }
            catch (IOException e) {
                LOG.warn("Failed to move meta data", (Throwable)e);
            }
        }
    }

    private static String getDisplayName(@NotNull ObjectPath object) {
        String d;
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(14);
        }
        return (d = object.getIdentity()) != null ? object.getName() + "." + d : object.getName();
    }

    @NotNull
    public ObjectPath findCascadeRemovalRoot(@NotNull ObjectPath object) {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(15);
        }
        return this.findCascadeRemovalRootImpl(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private ObjectPath findCascadeRemovalRootImpl(@NotNull ObjectPath object) {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(16);
        }
        if (object.equals(this.myRoot)) {
            ObjectPath objectPath = object;
            if (objectPath != null) return objectPath;
            DbSrcBackendZipData.$$$reportNull$$$0(17);
            return objectPath;
        }
        ObjectPath parent = object.parent;
        if (parent == null) {
            ObjectPath objectPath = object;
            if (objectPath != null) return objectPath;
            DbSrcBackendZipData.$$$reportNull$$$0(18);
            return objectPath;
        }
        Map<ObjectPath, DirInfo> map = this.myStructure;
        // MONITORENTER : map
        if (this.hasOtherChild(parent, object)) {
            ObjectPath objectPath = object;
            // MONITOREXIT : map
            if (objectPath != null) return objectPath;
            DbSrcBackendZipData.$$$reportNull$$$0(19);
            return objectPath;
        }
        if (parent.equals(this.myRoot)) {
            ObjectPath objectPath = parent;
            // MONITOREXIT : map
            if (objectPath != null) return objectPath;
            DbSrcBackendZipData.$$$reportNull$$$0(20);
            return objectPath;
        }
        if (this.myFileStamps.get(parent) != null) {
            ObjectPath objectPath = object;
            // MONITOREXIT : map
            if (objectPath != null) return objectPath;
            DbSrcBackendZipData.$$$reportNull$$$0(21);
            return objectPath;
        }
        // MONITOREXIT : map
        if (((DbSrcStorageDsMetadata.MetaData)ObjectUtils.chooseNotNull((Object)this.getMetaData(object), (Object)DbSrcStorageDsMetadata.MetaData.EMPTY)).equals((Object)DbSrcStorageDsMetadata.MetaData.EMPTY)) return this.findCascadeRemovalRootImpl(parent);
        ObjectPath objectPath = object;
        if (objectPath != null) return objectPath;
        DbSrcBackendZipData.$$$reportNull$$$0(22);
        return objectPath;
    }

    private boolean hasOtherChild(@NotNull ObjectPath parent, @NotNull ObjectPath object) {
        DirInfo info;
        if (parent == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(23);
        }
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(24);
        }
        if ((info = this.myStructure.get(parent)) == null) {
            return false;
        }
        if (info.dirs.size() > 1 || info.files.size() > 1) {
            return true;
        }
        if (!info.dirs.isEmpty() && !info.dirs.contains(object)) {
            return true;
        }
        return !info.files.isEmpty() && !info.files.contains(object);
    }

    public byte @Nullable [] getContent(@NotNull ObjectPath object) throws IOException {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(25);
        }
        StringBuilder path = new StringBuilder("/");
        DbSrcBackendUtils.appendPath(path, object, this.myRootDepth, "/");
        path.append(".sql");
        try (DbSrcBackendFiles.Locker lock = this.myFiles.readLock();){
            byte[] byArray;
            block13: {
                GuardedRef<DbSrcZipFile> ref = this.myWriter.openZip();
                try {
                    byArray = this.getEntryData((DbSrcZipFile)ref.get(), path.toString());
                    if (ref == null) break block13;
                }
                catch (Throwable throwable) {
                    if (ref != null) {
                        try {
                            ref.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                ref.close();
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FileAttributes getSrcAttributes(@NotNull ObjectPath object) {
        FileInfo info;
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(26);
        }
        Map<ObjectPath, DirInfo> map = this.myStructure;
        synchronized (map) {
            info = this.myFileStamps.get(object);
        }
        if (info == null) {
            return null;
        }
        return new FileAttributes(false, false, false, false, info.size, info.stamp, !this.myWriter.isReadOnly(), FileAttributes.CaseSensitivity.SENSITIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropObject(@NotNull ObjectPath object) throws IOException {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(27);
        }
        if (!this.exists(object)) {
            return;
        }
        ObjectPath root = object;
        try (DbSrcBackendFiles.Locker lock = this.myFiles.writeLock();){
            if (object.equals(this.myRoot)) {
                this.myFiles.dropSrcAndMeta(object);
            }
            root = this.dropObjectInner(object, true);
        }
        finally {
            this.myFiles.getListener().dirChanged(root, false, true);
            this.myFiles.getListener().fileChanged(root, DbSrcBackendUtils.SrcType.ORIGINAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exists(@NotNull ObjectPath object) {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(28);
        }
        Map<ObjectPath, DirInfo> map = this.myStructure;
        synchronized (map) {
            return this.myStructure.containsKey(object) || this.myFileStamps.containsKey(object);
        }
    }

    @NotNull
    private ObjectPath dropObjectInner(@NotNull ObjectPath object, boolean physical) throws IOException {
        ObjectPath root;
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(29);
        }
        boolean childrenOnly = object != (root = this.findCascadeRemovalRoot(object));
        this.dropFromStructure(root, true, childrenOnly);
        if (physical) {
            this.clearSubEntries(root, childrenOnly);
        }
        this.myFiles.removeCachedMetaDataRec(root);
        ObjectPath objectPath = root;
        if (objectPath == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(30);
        }
        return objectPath;
    }

    private void clearSubEntries(@NotNull ObjectPath object, boolean childrenOnly) throws IOException {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(31);
        }
        String prefix = null;
        String src = null;
        String meta = null;
        if (!object.equals(this.myRoot)) {
            StringBuilder path = new StringBuilder("/");
            DbSrcBackendUtils.appendPath(path, object, this.myRootDepth, "/");
            int len = path.length();
            prefix = path.append("/").toString();
            path.setLength(len);
            src = path.append(".sql").toString();
            path.setLength(len);
            meta = path.append(".meta").toString();
        }
        try (GuardedRef<DbSrcZipFile> ref = this.myWriter.openZip();){
            DbSrcZipFile.It it = ((DbSrcZipFile)ref.get()).iterate();
            while (it.advance()) {
                String name = it.getName();
                if (prefix != null && !name.startsWith(prefix) && (childrenOnly || !name.equals(src)) && (childrenOnly || !name.equals(meta))) continue;
                it.drop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropFromStructure(@NotNull ObjectPath object, boolean dropFromParent, boolean childrenOnly) {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(32);
        }
        this.myFiles.putMetaDataToCache(object, null);
        Map<ObjectPath, DirInfo> map = this.myStructure;
        synchronized (map) {
            DirInfo info;
            if (!childrenOnly && dropFromParent && (info = this.myStructure.get(object.parent)) != null) {
                info.dirs.remove(object);
                info.files.remove(object);
            }
            DirInfo children = this.myStructure.remove(object);
            if (!childrenOnly) {
                this.myFileStamps.remove(object);
            }
            if (children != null) {
                for (ObjectPath file : children.files) {
                    this.myFiles.putMetaDataToCache(object, null);
                    this.myFileStamps.remove(file);
                }
                for (ObjectPath dir : children.dirs) {
                    this.dropFromStructure(dir, false, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeWriter() {
        block13: {
            try (DbSrcBackendFiles.Locker lock = this.myFiles.writeLock();){
                if (!this.myWriter.close() || !this.myWriter.isExists()) break block13;
                boolean empty = false;
                Map<ObjectPath, DirInfo> map = this.myStructure;
                synchronized (map) {
                    if (!this.hasChildren(this.myRoot)) {
                        this.myStructure.clear();
                        this.myFileStamps.clear();
                        this.myLoaded = false;
                        empty = true;
                    }
                }
                if (!empty) break block13;
                try {
                    this.myWriter.dropFile();
                    if (!this.myFiles.hasSrcOrMeta(this.myRoot)) {
                        this.myFiles.dropObject(this.myRoot, false, true);
                    }
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
    }

    private void fillStructure(@NotNull DbSrcZipFile file, @NotNull Map<CharSequence, Pair<String, String>> names) {
        if (file == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(33);
        }
        if (names == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(34);
        }
        HashMap<CharSequence, ObjectPath> paths = new HashMap<CharSequence, ObjectPath>();
        DbSrcZipFile.It it = file.iterate();
        while (it.advance()) {
            String name = it.getName();
            if (name.isEmpty() || name.charAt(0) != '/') continue;
            boolean dir = it.isDirectory();
            if (!dir) {
                if (!name.endsWith(".sql")) continue;
                name = StringUtil.trimEnd((String)name, (String)".sql");
            } else {
                if (DbSrcBackendZipData.isGroup(name)) continue;
                name = StringUtil.trimEnd((String)name, (String)"/");
            }
            ObjectPath path = this.createSrcPath(name, paths, names);
            if (path == null) {
                this.reportCorruptedEntry(name);
                continue;
            }
            DirInfo parentDir = this.getOrCreateDirInfo(Objects.requireNonNull(path.parent));
            if (dir) {
                parentDir.dirs.add(path);
            } else {
                this.myFileStamps.put(path, new FileInfo(it.getTimestamp(), it.getSize()));
                parentDir.files.add(path);
            }
            this.getOrCreateDirInfo(this.myRoot);
        }
    }

    private DirInfo getOrCreateDirInfo(@Nullable ObjectPath path) {
        if (path == null) {
            return null;
        }
        DirInfo info = this.myStructure.get(path);
        if (info == null) {
            DirInfo parent;
            if (!path.equals(this.myRoot) && (parent = this.getOrCreateDirInfo(path.parent)) != null) {
                parent.dirs.add(path);
            }
            info = new DirInfo();
            this.myStructure.put(path, info);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private DirInfo getDirInfo(@Nullable ObjectPath path) {
        if (path == null) {
            return null;
        }
        Map<ObjectPath, DirInfo> map = this.myStructure;
        synchronized (map) {
            return this.myStructure.get(path);
        }
    }

    private static boolean isGroup(String path) {
        return StringUtil.countChars((CharSequence)path, (char)'/') % 2 == 0;
    }

    @Nullable
    private ObjectPath createSrcPath(@NotNull CharSequence name, @NotNull Map<CharSequence, ObjectPath> paths, @NotNull Map<CharSequence, Pair<String, String>> namesMapping) {
        ObjectPath parent;
        ObjectPath path;
        if (name == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(35);
        }
        if (paths == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(36);
        }
        if (namesMapping == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(37);
        }
        if ((path = paths.get(name)) != null) {
            return path;
        }
        assert (StringUtil.startsWith((CharSequence)name, (CharSequence)"/"));
        Pair<String, String> realName = namesMapping.get(name);
        if (realName == null) {
            return null;
        }
        int ns = StringUtil.lastIndexOf((CharSequence)name, (char)'/', (int)0, (int)name.length());
        if (ns == -1) {
            return null;
        }
        int gs = StringUtil.lastIndexOf((CharSequence)name, (char)'/', (int)0, (int)ns);
        if (gs == -1) {
            return null;
        }
        String code = name.subSequence(gs + 1, ns).toString();
        ObjectKind kind = DbSrcUtilsCore.findKind((String)code);
        if (kind == null) {
            return null;
        }
        ObjectPath objectPath = parent = gs == 0 ? this.myRoot : this.createSrcPath(name.subSequence(0, gs), paths, namesMapping);
        if (parent == null) {
            return null;
        }
        path = DbSrcBackendUtils.createPath(parent, (String)realName.first, kind, (String)realName.second);
        paths.put(name, path);
        return path;
    }

    @NotNull
    public Map<CharSequence, Pair<String, String>> extractNamesMapping(DbSrcZipFile file) {
        HashMap<CharSequence, Pair<String, String>> names = new HashMap<CharSequence, Pair<String, String>>();
        DbSrcZipFile.It it = file.iterate();
        while (it.advance()) {
            Pair<String, String> fullName;
            String id;
            String name = it.getName();
            if (it.isDirectory() || !name.endsWith(".meta") || names.containsKey(id = StringUtil.trimEnd((String)name, (String)".meta"))) continue;
            try {
                fullName = DbSrcBackendUtils.extractNameAndIdentity(it.getData());
            }
            catch (IOException e) {
                LOG.warn("Failed to read " + name + " from " + this.getPath(), (Throwable)e);
                fullName = null;
            }
            if (fullName != null) {
                names.put(id, fullName);
                continue;
            }
            this.reportCorruptedEntry(name);
        }
        HashMap<CharSequence, Pair<String, String>> hashMap = names;
        if (hashMap == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(38);
        }
        return hashMap;
    }

    @NotNull
    public String getPath() {
        String string = this.myWriter.getPath();
        if (string == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(39);
        }
        return string;
    }

    private void reportCorruptedEntry(String name) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimestamp(@NotNull ObjectPath object, long timestamp) throws IOException {
        if (object == null) {
            DbSrcBackendZipData.$$$reportNull$$$0(40);
        }
        StringBuilder path = new StringBuilder("/");
        DbSrcBackendUtils.appendPath(path, object, this.myRootDepth, "/");
        path.append(".sql");
        try (DbSrcBackendFiles.Locker lock = this.myFiles.writeLock();
             GuardedRef<DbSrcZipFile> ref = this.myWriter.openZip();){
            String name = path.toString();
            byte[] data = ((DbSrcZipFile)ref.get()).getData(name);
            if (data == null) {
                return;
            }
            ((DbSrcZipFile)ref.get()).putData(name, data, timestamp, DbSrcBackendZipData.getDisplayName(object));
            Map<ObjectPath, DirInfo> map = this.myStructure;
            synchronized (map) {
                FileInfo info = this.myFileStamps.get(object);
                assert (info != null);
                this.myFileStamps.put(object, new FileInfo(timestamp, info.size));
            }
        }
        finally {
            this.myFiles.getListener().fileChanged(object, DbSrcBackendUtils.SrcType.ORIGINAL);
        }
    }

    @TestOnly
    public static void flushCloseQueue() {
        LazyData.ourCloseQueue.flush();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 17, 18, 19, 20, 21, 22, 30, 38, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaData";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toData";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 30: 
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackendZipData";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dataSource/srcStorage/backend/DbSrcBackendZipData";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findCascadeRemovalRootImpl";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "dropObjectInner";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "extractNamesMapping";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "listGroups";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasGroup";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "putMetaData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getMetaData";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readMetaData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "putContent";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "moveAll";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findCascadeRemovalRoot";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findCascadeRemovalRootImpl";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 30: 
            case 38: 
            case 39: {
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hasOtherChild";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getSrcAttributes";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "dropObject";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "dropObjectInner";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "clearSubEntries";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "dropFromStructure";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "fillStructure";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "createSrcPath";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "setTimestamp";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 17, 18, 19, 20, 21, 22, 30, 38, 39 -> new IllegalStateException(string);
        };
    }

    private static class LazyData {
        private static final MergingUpdateQueue ourCloseQueue = new MergingUpdateQueue("Close DbSrcBackend zips", 2000, true, null, (Disposable)ApplicationManager.getApplication().getMessageBus(), null, Alarm.ThreadToUse.POOLED_THREAD);

        private LazyData() {
        }

        static {
            ourCloseQueue.setRestartTimerOnAdd(true);
        }
    }

    public static final class DirInfo {
        public final Set<ObjectPath> dirs = new LinkedHashSet<ObjectPath>();
        public final Set<ObjectPath> files = new LinkedHashSet<ObjectPath>();
    }

    public static final class FileInfo {
        public final long stamp;
        public final long size;

        public FileInfo(long stamp, long size) {
            this.stamp = stamp - stamp % 2000L;
            this.size = size;
        }
    }
}

