/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.extractors.ImageInfo;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbTable;
import com.intellij.database.run.ui.DataGridDocumentationCommand;
import com.intellij.database.script.generator.dml.DmlTask;
import com.intellij.database.script.generator.dml.DmlTaskKt;
import com.intellij.database.script.generator.dml.DmlUtilKt;
import com.intellij.database.script.generator.dml.SelectGenerationResult;
import com.intellij.database.script.generator.dml.SelectTask;
import com.intellij.database.script.generator.dml.WrapInSelectResult;
import com.intellij.database.script.generator.dml.WrapInSelectTask;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.DatabaseDefinitionHelper;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Out;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.CollectionFactory;
import java.awt.Image;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DbDocumentationHelper {
    private static final AtomicLong ourImageCounter = new AtomicLong();
    private static final Map<String, ImageInfo> ourImageMap = CollectionFactory.createConcurrentSoftMap();
    private static final String DB_SUBSTITUTE_PREFIX = "dbe://db-substitute/";

    @Nullable
    public static Image resolveImageRef(@NotNull String imageSpec) {
        ImageInfo info;
        if (imageSpec == null) {
            DbDocumentationHelper.$$$reportNull$$$0(0);
        }
        return (info = ourImageMap.remove(imageSpec)) == null ? null : info.createImage();
    }

    @NotNull
    public static String createImageRefTag(@NotNull ImageInfo info, @Nullable String altStr) {
        if (info == null) {
            DbDocumentationHelper.$$$reportNull$$$0(1);
        }
        long id = ourImageCounter.incrementAndGet();
        String imageSpec = "http://img" + id;
        ourImageMap.put(imageSpec, info);
        String string = "<img src=\"" + imageSpec + "\" alt=\"" + altStr + "\" height=\"" + info.height + "\" width=\"" + info.width + "\" />";
        if (string == null) {
            DbDocumentationHelper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nls
    public static String getCountCommand(boolean refresh) {
        @NlsSafe String space = "&nbsp&nbsp";
        return space + DatabaseBundle.message((String)"documentation.click.to.count", (Object[])new Object[]{DbDocumentationHelper.dbSubstituteUrl(DataGridDocumentationCommand.COUNT.code()), refresh ? 1 : 0});
    }

    @NotNull
    public static String dbSubstituteUrl(@NotNull String section) {
        if (section == null) {
            DbDocumentationHelper.$$$reportNull$$$0(3);
        }
        String string = DB_SUBSTITUTE_PREFIX + section;
        if (string == null) {
            DbDocumentationHelper.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public static String extractDbSubstituteSection(@NotNull String url) {
        if (url == null) {
            DbDocumentationHelper.$$$reportNull$$$0(5);
        }
        return url.startsWith(DB_SUBSTITUTE_PREFIX) ? url.substring(DB_SUBSTITUTE_PREFIX.length()) : null;
    }

    @NlsSafe
    @NotNull
    public static String sectionStart(@NotNull DataGridDocumentationCommand command) {
        if (command == null) {
            DbDocumentationHelper.$$$reportNull$$$0(6);
        }
        return DbDocumentationHelper.sectionStart(command.code());
    }

    @NlsSafe
    @NotNull
    public static String sectionStart(@NotNull String section) {
        if (section == null) {
            DbDocumentationHelper.$$$reportNull$$$0(7);
        }
        String string = "<!-- section_start(" + section + ") -->";
        if (string == null) {
            DbDocumentationHelper.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String sectionEnd(@NotNull DataGridDocumentationCommand command) {
        if (command == null) {
            DbDocumentationHelper.$$$reportNull$$$0(9);
        }
        return DbDocumentationHelper.sectionEnd(command.code());
    }

    @NlsSafe
    @NotNull
    public static String sectionEnd(@NotNull String section) {
        if (section == null) {
            DbDocumentationHelper.$$$reportNull$$$0(10);
        }
        String string = "<!-- section_end(" + section + ") -->";
        if (string == null) {
            DbDocumentationHelper.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nls
    @NotNull
    public static String getRowCountSection(@Nullable Object rowCount) {
        return DbDocumentationHelper.getRowCountSection(rowCount, true);
    }

    @Nls
    @NotNull
    public static String getRowCountSection(@Nullable Object rowCount, boolean refresh) {
        @NlsSafe String closingTag = "</b>";
        String string = DbDocumentationHelper.sectionStart(DataGridDocumentationCommand.COUNT) + "<b>" + DatabaseBundle.message((String)"documentation.rows.count", (Object[])new Object[0]) + closingTag + " " + String.valueOf(rowCount == null ? "?" : rowCount) + DbDocumentationHelper.getCountCommand(refresh) + DbDocumentationHelper.sectionEnd(DataGridDocumentationCommand.COUNT);
        if (string == null) {
            DbDocumentationHelper.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static void loadTableDocumentation(boolean skipDDL, @NotNull Out sb, @NotNull ConnectionProvider provider, @NotNull DbTable element) throws Exception {
        if (sb == null) {
            DbDocumentationHelper.$$$reportNull$$$0(13);
        }
        if (provider == null) {
            DbDocumentationHelper.$$$reportNull$$$0(14);
        }
        if (element == null) {
            DbDocumentationHelper.$$$reportNull$$$0(15);
        }
        if (DbImplUtilCore.isDataTable((DasTable)element)) {
            Map<Object, Object> infoMap = Collections.emptyMap();
            try {
                infoMap = DbDocumentationHelper.tryLoadTableInfo(provider, element);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!skipDDL && DatabaseDefinitionHelper.isRawDefinitionAvailable((DbElement)element)) {
                sb.appendText((CharSequence)"<b>").appendText((CharSequence)DatabaseBundle.message((String)"documentation.definition", (Object[])new Object[0])).appendText((CharSequence)"</b><br><code><pre>");
                StringBuilder builder = new StringBuilder();
                DatabaseDefinitionHelper.loadDefinition(provider, (DbElement)element, builder);
                sb.appendText((CharSequence)DbSqlUtil.sql2Html(element.getProject(), (Language)DbSqlUtilCore.getSqlDialect((DbElement)element), builder));
                sb.appendText((CharSequence)"</pre></code>");
            }
            Object rowCount = infoMap.get("rows");
            sb.appendText((CharSequence)"<br>").appendText((CharSequence)DbDocumentationHelper.getRowCountSection(rowCount == null ? null : "~" + String.valueOf(rowCount), false)).appendText((CharSequence)"<br>");
            for (String string : infoMap.keySet()) {
                Object obj = infoMap.get(string);
                String s = obj == null ? null : String.valueOf(obj);
                if (StringUtil.isEmptyOrSpaces((String)s) || "rows".equalsIgnoreCase(string)) continue;
                sb.appendText((CharSequence)"<b>").appendText((CharSequence)string).appendText((CharSequence)":</b> ").appendText((CharSequence)s).appendText((CharSequence)"<br>");
            }
            DbDocumentationHelper.tryLoadTablePreview(sb, provider, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private static Map<String, Object> tryLoadTableInfo(@NotNull ConnectionProvider provider, @NotNull DbTable element) throws Exception {
        DatabaseDialectEx dialect;
        if (provider == null) {
            DbDocumentationHelper.$$$reportNull$$$0(16);
        }
        if (element == null) {
            DbDocumentationHelper.$$$reportNull$$$0(17);
        }
        if (!(dialect = DbImplUtilCore.getDatabaseDialect((DbElement)element)).supportsTableInfo()) {
            Map<String, Object> map = Collections.emptyMap();
            if (map == null) {
                DbDocumentationHelper.$$$reportNull$$$0(18);
            }
            return map;
        }
        if (!provider.acquire()) {
            Map<String, Object> map = Collections.emptyMap();
            Map<String, Object> map2 = map;
            if (map2 == null) {
                DbDocumentationHelper.$$$reportNull$$$0(19);
            }
            return map2;
        }
        DatabaseConnection connection2 = provider.getConnection();
        if (connection2 == null) {
            Map<String, Object> map = Collections.emptyMap();
            Map<String, Object> map3 = map;
            if (map3 == null) {
                DbDocumentationHelper.$$$reportNull$$$0(20);
            }
            return map3;
        }
        Map map = dialect.tryToLoadTableInfo(element, (DatabaseConnectionCore)provider.getConnection());
        Map map4 = map;
        if (map4 == null) {
            DbDocumentationHelper.$$$reportNull$$$0(21);
        }
        return map4;
        finally {
            provider.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tryLoadTablePreview(@NotNull Out sb, @NotNull ConnectionProvider provider, @NotNull DbTable element) throws Exception {
        int previewRows;
        if (sb == null) {
            DbDocumentationHelper.$$$reportNull$$$0(22);
        }
        if (provider == null) {
            DbDocumentationHelper.$$$reportNull$$$0(23);
        }
        if (element == null) {
            DbDocumentationHelper.$$$reportNull$$$0(24);
        }
        if ((previewRows = DatabaseSettings.getSettings().getPreviewRows()) <= 0) {
            return;
        }
        sb.appendText((CharSequence)"<br>");
        long curLength = sb.length();
        try {
            if (provider.acquire()) {
                String tableQuery = DbDocumentationHelper.getTableQuery(element, previewRows);
                DataSourceUtil.tryLoadFirstNRows("<b>" + DatabaseBundle.message((String)"documentation.first.N.rows", (Object[])new Object[0]) + "</b><br><br>", provider.getConnection(), tableQuery, sb, previewRows);
            }
        }
        finally {
            provider.release();
        }
        if (sb.length() == curLength) {
            sb.appendText((CharSequence)"<b>").appendText((CharSequence)StringUtil.capitalize((String)element.getTypeName())).appendText((CharSequence)" ").appendText((CharSequence)DatabaseBundle.message((String)"documentation.table.is.empty", (Object[])new Object[0])).appendText((CharSequence)"</b><br>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nls
    @NotNull
    public static String loadTableDocumentationRowCount(@NotNull ConnectionProvider provider, @NotNull DbTable element) throws Exception {
        if (provider == null) {
            DbDocumentationHelper.$$$reportNull$$$0(25);
        }
        if (element == null) {
            DbDocumentationHelper.$$$reportNull$$$0(26);
        }
        Long rowCount = null;
        if (provider.acquire()) {
            DatabaseConnection connection2 = provider.getConnection();
            String tableRowCountQuery = DbDocumentationHelper.getTableRowCountQuery(element);
            if (connection2 != null && tableRowCountQuery != null) {
                rowCount = DbImplUtilCore.getRowCount((DatabaseConnectionCore)connection2, (String)tableRowCountQuery);
            }
        }
        String string = DbDocumentationHelper.getRowCountSection(rowCount);
        String string2 = string;
        if (string2 == null) {
            DbDocumentationHelper.$$$reportNull$$$0(27);
        }
        return string2;
        finally {
            provider.release();
        }
    }

    private static String getTableQuery(@NotNull DbTable element, int previewRows) {
        if (element == null) {
            DbDocumentationHelper.$$$reportNull$$$0(28);
        }
        DbDataSource dataSource = element.getDataSource();
        Dbms dbms = dataSource.getDbms();
        SelectTask task = DmlTaskKt.allColumns((DasObject)element).withVirtualColumns((DasDataSource)dataSource).tableSamplingSize(DbImplUtilCore.supportsTableSampling((DasObject)dataSource, (Dbms)dbms) ? DatabaseSettings.getSettings().getTableSamplingSize() : null).version(dataSource.getVersion()).limit(previewRows).build(DbImplUtilCore.createBuilderForUIExec((Dbms)dbms, (DasObject)dataSource));
        DdlBuilder builder = ((SelectGenerationResult)DmlUtilKt.dmlGenerator((Dbms)dbms).generate((DmlTask)task)).getBuilder();
        return builder.getStatement();
    }

    private static String getTableRowCountQuery(@NotNull DbTable element) {
        if (element == null) {
            DbDocumentationHelper.$$$reportNull$$$0(29);
        }
        Project project = element.getProject();
        DbDataSource dataSource = element.getDataSource();
        Dbms dbms = dataSource.getDbms();
        String tableQuery = DbDocumentationHelper.getTableQuery(element, -1);
        String alias = DbImplUtil.findFreeAlias(project, dbms, tableQuery, "t");
        WrapInSelectTask task = DmlTaskKt.wrapInSelect((String)tableQuery, (Project)project).countAll().version(dataSource.getVersion()).alias(alias).build(DbImplUtilCore.createBuilderForUIExec((Dbms)dbms, (DasObject)dataSource));
        WrapInSelectResult result = (WrapInSelectResult)DmlUtilKt.dmlGenerator((Dbms)dbms).generate((DmlTask)task);
        return result == null ? null : result.getStatement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 8, 11, 12, 18, 19, 20, 21, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "imageSpec";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/DbDocumentationHelper";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "section";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 14: 
            case 16: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 15: 
            case 17: 
            case 24: 
            case 26: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/DbDocumentationHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createImageRefTag";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "dbSubstituteUrl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "sectionStart";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "sectionEnd";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRowCountSection";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "tryLoadTableInfo";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "loadTableDocumentationRowCount";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveImageRef";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createImageRefTag";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 27: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "dbSubstituteUrl";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractDbSubstituteSection";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "sectionStart";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "sectionEnd";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "loadTableDocumentation";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadTableInfo";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "tryLoadTablePreview";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "loadTableDocumentationRowCount";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTableQuery";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getTableRowCountQuery";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 8, 11, 12, 18, 19, 20, 21, 27 -> new IllegalStateException(string);
        };
    }
}

