/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.builder.actions.export;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphBundle;
import com.intellij.openapi.graph.builder.actions.AbstractGraphAction;
import com.intellij.openapi.graph.builder.actions.export.CopyEntireDiagramToClipboardAction;
import com.intellij.openapi.graph.builder.actions.export.ExportToFileAction;
import com.intellij.openapi.graph.builder.components.BaseGraphStructureViewBuilder;
import com.intellij.openapi.graph.impl.GraphNotifications;
import com.intellij.openapi.graph.services.GraphSelectionService;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class CopyDiagramSelectionToClipboardAction
extends AbstractGraphAction {
    public void update(@NotNull AnActionEvent e2) {
        if (e2 == null) {
            CopyDiagramSelectionToClipboardAction.F(0);
        }
        super.update(e2);
        GraphBuilder graphBuilder = this.getBuilder(e2);
        e2.getPresentation().setEnabledAndVisible(graphBuilder != null && !BaseGraphStructureViewBuilder.isLocalViewBuilder((GraphBuilder)graphBuilder));
    }

    protected void actionPerformed(@NotNull AnActionEvent e2, @NotNull Graph2D graph) {
        GraphBuilder graphBuilder;
        if (e2 == null) {
            CopyDiagramSelectionToClipboardAction.F(1);
        }
        if (graph == null) {
            CopyDiagramSelectionToClipboardAction.F(2);
        }
        if ((graphBuilder = this.getBuilder(e2)) == null) {
            return;
        }
        GraphSelectionService graphSelectionService = GraphSelectionService.getInstance();
        if (!graphSelectionService.isSelectionSuppressedFor(graphBuilder)) {
            graphSelectionService.registerOneTimeSelectionCallback(graphBuilder, CopyDiagramSelectionToClipboardAction.F(graphBuilder));
            graphSelectionService.suppressSelection(graphBuilder);
        }
        Notification notification = GraphNotifications.getGeneralGroup().createNotification(GraphBundle.message((String)"graph.select.area.you.want.to.copy.notification", (Object[])new Object[0]), NotificationType.INFORMATION);
        Notifications.Bus.notifyAndHide((Notification)notification, (Project)graphBuilder.getProject());
    }

    @NotNull
    private static Consumer<Rectangle> F(@NotNull GraphBuilder<?, ?> graphBuilder) {
        if (graphBuilder == null) {
            CopyDiagramSelectionToClipboardAction.F(3);
        }
        Consumer<Rectangle> consumer = rectangle -> {
            try {
                Image image = ExportToFileAction.exportToImage(graphBuilder, GraphBundle.message((String)"dialog.copying.to.the.clipboard", (Object[])new Object[0]), rectangle);
                CopyEntireDiagramToClipboardAction.putImageToClipboard(image);
                Notification notification = GraphNotifications.getGeneralGroup().createNotification(GraphBundle.message((String)"graph.copied.successfully.notification", (Object[])new Object[0]), NotificationType.INFORMATION);
                Notifications.Bus.notifyAndHide((Notification)notification, (Project)graphBuilder.getProject());
            }
            catch (Exception exception) {
                Notification notification = GraphNotifications.getGeneralGroup().createNotification(GraphBundle.message((String)"graph.copying.failed.notification", (Object[])new Object[0]), NotificationType.ERROR);
                Notifications.Bus.notifyAndHide((Notification)notification, (Project)graphBuilder.getProject());
                throw exception;
            }
            GraphSelectionService.getInstance().enableSelection(graphBuilder);
        };
        if (consumer == null) {
            CopyDiagramSelectionToClipboardAction.F(4);
        }
        return consumer;
    }

    private static /* synthetic */ void F(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/builder/actions/export/CopyDiagramSelectionToClipboardAction";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/builder/actions/export/CopyDiagramSelectionToClipboardAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCopySelectionCallback";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCopySelectionCallback";
                break;
            }
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

