/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.inlays;

import com.intellij.codeInsight.hints.ChangeListener;
import com.intellij.codeInsight.hints.ImmediateConfigurable;
import com.intellij.codeInsight.hints.InlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsProvider;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.NoSettings;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.kubernetes.inlays.KubernetesInlayHintsService;
import com.intellij.kubernetes.view.vfs.UtilsKt;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.ide.productMode.IdeProductMode;
import com.intellij.psi.PsiFile;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLLanguage;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0006\u0010\u0011\u001a\u00020\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J(\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020$J\"\u0010%\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020$H$J\u0010\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020\u0002H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0004J\u0010\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020+H\u0004R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u0013X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\bR\u0014\u0010\u0017\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\b\u00a8\u0006."}, d2={"Lcom/intellij/kubernetes/inlays/KubernetesYamlInlayProviderBase;", "Lcom/intellij/codeInsight/hints/InlayHintsProvider;", "Lcom/intellij/codeInsight/hints/NoSettings;", "<init>", "()V", "providerId", "", "getProviderId", "()Ljava/lang/String;", "providerDisplayName", "getProviderDisplayName", "key", "Lcom/intellij/codeInsight/hints/SettingsKey;", "getKey", "()Lcom/intellij/codeInsight/hints/SettingsKey;", "key$delegate", "Lkotlin/Lazy;", "createSettings", "isVisibleInSettings", "", "()Z", "name", "getName", "previewText", "getPreviewText", "isLanguageSupported", "language", "Lcom/intellij/lang/Language;", "getCollectorFor", "Lcom/intellij/codeInsight/hints/InlayHintsCollector;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "settings", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "getYamlCollector", "createConfigurable", "Lcom/intellij/codeInsight/hints/ImmediateConfigurable;", "ensureListenersStarted", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "intellij.clouds.kubernetes.backend"})
public abstract class KubernetesYamlInlayProviderBase
implements InlayHintsProvider<NoSettings> {
    @NotNull
    private final Lazy key$delegate = LazyKt.lazy(() -> KubernetesYamlInlayProviderBase.key_delegate$lambda$0(this));
    private final boolean isVisibleInSettings;

    public KubernetesYamlInlayProviderBase() {
        this.isVisibleInSettings = true;
    }

    @NotNull
    protected abstract String getProviderId();

    @NotNull
    protected abstract String getProviderDisplayName();

    @NotNull
    public final SettingsKey<NoSettings> getKey() {
        Lazy lazy = this.key$delegate;
        return (SettingsKey)lazy.getValue();
    }

    @NotNull
    public final NoSettings createSettings() {
        return new NoSettings();
    }

    public boolean isVisibleInSettings() {
        return this.isVisibleInSettings;
    }

    @NotNull
    public final String getName() {
        return this.getProviderDisplayName();
    }

    @NotNull
    public String getPreviewText() {
        return "";
    }

    public boolean isLanguageSupported(@NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        return language instanceof YAMLLanguage;
    }

    @Nullable
    public final InlayHintsCollector getCollectorFor(@NotNull PsiFile file, @NotNull Editor editor, @NotNull NoSettings settings, @NotNull InlayHintsSink sink) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        if (!UtilsKt.isPlainKubernetesFile(file)) {
            return null;
        }
        if (!IdeProductMode.Companion.isMonolith() && !Registry.Companion.is("kubernetes.inlays.in.split.enabled")) {
            return null;
        }
        return this.getYamlCollector(file, editor, sink);
    }

    @Nullable
    protected abstract InlayHintsCollector getYamlCollector(@NotNull PsiFile var1, @NotNull Editor var2, @NotNull InlayHintsSink var3);

    @NotNull
    public ImmediateConfigurable createConfigurable(@NotNull NoSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new ImmediateConfigurable(){

            public JComponent createComponent(ChangeListener listener) {
                Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
                return new JPanel();
            }
        };
    }

    protected final void ensureListenersStarted(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        project.getService(KubernetesInlayHintsService.class);
    }

    @NotNull
    protected final CoroutineScope coroutineScope(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object = project.getService(KubernetesInlayHintsService.class);
        Intrinsics.checkNotNull((Object)object);
        return ((KubernetesInlayHintsService)object).getCoroutineScope();
    }

    private static final SettingsKey key_delegate$lambda$0(KubernetesYamlInlayProviderBase this$0) {
        return new SettingsKey(this$0.getProviderId());
    }
}

