/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Represents a volume that is populated with the contents of a git repository. Git repo volumes do not support ownership management. Git repo volumes support SELinux relabeling.  DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.")
public class V1GitRepoVolumeSource {
    public static final String SERIALIZED_NAME_DIRECTORY = "directory";
    @SerializedName(value="directory")
    private String directory;
    public static final String SERIALIZED_NAME_REPOSITORY = "repository";
    @SerializedName(value="repository")
    private String repository;
    public static final String SERIALIZED_NAME_REVISION = "revision";
    @SerializedName(value="revision")
    private String revision;

    public V1GitRepoVolumeSource directory(String directory) {
        this.directory = directory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="directory is the target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.")
    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public V1GitRepoVolumeSource repository(String repository) {
        this.repository = repository;
        return this;
    }

    @ApiModelProperty(required=true, value="repository is the URL")
    public String getRepository() {
        return this.repository;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public V1GitRepoVolumeSource revision(String revision) {
        this.revision = revision;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="revision is the commit hash for the specified revision.")
    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1GitRepoVolumeSource v1GitRepoVolumeSource = (V1GitRepoVolumeSource)o;
        return Objects.equals(this.directory, v1GitRepoVolumeSource.directory) && Objects.equals(this.repository, v1GitRepoVolumeSource.repository) && Objects.equals(this.revision, v1GitRepoVolumeSource.revision);
    }

    public int hashCode() {
        return Objects.hash(this.directory, this.repository, this.revision);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1GitRepoVolumeSource {\n");
        sb.append("    directory: ").append(this.toIndentedString(this.directory)).append("\n");
        sb.append("    repository: ").append(this.toIndentedString(this.repository)).append("\n");
        sb.append("    revision: ").append(this.toIndentedString(this.revision)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

