/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.qodana.sarif.model.Invocation;
import com.jetbrains.qodana.sarif.model.Notification;
import com.jetbrains.qodana.sarif.model.Run;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.staticAnalysis.inspections.config.FailureConditions;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.coverageData.CoverageData;
import org.jetbrains.qodana.staticAnalysis.inspections.coverageData.CoverageStatisticsDataKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.ExitStatus;
import org.jetbrains.qodana.staticAnalysis.sarif.QodanaSeverity;
import org.jetbrains.qodana.staticAnalysis.sarif.ResultSummaryContributor;
import org.jetbrains.qodana.staticAnalysis.sarif.SarifKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u00162\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "logger$delegate", "Lkotlin/Lazy;", "FAIL_THRESHOLD_EXIT_CODE", "", "RUNTIME_ERRORS_EXIT_CODE", "BULLET_POINT", "", "firstExitStatus", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/ExitStatus;", "Lcom/jetbrains/qodana/sarif/model/Run;", "getFirstExitStatus", "(Lcom/jetbrains/qodana/sarif/model/Run;)Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/ExitStatus;", "setInvocationExitStatus", "", "run", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "checkSeverityThresholds", "Lkotlin/sequences/Sequence;", "summary", "", "checkCoverageThresholds", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaExitStatus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaExitStatus.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaExitStatusKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1761#2,3:125\n1208#2,2:128\n1236#2,4:130\n622#3:134\n13#4:135\n1#5:136\n*S KotlinDebug\n*F\n+ 1 QodanaExitStatus.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaExitStatusKt\n*L\n53#1:125,3\n80#1:128,2\n80#1:130,4\n92#1:134\n16#1:135\n*E\n"})
public final class QodanaExitStatusKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy(QodanaExitStatusKt::logger_delegate$lambda$0);
    private static final int FAIL_THRESHOLD_EXIT_CODE = 255;
    private static final int RUNTIME_ERRORS_EXIT_CODE = 70;
    @NotNull
    private static final String BULLET_POINT = "\n- ";

    private static final Logger getLogger() {
        Lazy lazy = logger$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public static final ExitStatus getFirstExitStatus(@NotNull Run $this$firstExitStatus) {
        Object invocation;
        Intrinsics.checkNotNullParameter((Object)$this$firstExitStatus, (String)"<this>");
        List list2 = $this$firstExitStatus.getInvocations();
        Invocation invocation2 = invocation;
        Invocation invocation3 = invocation;
        invocation = list2 != null ? (Invocation)CollectionsKt.firstOrNull((List)list2) : null;
        Object object = invocation;
        return new ExitStatus(object != null && (object = object.getExitCode()) != null ? (Integer)object : 0, invocation2 != null ? invocation2.getExitCodeDescription() : null, !(invocation3 != null ? Intrinsics.areEqual((Object)invocation3.getExecutionSuccessful(), (Object)false) : false));
    }

    public static final void setInvocationExitStatus(@NotNull Run run2, @NotNull QodanaConfig config) {
        Intrinsics.checkNotNullParameter((Object)run2, (String)"run");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Map<String, Integer> map2 = SarifKt.getResultSummary(run2);
        if (map2 == null) {
            boolean bl = false;
            QodanaExitStatusKt.getLogger().warn("Cannot update exit code because the result summary has not been generated. See " + Reflection.getOrCreateKotlinClass(ResultSummaryContributor.class).getQualifiedName());
            return;
        }
        Map<String, Integer> summary = map2;
        List list2 = run2.getInvocations();
        if (list2 == null || (list2 = (Invocation)CollectionsKt.singleOrNull((List)list2)) == null) {
            boolean bl = false;
            List list3 = run2.getInvocations();
            QodanaExitStatusKt.getLogger().warn("Cannot update exit code because there are " + (list3 != null ? Integer.valueOf(((Collection)list3).size()) : null) + " invocations in this run");
            return;
        }
        List invocation = list2;
        if (invocation.getExitCode() != null) {
            QodanaExitStatusKt.getLogger().info("Invocation already has an exit code, not updating");
            return;
        }
        Function1 isToolError = QodanaExitStatusKt::setInvocationExitStatus$lambda$2;
        if (config.getFailOnErrorNotification()) {
            boolean bl;
            block11: {
                List list4 = invocation.getToolExecutionNotifications();
                if (list4 == null) {
                    list4 = CollectionsKt.emptyList();
                }
                Iterable $this$any$iv = list4;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        if (!((Boolean)isToolError.invoke(element$iv)).booleanValue()) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (bl) {
                invocation.setExitCode(70);
                invocation.setExitCodeDescription(QodanaBundle.message("exit.runtime.error.notifications", new Object[0]));
                invocation.setExecutionSuccessful(false);
                return;
            }
        }
        invocation.setExecutionSuccessful(true);
        Ref.IntRef failedConditionsCount = new Ref.IntRef();
        String failedConditions = SequencesKt.joinToString$default((Sequence)SequencesKt.onEach((Sequence)SequencesKt.plus(QodanaExitStatusKt.checkSeverityThresholds(summary, config), QodanaExitStatusKt.checkCoverageThresholds(run2, config)), arg_0 -> QodanaExitStatusKt.setInvocationExitStatus$lambda$3(failedConditionsCount, arg_0)), (CharSequence)BULLET_POINT, (CharSequence)BULLET_POINT, null, (int)0, null, null, (int)60, null);
        if (failedConditionsCount.element == 0) {
            invocation.setExitCode(0);
        } else {
            invocation.setExitCode(255);
            Object[] objectArray = new Object[]{failedConditionsCount.element, failedConditions};
            invocation.setExitCodeDescription(QodanaBundle.message("exit.failure.summary", objectArray));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Sequence<String> checkSeverityThresholds(Map<String, Integer> summary, QodanaConfig config) {
        Sequence sequence;
        void $this$sortedByDescending$iv;
        void $this$associateByTo$iv$iv;
        FailureConditions thresholds = config.getFailureConditions();
        Object[] $this$associateBy$iv = (Object[])QodanaSeverity.getEntries();
        boolean $i$f$associateBy22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Object[] objectArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            QodanaSeverity qodanaSeverity = (QodanaSeverity)((Object)element$iv$iv);
            Map map2 = destination$iv$iv;
            boolean bl = false;
            String string = it.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            map2.put(string, element$iv$iv);
        }
        Map severitiesByName = destination$iv$iv;
        Sequence $i$f$associateBy22 = SequencesKt.mapNotNull((Sequence)MapsKt.asSequence(summary), arg_0 -> QodanaExitStatusKt.checkSeverityThresholds$lambda$1(severitiesByName, config, arg_0));
        boolean $i$f$sortedByDescending = false;
        Sequence failedSeverities = SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Triple triple = (Triple)b;
                boolean bl = false;
                QodanaSeverity severity = (QodanaSeverity)((Object)triple.component1());
                triple = (Triple)a;
                Comparable comparable = Integer.valueOf(severity.getWeight());
                bl = false;
                severity = (QodanaSeverity)((Object)triple.component1());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(severity.getWeight()));
            }
        }), QodanaExitStatusKt::checkSeverityThresholds$lambda$3);
        Integer n = summary.get("total");
        int totalResults = n != null ? n : 0;
        Integer totalThreshold = thresholds.getSeverityThresholds().getAny();
        if (totalThreshold != null && totalResults > totalThreshold) {
            objectArray = new Object[]{totalResults, totalThreshold};
            sequence = SequencesKt.plus((Sequence)failedSeverities, (Object)QodanaBundle.message("exit.threshold.count.exceeded", objectArray));
        } else {
            sequence = failedSeverities;
        }
        return sequence;
    }

    private static final Sequence<String> checkCoverageThresholds(Run run2, QodanaConfig config) {
        CoverageData[] coverageDataArray = new CoverageData[]{CoverageData.TOTAL_COV, CoverageData.FRESH_COV};
        return SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.sequenceOf((Object[])coverageDataArray), arg_0 -> QodanaExitStatusKt.checkCoverageThresholds$lambda$0(config, run2, arg_0)), QodanaExitStatusKt::checkCoverageThresholds$lambda$1);
    }

    private static final Logger logger_delegate$lambda$0() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ExitStatus.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final boolean setInvocationExitStatus$lambda$2(Notification it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)SarifKt.getQodanaKind(it), (Object)"toolError") && it.getLevel() == Notification.Level.ERROR;
    }

    private static final Unit setInvocationExitStatus$lambda$3(Ref.IntRef $failedConditionsCount, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int n = $failedConditionsCount.element;
        $failedConditionsCount.element = n + 1;
        return Unit.INSTANCE;
    }

    private static final Triple checkSeverityThresholds$lambda$1(Map $severitiesByName, QodanaConfig $config, Map.Entry entry) {
        Integer n;
        QodanaSeverity severity;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        String sevName = (String)entry.getKey();
        int count = ((Number)entry.getValue()).intValue();
        QodanaSeverity qodanaSeverity = severity = (QodanaSeverity)((Object)$severitiesByName.get(sevName));
        if (qodanaSeverity != null) {
            QodanaSeverity qodanaSeverity2 = qodanaSeverity;
            FailureConditions failureConditions = $config.getFailureConditions();
            QodanaSeverity p0 = qodanaSeverity2;
            boolean bl = false;
            n = failureConditions.bySeverity(p0);
        } else {
            n = null;
        }
        Integer threshold = n;
        return threshold != null && count > threshold ? new Triple((Object)severity, (Object)count, (Object)threshold) : null;
    }

    private static final String checkSeverityThresholds$lambda$3(Triple triple) {
        Intrinsics.checkNotNullParameter((Object)triple, (String)"<destruct>");
        QodanaSeverity severity = (QodanaSeverity)((Object)triple.component1());
        int count = ((Number)triple.component2()).intValue();
        int threshold = ((Number)triple.component3()).intValue();
        Object[] objectArray = new Object[]{count, severity.name(), threshold};
        return QodanaBundle.message("exit.threshold.severity.exceeded", objectArray);
    }

    private static final Triple checkCoverageThresholds$lambda$0(QodanaConfig $config, Run $run, CoverageData coverage) {
        Intrinsics.checkNotNullParameter((Object)((Object)coverage), (String)"coverage");
        Integer threshold = $config.getFailureConditions().byCoverage(coverage);
        Integer stat = CoverageStatisticsDataKt.getCoverageStats($run).get(coverage.getProp());
        return stat != null && threshold != null && stat < threshold ? new Triple((Object)coverage, (Object)stat, (Object)threshold) : null;
    }

    private static final String checkCoverageThresholds$lambda$1(Triple triple) {
        Intrinsics.checkNotNullParameter((Object)triple, (String)"<destruct>");
        CoverageData coverage = (CoverageData)((Object)triple.component1());
        int level = ((Number)triple.component2()).intValue();
        int threshold = ((Number)triple.component3()).intValue();
        Object[] objectArray = new Object[]{coverage.getTitle(), level, threshold};
        return QodanaBundle.message("exit.threshold.coverage.not.met", objectArray);
    }
}

