/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.inspections.config.InspectScope;
import org.jetbrains.qodana.staticAnalysis.profile.ProfilesKt;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001c\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH&J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaScopeModifier;", "", "scope", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScope;", "scopeName", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Lorg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScope;Ljava/lang/String;)V", "getScope", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/config/InspectScope;", "getProfileScope", "Lcom/intellij/psi/search/scope/packageSet/NamedScope;", "projectPath", "Ljava/nio/file/Path;", "getProfileScope$intellij_qodana", "updateProfileScopes", "", "profile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "project", "Lcom/intellij/openapi/project/Project;", "disableToolIfEmptyScopes", "", "tools", "Lcom/intellij/codeInspection/ex/ToolsImpl;", "intellij.qodana"})
public abstract class QodanaScopeModifier {
    @NotNull
    private final InspectScope scope;
    @NotNull
    private final String scopeName;

    public QodanaScopeModifier(@NotNull InspectScope scope2, @NotNull String scopeName) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)scopeName, (String)"scopeName");
        this.scope = scope2;
        this.scopeName = scopeName;
    }

    @NotNull
    public final InspectScope getScope() {
        return this.scope;
    }

    @NotNull
    public final NamedScope getProfileScope$intellij_qodana(@NotNull Path projectPath) {
        Intrinsics.checkNotNullParameter((Object)projectPath, (String)"projectPath");
        return ProfilesKt.createScope(this.scopeName, this.scope.getProfileScope(projectPath));
    }

    public abstract void updateProfileScopes(@NotNull QodanaInspectionProfile var1, @NotNull Project var2, @NotNull Path var3);

    protected final boolean disableToolIfEmptyScopes(@NotNull ToolsImpl tools) {
        boolean isEmptyPathsAndPatterns;
        Intrinsics.checkNotNullParameter((Object)tools, (String)"tools");
        boolean bl = isEmptyPathsAndPatterns = this.scope.getPaths().isEmpty() && this.scope.getPatterns().isEmpty();
        if (isEmptyPathsAndPatterns) {
            tools.setEnabled(false);
        }
        return isEmptyPathsAndPatterns;
    }
}

