/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public interface Version {
    @NonNls
    public static final String PLUGIN_NAME = "Lombok plugin";
    @NonNls
    public static final String LAST_LOMBOK_VERSION = "1.18.42";
    @NonNls
    public static final String LAST_LOMBOK_VERSION_WITH_JPS_FIX = "1.18.16";
    @NonNls
    public static final String LOMBOK_VERSION_WITH_JDK16_FIX = "1.18.20";
    public static final Pattern VERSION_PATTERN = Pattern.compile("(.*:)([\\d.]+)(.*)");

    public static boolean isLessThan(@Nullable String currentVersion, @Nullable String otherVersion) {
        try {
            return StringUtil.compareVersionNumbers((String)currentVersion, (String)otherVersion) < 0;
        }
        catch (NumberFormatException e) {
            Logger.getInstance(Version.class).info("Unable to parse lombok version: " + currentVersion);
            return false;
        }
    }

    @Nullable
    public static String parseLombokVersion(@Nullable OrderEntry orderEntry) {
        String presentableName;
        Matcher matcher;
        String result = null;
        if (orderEntry != null && (matcher = VERSION_PATTERN.matcher(presentableName = orderEntry.getPresentableName())).find()) {
            result = matcher.group(2);
        }
        return result;
    }
}

