/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.index;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.JSMinifiedFileIndexingProvider;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSVersionedEP;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.jsdoc.impl.JSDocCustomTags;
import com.intellij.lang.javascript.psi.resolve.BackendJSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeEvent;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.util.Consumer;
import com.intellij.util.SystemProperties;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.indexing.DefaultFileTypeSpecificWithProjectInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexedFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
public final class JavaScriptIndex {
    public static final Key<Boolean> SKIP_STUB_CREATION = Key.create((String)"js.skip.stub.creation");
    public static final FileBasedIndex.InputFilter ourIndexedFilesFilter = new DefaultFileTypeSpecificWithProjectInputFilter(new FileType[0]){
        private final int JS_SPECIFIC_FILESIZE_LIMIT = StringUtil.parseInt((String)System.getProperty("idea.js.max.intellisense.filesize"), (int)8192) << 10;
        private final int MAX_JS_FILESIZE_LIMIT = Math.max(FileUtilRt.getUserFileSizeLimit(), this.JS_SPECIFIC_FILESIZE_LIMIT);
        private final int MAX_DTS_FILESIZE_LIMIT = FileUtilRt.getUserContentLoadLimit();
        private final boolean SKIP_JAR_INDEXING = SystemProperties.getBooleanProperty((String)"idea.js.skip.jar.indexing", (boolean)false);

        public boolean acceptInput(@NotNull VirtualFile file) {
            if (file == null) {
                1.$$$reportNull$$$0(0);
            }
            return this.doAccept(file);
        }

        public boolean acceptInput(@NotNull IndexedFile indexedFile) {
            if (indexedFile == null) {
                1.$$$reportNull$$$0(1);
            }
            VirtualFile file = indexedFile.getFile();
            return this.doAccept(file);
        }

        private boolean doAccept(VirtualFile file) {
            FileType fileType = file.getFileType();
            if (!JavaScriptIndex.getFileTypesToIndexJS().contains(fileType)) {
                return false;
            }
            if ((fileType == HtmlFileType.INSTANCE || this.SKIP_JAR_INDEXING) && file.getFileSystem().getProtocol().equals("jar")) {
                return false;
            }
            String name = file.getName();
            int cacheIndex = name.indexOf(".cache.");
            if (cacheIndex != -1 && name.endsWith(".js")) {
                boolean justHexDigits = cacheIndex > 0;
                for (int i = 0; i < cacheIndex && justHexDigits; ++i) {
                    justHexDigits = StringUtil.isHexDigit((char)name.charAt(i));
                }
                if (justHexDigits) {
                    return false;
                }
            }
            if (1.isMinifiedCopy(file)) {
                return false;
            }
            if (Boolean.TRUE.equals(file.getUserData(SKIP_STUB_CREATION))) {
                return false;
            }
            if (SingleRootFileViewProvider.fileSizeIsGreaterThan((VirtualFile)file, (long)this.getLimitByFile(file))) {
                return false;
            }
            if (JSMinifiedFileUtil.isFileContentMinified(file)) {
                for (JSMinifiedFileIndexingProvider isMinifiedProvider : JSMinifiedFileIndexingProvider.EP_NAME.getExtensionList()) {
                    if (!isMinifiedProvider.shouldIndexMinifiedFile(file)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }

        private int getLimitByFile(@NotNull VirtualFile file) {
            if (file == null) {
                1.$$$reportNull$$$0(2);
            }
            if (TypeScriptUtil.isDefinitionFile((VirtualFile)file)) {
                return this.MAX_DTS_FILESIZE_LIMIT;
            }
            return this.MAX_JS_FILESIZE_LIMIT;
        }

        private static boolean isMinifiedCopy(@NotNull VirtualFile file) {
            String devName;
            String name;
            if (file == null) {
                1.$$$reportNull$$$0(3);
            }
            return !StringUtil.equals((CharSequence)(name = file.getName()), (CharSequence)(devName = JSLibraryUtil.getDevVersionLocation((String)name, (boolean)false))) && file.getParent() != null && file.getParent().findChild(devName) != null;
        }

        public void registerFileTypesUsedForIndexing(@NotNull Consumer<? super FileType> fileTypeSink) {
            if (fileTypeSink == null) {
                1.$$$reportNull$$$0(4);
            }
            for (FileType ft : JavaScriptIndex.getFileTypesToIndexJS()) {
                fileTypeSink.consume((Object)ft);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indexedFile";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileTypeSink";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/index/JavaScriptIndex$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "acceptInput";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLimitByFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMinifiedCopy";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerFileTypesUsedForIndexing";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    private static final Comparator<JSVersionedEP> COMPARING_JS_VERSIONED_EP_BY_CLASS = Comparator.comparing(JSVersionedEP::getImplementationClassName);
    private final Project myProject;
    private static final SynchronizedClearableLazy<Set<FileType>> ourFileTypesToIndexJS = new SynchronizedClearableLazy(() -> {
        HashSet<Object> fileTypesForJSCompletion = new HashSet<Object>();
        fileTypesForJSCompletion.add(HtmlFileType.INSTANCE);
        for (FileType type2 : FileTypeRegistry.getInstance().getRegisteredFileTypes()) {
            Language language;
            if (!(type2 instanceof LanguageFileType) || !(language = ((LanguageFileType)type2).getLanguage()).isKindOf((Language)JavascriptLanguage.INSTANCE) && !language.isKindOf((Language)HTMLLanguage.INSTANCE) && (!(language instanceof TemplateLanguage) || LanguageParserDefinitions.INSTANCE.forLanguage(language) == null)) continue;
            fileTypesForJSCompletion.add(type2);
        }
        return fileTypesForJSCompletion;
    });

    @NotNull
    public static Set<FileType> getFileTypesToIndexJS() {
        Set set = (Set)ourFileTypesToIndexJS.getValue();
        if (set == null) {
            JavaScriptIndex.$$$reportNull$$$0(0);
        }
        return set;
    }

    public JavaScriptIndex(Project project) {
        this.myProject = project;
    }

    public static int getVersion(int stubVersion, int additionalVersion) {
        int versionAcc = 0;
        versionAcc += 3 * stubVersion;
        versionAcc += 5 * additionalVersion;
        ArrayList<JSVersionedEP> extensionList = new ArrayList<JSVersionedEP>(FrameworkIndexingHandler.EP_NAME.getExtensionList());
        extensionList.addAll(JSDocCustomTags.EP_NAME.getExtensionList());
        extensionList.sort(COMPARING_JS_VERSIONED_EP_BY_CLASS);
        for (JSVersionedEP ep : extensionList) {
            String className = ep.getImplementationClassName();
            versionAcc += className != null ? 7 * className.codePoints().sum() : 0;
            versionAcc += 11 * ep.getVersion();
        }
        versionAcc += 26;
        return versionAcc += 68;
    }

    public static boolean isAcceptableFile(VirtualFile fileOrDir) {
        return fileOrDir != null && !fileOrDir.isDirectory() && ourIndexedFilesFilter.acceptInput(fileOrDir);
    }

    public static JavaScriptIndex getInstance(Project project) {
        return (JavaScriptIndex)project.getService(JavaScriptIndex.class);
    }

    public NavigationItem[] getFileByName(String name, boolean includeNonProjectItems) {
        return FilenameIndex.getFilesByName((Project)this.myProject, (String)name, (GlobalSearchScope)this.getCollectScope(includeNonProjectItems));
    }

    private GlobalSearchScope getCollectScope(boolean includeNonProjectItems) {
        return includeNonProjectItems ? JSResolveUtil.getJavaScriptSymbolsResolveScope((Project)this.myProject) : ProjectScope.getContentScope((Project)this.myProject);
    }

    public Project getProject() {
        return this.myProject;
    }

    public NavigationItem @NotNull [] getSymbolsByName(String name, boolean includeNonProjectItems) {
        return this.processSymbols(name, includeNonProjectItems, false);
    }

    private NavigationItem @NotNull [] processSymbols(String name, boolean includeNonProjectItems, boolean justClasses) {
        GlobalSearchScope scope2 = this.getCollectScope(includeNonProjectItems);
        Collection symbolNavItems = JSClassResolver.findElementsByNameIncludingImplicit((String)name, (GlobalSearchScope)scope2, (boolean)justClasses);
        if (!justClasses) {
            Collection<JSQualifiedNamedElement> qualified = BackendJSResolveUtil.findElementsByName(name, this.myProject, scope2);
            Iterator<JSQualifiedNamedElement> q = qualified.iterator();
            while (q.hasNext()) {
                JSQualifiedNamedElement element2 = q.next();
                if (JavaScriptIndex.isFromSwc(element2)) continue;
                q.remove();
            }
            symbolNavItems.addAll(qualified);
        }
        NavigationItem[] navigationItemArray = symbolNavItems.toArray(NavigationItem.EMPTY_NAVIGATION_ITEM_ARRAY);
        if (navigationItemArray == null) {
            JavaScriptIndex.$$$reportNull$$$0(1);
        }
        return navigationItemArray;
    }

    private static boolean isFromSwc(JSQualifiedNamedElement element2) {
        return element2.getContainingFile().getVirtualFile().getName().endsWith(".swf");
    }

    public NavigationItem[] getClassByName(String name, boolean includeNonProjectItems) {
        return this.processSymbols(name, includeNonProjectItems, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/index/JavaScriptIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileTypesToIndexJS";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "processSymbols";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static final class MyFileTypeListener
    implements FileTypeListener {
        public void beforeFileTypesChanged(@NotNull FileTypeEvent event) {
            if (event == null) {
                MyFileTypeListener.$$$reportNull$$$0(0);
            }
            ourFileTypesToIndexJS.drop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/index/JavaScriptIndex$MyFileTypeListener", "beforeFileTypesChanged"));
        }
    }
}

