/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.template.postfix;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.intentions.destructuring.JSGenerateDestructuringPatternIntention;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSNoBalloonIntroduceVariableHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.Settings;
import com.intellij.lang.javascript.template.postfix.JSIntroduceVarPostfixTemplate;
import com.intellij.lang.javascript.template.postfix.JSPostfixTemplateUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class JSDestructAllPostfixTemplate
extends JSIntroduceVarPostfixTemplate {
    private static final String TEMP_VAR_NAME = "_tmp_webstorm_";

    public JSDestructAllPostfixTemplate() {
        super("destructAll", "let {x: [first, second]} = {x: [1, 2]}", JSPostfixTemplateUtils.selectorWithFeature(JSPostfixTemplateUtils.selectorAllExpressionsWithCurrentOffset((Condition<PsiElement>)((Condition)JSDestructAllPostfixTemplate::canDestruct)), JSLanguageFeature.LET_DEFINITIONS, null));
    }

    private static boolean canDestruct(PsiElement element2) {
        if (!(element2 instanceof JSExpression)) {
            return false;
        }
        if (!(element2.getParent() instanceof JSExpressionStatement)) {
            return false;
        }
        if (element2 instanceof JSReferenceExpression && JSResolveUtil.isExprInStrictTypeContext((JSReferenceExpression)((JSReferenceExpression)element2))) {
            return false;
        }
        return JSGenerateDestructuringPatternIntention.isApplicableType(TypeScriptTypeRelations.expandAndOptimizeExpressionTypeRecursive((JSExpression)((JSExpression)element2)), true);
    }

    @Override
    @NotNull
    protected Settings.IntroducedVarType getIntroduceVarType() {
        Settings.IntroducedVarType introducedVarType = Settings.IntroducedVarType.LET;
        if (introducedVarType == null) {
            JSDestructAllPostfixTemplate.$$$reportNull$$$0(0);
        }
        return introducedVarType;
    }

    @Override
    @NotNull
    protected JSNoBalloonIntroduceVariableHandler createHandler(PsiElement context2, Editor editor) {
        return this.doCreateHandler(context2, editor);
    }

    @NotNull
    private JSNoBalloonIntroduceVariableHandler doCreateHandler(PsiElement context2, Editor editor) {
        final PsiFile file = context2.getContainingFile();
        final Project project = context2.getProject();
        return new JSNoBalloonIntroduceVariableHandler(){

            @Override
            protected Settings.IntroducedVarType getDefaultIntroduceType(PsiElement scope2) {
                return JSDestructAllPostfixTemplate.this.getIntroduceVarType();
            }

            @Override
            @NotNull
            protected Expression createCustomTemplateExpression(PsiElement selectedElement) {
                return new ConstantNode(JSDestructAllPostfixTemplate.TEMP_VAR_NAME);
            }

            @Override
            protected void afterIntroduce(boolean isInPlace, PsiElement scope2, Editor editor) {
                new JSGenerateDestructuringPatternIntention().invoke(project, editor, file);
            }
        };
    }

    @Override
    protected JSIntroduceVariableHandler getMockHandlerForTestMode(PsiElement context2, Editor editor) {
        return this.doCreateHandler(context2, editor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/template/postfix/JSDestructAllPostfixTemplate", "getIntroduceVarType"));
    }
}

