/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.snapshot;

import com.intellij.jpa.jpb.model.model.CollectionTableAttribute;
import com.intellij.jpa.jpb.model.orm.jpa.JpaOrmFramework;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.liquibase.common.LiquibaseModelObjectFactory;
import com.intellij.liquibase.common.ddl.LiquibaseGenerator;
import com.intellij.liquibase.common.ddl.model.JIndex;
import com.intellij.liquibase.common.ddl.model.JSoftDeleteIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import liquibase.exception.DatabaseException;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.ext.intellij.snapshot.IntellijSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;

public class IndexSnapshotGenerator
extends IntellijSnapshotGenerator {
    public IndexSnapshotGenerator() {
        super(Index.class, new Class[]{Table.class, ForeignKey.class, UniqueConstraint.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (example.getSnapshotId() != null) {
            return example;
        }
        Index exampleIndex = (Index)example;
        Relation table = exampleIndex.getRelation();
        OrmEntity entity = this.findOrmEntity((DatabaseObject)table, snapshot);
        if (entity == null) {
            return example;
        }
        IntellijDatabase database = (IntellijDatabase)snapshot.getDatabase();
        LiquibaseGenerator liquibaseGenerator = database.getLiquibaseGenerator();
        LiquibaseModelObjectFactory dbObjectFactory = database.getDbObjectFactory();
        List<JIndex> indexes = liquibaseGenerator.generateIndexes(entity);
        for (JIndex prjIndex : indexes) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)exampleIndex.getName(), (CharSequence)prjIndex.getName())) continue;
            Index index = new Index();
            index.setRelation(table);
            index.setName(prjIndex.getName());
            index.setUnique(Boolean.valueOf(prjIndex.isUnique()));
            prjIndex.getColumns().forEach(s -> index.getColumns().add(dbObjectFactory.createIndexColumn((String)s).setRelation(table)));
            if (prjIndex instanceof JSoftDeleteIndex) {
                String softDeleteColumnName = ((JSoftDeleteIndex)prjIndex).getSoftDeleteColumn();
                Column softDeleteColumn = dbObjectFactory.createIndexColumn(softDeleteColumnName).setRelation(table);
                index.addColumn(softDeleteColumn);
                index.setAttribute("softDeleteColumn", (Object)softDeleteColumn.getName());
            }
            if (!index.getColumnNames().equalsIgnoreCase(exampleIndex.getColumnNames())) continue;
            LOG.info("Found index " + index.getName());
            table.getIndexes().add(index);
            return index;
        }
        return example;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(Index.class)) {
            return;
        }
        IntellijDatabase database = (IntellijDatabase)snapshot.getDatabase();
        if (database.getOrmFramework() != JpaOrmFramework.INSTANCE) {
            return;
        }
        LiquibaseGenerator liquibaseGenerator = database.getLiquibaseGenerator();
        LiquibaseModelObjectFactory dbObjectFactory = database.getDbObjectFactory();
        if (foundObject instanceof Table) {
            Table table = (Table)foundObject;
            List<JIndex> jIndexes = null;
            OrmEntity entity = this.findOrmEntity((DatabaseObject)table, snapshot);
            if (entity != null) {
                jIndexes = liquibaseGenerator.generateIndexes(entity);
            } else {
                CollectionTableAttribute collectionTableAttribute = liquibaseGenerator.findCollectionTableAttribute(table.getName(), database.getOrmEntitiesToProcess());
                if (collectionTableAttribute != null) {
                    jIndexes = liquibaseGenerator.generateCollectionTableIndexes(table.getName(), collectionTableAttribute.getEntity(), collectionTableAttribute.getAttribute());
                }
            }
            if (jIndexes == null) {
                return;
            }
            for (JIndex prjIndex : jIndexes) {
                Index index = new Index();
                index.setRelation((Relation)table);
                index.setName(prjIndex.getName());
                index.setUnique(Boolean.valueOf(prjIndex.isUnique()));
                for (String column : prjIndex.getColumns()) {
                    Column indexColumn = dbObjectFactory.createIndexColumn(column).setRelation((Relation)table);
                    if (!ContainerUtil.exists((Iterable)table.getColumns(), tableColumn -> tableColumn.getName().equalsIgnoreCase(indexColumn.getName()))) {
                        throw new IllegalStateException("Column for index is not found. Table - " + table.getName() + "; Column - " + indexColumn.getName());
                    }
                    index.getColumns().add(indexColumn);
                }
                if (prjIndex instanceof JSoftDeleteIndex) {
                    String softDeleteColumnName = ((JSoftDeleteIndex)prjIndex).getSoftDeleteColumn();
                    Column softDeleteColumn = dbObjectFactory.createIndexColumn(softDeleteColumnName).setRelation((Relation)table);
                    index.addColumn(softDeleteColumn);
                    index.setAttribute("softDeleteColumn", (Object)softDeleteColumn.getName());
                }
                LOG.info("Found index " + index.getName());
                table.getIndexes().add(index);
            }
        }
    }
}

