/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.rml.ast;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.rml.dfa.impl.domains.Domain;
import com.intellij.rml.dfa.impl.relations.IRelation;
import com.intellij.rml.dfa.impl.relations.IRelationsManager;
import com.intellij.rml.dfa.impl.rml.DomainsPool;
import com.intellij.rml.dfa.impl.rml.ast.Context;
import com.intellij.rml.dfa.impl.rml.ast.QueryNode;
import com.intellij.rml.dfa.impl.rml.ast.RelExpr;
import com.intellij.rml.dfa.impl.rml.ast.RelExprTransformer;
import com.intellij.rml.dfa.impl.rml.ast.RelExprVisitor;
import com.intellij.rml.dfa.impl.rml.profiler.RmlProfileManager;
import com.intellij.rml.dfa.impl.scripts.RuntimeVariablesManager;
import com.intellij.rml.dfa.impl.symtable.SymbolTable;
import com.intellij.rml.dfa.impl.ui.UIInstancesProvider;
import com.intellij.rml.dfa.utils.Cancellation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.IntStream;

public class RelExprVar
extends RelExpr {
    public static final int DOMAIN = 0;
    public static final int ATTRIBUTE = 1;
    public static final int UNDERSCORE = 2;
    public static final int REGEXP = 3;
    private final String relname;
    private final String[] values;
    private final int[] flags;
    private boolean fastRename;

    public RelExprVar(String relname, String[] values, int[] flags, Context context) {
        super(context, new QueryNode[0]);
        this.relname = relname;
        this.values = values;
        this.flags = flags;
        this.fastRename = true;
        for (int flag : flags) {
            if (flag == 0) continue;
            this.fastRename = false;
            break;
        }
    }

    public RelExprVar(String relname, String[] values, Context context) {
        super(context, new QueryNode[0]);
        this.relname = relname;
        this.values = values;
        this.fastRename = true;
        this.flags = new int[values.length];
        Arrays.fill(this.flags, 0);
    }

    public String getRelName() {
        return this.relname;
    }

    public String[] getValues() {
        return this.values;
    }

    public int[] getFlags() {
        return this.flags;
    }

    public int getValuesCnt() {
        return this.values.length;
    }

    public String getValue(int index) {
        return this.values[index];
    }

    public int getFlag(int index) {
        return this.flags[index];
    }

    @Override
    public void accept(RelExprVisitor visitor2) {
        visitor2.visitVar(this);
    }

    @Override
    public RelExpr transform(RelExprTransformer transformer) {
        return transformer.transformVar(this);
    }

    @Override
    public Domain[] getDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        ArrayList<Domain> domains = new ArrayList<Domain>();
        for (int i = 0; i < this.values.length; ++i) {
            if (this.flags[i] != 0) continue;
            domains.add(variablesManager.getDomain(this.values[i]));
        }
        return domains.toArray(new Domain[0]);
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, RmlProfileManager profileManager2) {
        IRelation cached = variablesManager.getRelation(this.getResultCacheRelName(), cancellation);
        if (this.canBeCached && cached != null) {
            return cached.getClone();
        }
        IRelation result = this.applyParameters(relationsManager, variablesManager, cancellation, symbolTable, true);
        variablesManager.storeRelation(this.getResultCacheRelName(), result.getClone());
        return result;
    }

    public IRelation applyParameters(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, Cancellation cancellation, SymbolTable symbolTable, boolean removeDomains) {
        IRelation result = relationsManager.makeRepositoryRelation(variablesManager.getRelation(this.relname, cancellation), this.relname);
        if (this.fastRename) {
            Domain[] domains = new Domain[this.values.length];
            for (int i = 0; i < domains.length; ++i) {
                domains[i] = variablesManager.getDomain(this.values[i]);
            }
            IRelation oldResult = result;
            result = result.fastRename(domains, cancellation);
            oldResult.kill();
        } else {
            for (int i = this.values.length - 1; i >= 0; --i) {
                IRelation oldResult = result;
                if (this.flags[i] == 1) {
                    Domain domain = result.getDomain(i);
                    int attr = symbolTable.getAttributeInt(domain.getType(), this.values[i]);
                    if (removeDomains) {
                        result = result.project(i, attr, cancellation);
                    } else {
                        Domain newDomain = variablesManager.getDomain(this.relname + i);
                        result = result.rename(i, newDomain, cancellation);
                        result = result.unsafeIntersect(relationsManager.makeSingleTuple(newDomain, attr), cancellation);
                    }
                } else if (this.flags[i] == 2) {
                    if (removeDomains) {
                        result = result.exists(i, cancellation);
                    } else {
                        Domain newDomain = variablesManager.getDomain(this.relname + i);
                        result = result.rename(i, newDomain, cancellation);
                    }
                } else if (this.flags[i] == 3) {
                    IRelation filter2 = relationsManager.makeRegExprSet(result.getDomain(i), this.values[i], cancellation);
                    if (removeDomains) {
                        result = result.relprod(filter2, result.getDomain(i), cancellation);
                    } else {
                        Domain newDomain = variablesManager.getDomain(this.relname + i);
                        result = result.rename(i, newDomain, cancellation);
                        result = result.unsafeIntersect(filter2, cancellation);
                    }
                } else if (this.flags[i] == 0) {
                    result = result.rename(i, variablesManager.getDomain(this.values[i]), cancellation);
                }
                oldResult.kill();
            }
        }
        return result;
    }

    public Domain getDomain(RuntimeVariablesManager variablesManager, int index) {
        return variablesManager.getRelationDomains(this.relname)[index];
    }

    public String getDomainName(int index) {
        return this.flags[index] == 0 ? this.values[index] : "_";
    }

    @Override
    public String toLongString() {
        return "RelExprVar{relname='" + this.relname + "', values=" + Arrays.toString(this.values) + ", flags=" + Arrays.toString(this.flags) + ", fastRename=" + this.fastRename + "}";
    }

    @Override
    public String toShortString() {
        return this.relname + "(" + (String)IntStream.range(0, this.values.length).mapToObj(i -> this.flags[i] == 2 ? "_" : this.values[i]).collect(StringUtil.joining()) + ")";
    }
}

